/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyGroup;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.impl.SoftwareComponentImpl;
import com.sas.metadata.remote.impl.SoftwareComponentImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.ApplicationInterface;
import com.sas.services.information.metadata.Folder;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRSoftwareComponent;
import com.sas.services.security.ApplicationAuthorization;
import com.sas.services.util.UpgradeInterface;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Application
extends OMRSoftwareComponent
implements ApplicationInterface,
LocalizableProperties,
UpgradeInterface {
    private static final long serialVersionUID = 1L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    private static final String GRID_CAPABLE_PROPERTYNAME = "IsGridCapable";

    public Application() throws RemoteException {
    }

    protected Application(Class theClass) throws RemoteException {
        super(theClass);
    }

    protected Application(Object o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    public Application(Application o) throws RemoteException {
        super(o, Application.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public Application(SoftwareComponentImpl o) throws RemoteException {
        super(o, Application.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public Application(SoftwareComponentImpl_Stub o) throws RemoteException {
        super(o, Application.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public Application(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        super(repos, name, parent);
    }

    @Override
    public String getType() throws RemoteException {
        return "Application";
    }

    @Override
    public ApplicationInterface getParentApplication() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        SoftwareComponent app = (SoftwareComponent)this._repositoryObject;
        try {
            AssociationList members = app.getImplementedObjects();
            if (members.isEmpty()) {
                return null;
            }
            if (!(members.get(0) instanceof SoftwareComponent)) {
                throw new ServiceException("Unexpected object in ImplementedObjects association of application " + this.getName());
            }
            return (ApplicationInterface)this._repository.factoryProcess(members.get(0));
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public Map<String, ApplicationAuthorization> getActions() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        HashMap<String, ApplicationAuthorization> actions = new HashMap<String, ApplicationAuthorization>();
        MetadataServerInterface server = (MetadataServerInterface)this._repository.getServer();
        for (ApplicationAuthorization action : server.getApplicationActionsAuthorizations(this)) {
            actions.put(action.getActionIdentifier(), action);
        }
        return actions;
    }

    public PropertyList getLocalizableProperties() throws UnexpectedLocalizationException {
        if (!this._isCompatible) {
            return null;
        }
        PropertyList list = null;
        try {
            list = new PropertyList();
            list.addProperty("Description", this.getDescription());
            Iterator iter = this.getSoftwareTrees().iterator();
            int idx = 1;
            while (iter.hasNext()) {
                MetadataInterface tree = (MetadataInterface)iter.next();
                if (!(tree instanceof Folder)) continue;
                String treeName = tree.getName();
                PropertyList folderList = ((Folder)tree).getDefaultLocalizableProperties();
                list.addProperty(treeName, idx, folderList);
                ++idx;
                this.getSubTrees(tree, list, treeName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    private void getSubTrees(MetadataInterface tree, PropertyList list, String path) throws ServiceException, RemoteException {
        Iterator subIter = ((FolderInterface)tree).getSubfolders().iterator();
        int idx = 1;
        while (subIter.hasNext()) {
            MetadataInterface subTree = (MetadataInterface)subIter.next();
            String objDesc = path + "." + subTree.getName();
            if (subTree instanceof Folder) {
                PropertyList subFolderList = ((Folder)subTree).getLocalizableProperties();
                list.addProperty(objDesc, idx, subFolderList);
                Iterator aaIter = ((FolderInterface)subTree).getItemsByType("ApplicationAction").iterator();
                int aaIdx = 1;
                while (aaIter.hasNext()) {
                    Metadata aa = (Metadata)aaIter.next();
                    PropertyList aaList = aa.getDefaultLocalizableProperties();
                    list.addProperty(objDesc + ".ApplicationAction", aaIdx, aaList);
                    ++aaIdx;
                }
            }
            ++idx;
            this.getSubTrees(subTree, list, objDesc);
        }
    }

    public void setLocalizableProperties(PropertyMap map) throws UnexpectedLocalizationException {
        if (!this._isCompatible) {
            return;
        }
        try {
            this.setDefaultLocalizableProperties(map);
            Iterator iter = this.getSoftwareTrees().iterator();
            int idx = 1;
            while (iter.hasNext()) {
                MetadataInterface tree = (MetadataInterface)iter.next();
                if (tree instanceof Metadata) {
                    CMetadata omrTree = (CMetadata)tree.getRepositoryEntity();
                    String objName = tree.getName();
                    if (map.containsIndexedNestedProperty(objName, idx)) {
                        PropertyMap props = map.getNestedProperties(objName, idx);
                        if (props.containsProperty("Name")) {
                            omrTree.setName(props.getProperty("Name"));
                        }
                        if (props.containsProperty("Description")) {
                            omrTree.setDesc(props.getProperty("Description"));
                        }
                    }
                    this.setSubTreeLocalizedProperties(tree, map, objName);
                }
                ++idx;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cleanProperty(Property property, String value, String classIdentifier) throws RemoteException, MdException {
        property.setDefaultValue(value);
        Prototype guidef = (Prototype)property.getUsingPrototype();
        if (null != guidef) {
            AssociationList implementors = guidef.getImplementors();
            if (implementors != null && !implementors.isEmpty()) {
                DeployedComponent dc = (DeployedComponent)implementors.get(0);
                dc.setClassIdentifier(classIdentifier);
            }
            AssociationList guidefProperties = guidef.getProperties();
            Iterator itrtr = guidefProperties.iterator();
            while (itrtr.hasNext()) {
                Property p = (Property)itrtr.next();
                if (!"ValidValue".equals(p.getName()) && !"ValidValue".equals(p.getPropertyName())) continue;
                itrtr.remove();
                p.delete();
            }
        }
    }

    @Override
    public void upgradeFromPreviousVersion() throws RemoteException, ServiceException {
        try {
            SoftwareComponent component = (SoftwareComponent)this.getRepositoryEntity();
            AssociationList propertyGroups = component.getPropertyGroups();
            Iterator it = propertyGroups.iterator();
            while (it.hasNext()) {
                PropertyGroup propertyGroup = (PropertyGroup)it.next();
                if (!"Application Configuration".equals(propertyGroup.getName())) continue;
                AssociationList properties = propertyGroup.getGroupedProperties();
                RepositoryInterface repository = this.getRepository();
                MetadataInterface newPropertySet = repository.newMetadata(null, "Application Configuration", "PropertySet");
                PropertySet propertySet = (PropertySet)newPropertySet.getRepositoryEntity();
                propertySet.setPropertySetName("Application Configuration");
                propertySet.setOwningObject((Root)component);
                AssociationList setProperties = propertySet.getSetProperties();
                Iterator itr = properties.iterator();
                while (itr.hasNext()) {
                    Property property = (Property)itr.next();
                    itr.remove();
                    if ("Format.Time".equals(property.getPropertyName()) || "Format.Time".equals(property.getName())) {
                        this.cleanProperty(property, "NLTIMENS", "com.sas.preferences.editors.TimeFormatEditor");
                    } else if ("Format.TimeDate".equals(property.getPropertyName()) || "Format.TimeDate".equals(property.getName())) {
                        this.cleanProperty(property, "NLDATM", "com.sas.preferences.editors.TimeDateFormatEditor");
                    } else if ("Format.ShortDate".equals(property.getPropertyName()) || "Format.ShortDate".equals(property.getName())) {
                        this.cleanProperty(property, "NLDATE2", "com.sas.preferences.editors.ShortDateFormatEditor");
                    } else if ("Format.LongDate".equals(property.getPropertyName()) || "Format.LongDate".equals(property.getName())) {
                        this.cleanProperty(property, "NLDATEW", "com.sas.preferences.editors.LongDateFormatEditor");
                    }
                    setProperties.add((Object)property);
                }
                it.remove();
                propertyGroup.delete();
            }
            component.updateMetadataAll();
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void setSubTreeLocalizedProperties(MetadataInterface parent, PropertyMap map, String path) throws ServiceException, RemoteException {
        Iterator iter = ((FolderInterface)parent).getSubfolders().iterator();
        int idx = 1;
        while (iter.hasNext()) {
            MetadataInterface tree = (MetadataInterface)iter.next();
            String objName = path + "." + tree.getName();
            if (tree instanceof Metadata) {
                CMetadata omrTree = (CMetadata)tree.getRepositoryEntity();
                if (map.containsIndexedNestedProperty(objName, idx)) {
                    PropertyMap props = map.getNestedProperties(objName, idx);
                    if (props.containsProperty("Name")) {
                        omrTree.setName(props.getProperty("Name"));
                    }
                    if (props.containsProperty("Description")) {
                        omrTree.setDesc(props.getProperty("Description"));
                    }
                }
                Iterator aaIter = ((Folder)tree).getItemsByType("ApplicationAction").iterator();
                int aaIdx = 1;
                while (aaIter.hasNext()) {
                    Metadata aa = (Metadata)aaIter.next();
                    CMetadata omraa = (CMetadata)aa.getRepositoryEntity();
                    if (map.containsIndexedNestedProperty(objName + ".ApplicationAction", aaIdx)) {
                        PropertyMap props = map.getNestedProperties(objName + ".ApplicationAction", aaIdx);
                        if (props.containsProperty("Name")) {
                            omraa.setName(props.getProperty("Name"));
                        }
                        if (props.containsProperty("Description")) {
                            omraa.setDesc(props.getProperty("Description"));
                        }
                    }
                    ++aaIdx;
                }
            }
            ++idx;
        }
    }

    @Override
    public boolean isGridCapable() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        SoftwareComponent app = (SoftwareComponent)this._repositoryObject;
        try {
            AssociationList properties = app.getProperties();
            for (Property property : properties) {
                if (!GRID_CAPABLE_PROPERTYNAME.equals(property.getPropertyName())) continue;
                return Boolean.parseBoolean(property.getDefaultValue());
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return false;
    }

    @Override
    public void setGridCapable(boolean gridCapable) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        SoftwareComponent app = (SoftwareComponent)this._repositoryObject;
        try {
            Property gridCapableProperty = null;
            AssociationList properties = app.getProperties();
            for (Property property : properties) {
                if (!GRID_CAPABLE_PROPERTYNAME.equals(property.getPropertyName())) continue;
                gridCapableProperty = property;
                break;
            }
            if (gridCapable) {
                if (gridCapableProperty == null) {
                    gridCapableProperty = (Property)((OMIRepositoryInterface)this._repository).createMetadata(GRID_CAPABLE_PROPERTYNAME, "Property");
                    gridCapableProperty.setAssociatedObject((Root)app);
                    gridCapableProperty.setPropertyName(GRID_CAPABLE_PROPERTYNAME);
                }
                gridCapableProperty.setDefaultValue("true");
            } else if (gridCapableProperty != null) {
                gridCapableProperty.delete();
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }
}

