/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.cache;

import com.sas.services.cache.CacheEntry;
import com.sas.services.cache.impl.BaseCacheEntry;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.cache.MapRepositoryCache;
import com.sas.services.information.cache.RepositoryCache;
import com.sas.services.information.metadata.DavPerson;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PersonalRepository;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DAVRepositoryCache
extends MapRepositoryCache
implements RepositoryCache {
    private long hits = 0L;
    private long hitmiss = 0L;
    private long misses = 0L;
    private long nearmisses = 0L;
    private long puts = 0L;
    private String _reposURL;

    public DAVRepositoryCache(Map env) {
        super(env);
    }

    @Override
    public synchronized void put(MetadataInterface entity) {
        Logger logger = LogManager.getLogger((String)"com.sas.services.information.DAVRepositoryCache");
        try {
            String reposId = this.stripType(entity.getReposId());
            BaseCacheEntry ce = null;
            ce = entity instanceof DavPerson || entity instanceof PersonalRepository ? new BaseCacheEntry((Object)reposId, (Object)entity, 86400000L) : new BaseCacheEntry((Object)reposId, (Object)entity, this.timeToLive);
            super.put((Object)reposId, (Object)ce);
            if (logger != null && logger.isDebugEnabled()) {
                logger.debug("CACHE PUT: " + this._reposURL + ' ' + reposId);
            }
            ++this.puts;
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public MetadataInterface get(String reposId) {
        Logger logger = LogManager.getLogger((String)"com.sas.services.information.DAVRepositoryCache");
        CacheEntry ce = (CacheEntry)super.get((Object)(reposId = this.stripType(reposId)));
        if (ce == null) {
            ++this.misses;
            if (logger != null && logger.isDebugEnabled()) {
                logger.debug("CACHE MISS: " + this._reposURL + ' ' + reposId);
            }
            return null;
        }
        MetadataInterface mi = (MetadataInterface)ce.getValue();
        if (!ce.isValid()) {
            ++this.nearmisses;
            if (logger != null && logger.isDebugEnabled()) {
                logger.debug("CACHE NEARMISS: " + this._reposURL + ' ' + reposId);
            }
            try {
                mi.refresh();
                ((BaseCacheEntry)ce).updateExpirationTime(-1L);
            }
            catch (Exception ex) {
                return null;
            }
        } else if (mi != null) {
            if (logger != null && logger.isDebugEnabled()) {
                logger.debug("CACHE HIT: " + this._reposURL + ' ' + reposId);
            }
            ++this.hits;
        } else {
            if (logger != null && logger.isDebugEnabled()) {
                logger.debug("CACHE HITMISS: " + this._reposURL + ' ' + reposId);
            }
            ++this.hitmiss;
        }
        return mi;
    }

    public synchronized void remove(String reposId) {
        Logger logger = LogManager.getLogger((String)"com.sas.services.information.DAVRepositoryCache");
        reposId = this.stripType(reposId);
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug("CACHE REMOVE: " + this._reposURL + ' ' + reposId);
        }
        super.remove((Object)reposId);
    }

    public void run() {
        this.cleanup();
    }

    public synchronized void cleanup() {
        this.evict();
    }

    public List getCacheItems() {
        ArrayList result = new ArrayList(this.values());
        return result;
    }

    public String stripType(String reposId) {
        int p = reposId.lastIndexOf(47);
        if (p > -1) {
            return reposId.substring(0, p);
        }
        return reposId;
    }

    public void printStats() {
        Logger logger = LogManager.getLogger((String)"com.sas.services.information.DAVRepositoryCache");
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug("Cache Statistics for Repository " + this._reposURL);
            logger.debug("  PUTS:        " + this.puts);
            logger.debug("  HITS:        " + this.hits);
            logger.debug("  HITMISSES:   " + this.hitmiss);
            logger.debug("  MISSES:      " + this.misses);
            logger.debug("  NEAR MISSES: " + this.nearmisses);
        }
    }

    public void setURL(RepositoryInterface repos) {
        try {
            this._reposURL = repos.getUrl();
        }
        catch (RemoteException e) {
            this._reposURL = "????????";
        }
    }
}

