/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.browse;

import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.FolderUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BrowseMetadata
implements BrowseMetadataInterface,
Serializable {
    static final long serialVersionUID = 7637638783663607538L;
    private static final String ATTRIBUTE_PUBLICTYPE = "PublicType";
    private static final int EMPTY_LIST_INIT = 1;
    private Map _rawData;

    private BrowseMetadata() {
    }

    public BrowseMetadata(Map rawData) {
        this._rawData = rawData;
    }

    @Override
    public Map getRawData() {
        return this._rawData;
    }

    @Override
    public Object get(String key) {
        Object o = this._rawData.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof List) {
            List list = (List)o;
            ArrayList<BrowseMetadata> result = new ArrayList<BrowseMetadata>(((List)o).size());
            Iterator it = list.iterator();
            while (it.hasNext()) {
                try {
                    Map map = (Map)it.next();
                    result.add(new BrowseMetadata(map));
                }
                catch (ClassCastException classCastException) {}
            }
            return result;
        }
        return o;
    }

    @Override
    public String getName() {
        return (String)this._rawData.get("Name");
    }

    @Override
    public String getDescription() {
        String descString = (String)this._rawData.get("Desc");
        if (descString == null) {
            descString = "";
        }
        return descString;
    }

    @Override
    public long getCreateDate() {
        long result = -1L;
        try {
            String dateString = (String)this._rawData.get("MetadataCreated");
            if (dateString != null) {
                result = Long.parseLong(dateString);
            }
        }
        catch (NumberFormatException t) {
            result = -1L;
        }
        return result;
    }

    @Override
    public Date getCreateDateAsDate() {
        long longDate = this.getCreateDate();
        return new Date(longDate);
    }

    @Override
    public long getModifyDate() {
        long result = -1L;
        try {
            String dateString = (String)this._rawData.get("MetadataUpdated");
            if (dateString != null) {
                result = Long.parseLong(dateString);
            }
        }
        catch (NumberFormatException t) {
            result = -1L;
        }
        return result;
    }

    @Override
    public Date getModifyDateAsDate() {
        long longDate = this.getModifyDate();
        return new Date(longDate);
    }

    @Override
    public List getKeywords() {
        List keywords = (List)this._rawData.get("Keywords");
        if (keywords == null) {
            return new ArrayList(1);
        }
        ArrayList<String> result = new ArrayList<String>(keywords.size());
        for (Map keyword : keywords) {
            String name = (String)keyword.get("Name");
            if (name == null) continue;
            result.add(name);
        }
        return result;
    }

    @Override
    public String getSmartType() {
        String result = (String)this._rawData.get("smarttype");
        if (result == null) {
            return "Metadata";
        }
        return result;
    }

    @Override
    public String getNativeType() {
        return (String)this._rawData.get("MetadataObjectType");
    }

    @Override
    public String getISEntityKey() {
        return (String)this._rawData.get("ISEntityKey");
    }

    @Override
    public boolean isAFolder() {
        String flagString = (String)this._rawData.get("isAFolder");
        boolean flag = Boolean.valueOf(flagString);
        return flag;
    }

    @Override
    public List getMembers() {
        if (!this.isAFolder()) {
            return null;
        }
        ArrayList<BrowseMetadata> result = null;
        List memberList = (List)this._rawData.get("Members");
        if (memberList != null) {
            result = new ArrayList(memberList.size());
            for (Map nextMap : memberList) {
                result.add(new BrowseMetadata(nextMap));
            }
        } else {
            result = new ArrayList<BrowseMetadata>(1);
        }
        return result;
    }

    @Override
    public List getParents() {
        ArrayList<BrowseMetadata> result = null;
        List parentList = (List)this._rawData.get("ParentTree");
        if (parentList != null) {
            result = new ArrayList<BrowseMetadata>(parentList.size());
            for (Map nextMap : parentList) {
                result.add(new BrowseMetadata(nextMap));
            }
        } else {
            parentList = (List)this._rawData.get("Trees");
            if (parentList != null) {
                result = new ArrayList(parentList.size());
                for (Map nextMap : parentList) {
                    String publicType = (String)nextMap.get(ATTRIBUTE_PUBLICTYPE);
                    if (publicType == null || !FolderUtil.isFolder(publicType)) continue;
                    result.add(new BrowseMetadata(nextMap));
                }
            } else {
                result = new ArrayList(1);
            }
        }
        return result;
    }

    @Override
    public List getSubfolders() {
        if (!this.isAFolder()) {
            return null;
        }
        ArrayList<BrowseMetadata> result = null;
        List subfolderList = (List)this._rawData.get("SubTrees");
        if (subfolderList == null) {
            subfolderList = (List)this._rawData.get("SoftwareTrees");
        }
        if (subfolderList != null) {
            result = new ArrayList(subfolderList.size());
            for (Map nextMap : subfolderList) {
                result.add(new BrowseMetadata(nextMap));
            }
        } else {
            result = new ArrayList<BrowseMetadata>(1);
        }
        return result;
    }

    @Override
    public String getReposId() {
        return (String)this._rawData.get("reposid");
    }

    @Override
    public String toString() {
        return this.getISEntityKey();
    }
}

