/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information;

import com.sas.entities.GUID;
import com.sas.services.deployment.ConsumedResourceInterface;
import com.sas.services.information.RB;
import com.sas.text.Message;
import com.sas.util.Strings;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class ServerDef
implements Cloneable,
ConsumedResourceInterface,
Serializable {
    private static final long serialVersionUID = 142217841542719991L;
    public static final String ELEMENT_NAME = "ServerDef";
    public static final String ATTRIBUTE_UID = "uid";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_HOST = "host";
    public static final String ATTRIBUTE_PORT = "port";
    public static final String ATTRIBUTE_AUTOCONNECT = "auto";
    public static final String ATTRIBUTE_DESCRIPTION = "description";
    public static final String ATTRIBUTE_DOMAIN = "domain";
    public static final String ATTRIBUTE_PROTOCOL = "protocol";
    public static final String ATTRIBUTE_PROXY = "proxy";
    public static final String ATTRIBUTE_ISSECURE = "issecure";
    public static final String PROPERTYNAME_PROTOCOL = "protocol";
    public static final String PROPERTYNAME_NAME = "name";
    public static final String PROPERTYNAME_DESCRIPTION = "description";
    public static final String PROPERTYNAME_HOST = "host";
    public static final String PROPERTYNAME_PORT = "port";
    public static final String PROPERTYNAME_DOMAIN = "domain";
    public static final String PROPERTYNAME_AUTOCONNECT = "auto-connect";
    public static final String PROPERTYNAME_PROXY = "proxy";
    public static final String PROPERTYNAME_ISSECURE = "isSecure";
    private static final int PRIME_NUMBER = 31;
    private static final int STRINGBUFFER_INIT = 64;
    private String _uid = GUID.newGUID();
    private String _host;
    private String _port;
    private String _domain;
    private String _protocol;
    private String _description;
    private String _name;
    private boolean _auto;
    private String _proxy;
    private boolean _isSecure;
    private Map _advancedOptions = new HashMap(5);
    private List _baseLocations;

    public ServerDef() {
    }

    public ServerDef(String name, String protocol, String host, String port) {
        this._name = name;
        this._host = host;
        this._port = port;
        this._protocol = protocol;
    }

    public ServerDef(String uid, String name, String protocol, String host, String port) {
        this(name, protocol, host, port);
        if (uid != null && uid.length() > 0) {
            this._uid = uid;
        }
    }

    public void setAuto(boolean auto) {
        this._auto = auto;
    }

    public boolean getAuto() {
        return this._auto;
    }

    public String getUID() {
        return this._uid;
    }

    public String getUrl() {
        try {
            URI uri = new URI(this._protocol, this._host + ':' + this._port, "", null, null);
            return uri.toString();
        }
        catch (URISyntaxException use) {
            return this._protocol + "://" + this._host + ':' + this._port;
        }
    }

    public void setHost(String host) {
        this._host = host;
    }

    public String getHost() {
        return this._host;
    }

    public void setPort(String port) {
        this._port = port;
    }

    public String getPort() {
        return this._port;
    }

    public void setDomain(String domain) {
        this._domain = domain;
    }

    public String getDomain() {
        return this._domain;
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol.toLowerCase();
    }

    public String getProtocol() {
        return this._protocol;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getDescription() {
        return this._description == null ? "" : this._description;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name == null ? "" : this._name;
    }

    public void setProxy(String proxy) {
        this._proxy = proxy;
    }

    public String getProxy() {
        return this._proxy;
    }

    public void setIsSecure(boolean secure) {
        this._isSecure = secure;
    }

    public boolean getIsSecure() {
        return this._isSecure;
    }

    public final boolean equals(Object obj) {
        boolean isEqual = false;
        if (this == obj) {
            isEqual = true;
        } else if (obj == null) {
            isEqual = false;
        } else {
            try {
                ServerDef serverDef = (ServerDef)obj;
                if (Strings.equal((String)this._domain, (String)serverDef.getDomain(), (boolean)false, (boolean)false) && Strings.equal((String)this._host, (String)serverDef.getHost(), (boolean)false, (boolean)true) && Strings.equal((String)this._name, (String)serverDef.getName(), (boolean)true, (boolean)false) && Strings.equal((String)this._proxy, (String)serverDef.getProxy(), (boolean)false, (boolean)false) && Strings.equal((String)this._protocol, (String)serverDef.getProtocol(), (boolean)false, (boolean)false) && Strings.equal((String)this._port, (String)serverDef.getPort(), (boolean)false, (boolean)false) && this._auto == serverDef.getAuto() && this._isSecure == serverDef.getIsSecure() && Strings.equal((String)this._description, (String)serverDef.getDescription(), (boolean)true, (boolean)false)) {
                    isEqual = true;
                }
            }
            catch (ClassCastException e) {
                isEqual = false;
            }
        }
        return isEqual;
    }

    public final int hashCode() {
        int hashCode = 31;
        if (this._description != null) {
            hashCode ^= this._description.hashCode();
        }
        if (this._domain != null) {
            hashCode ^= this._domain.hashCode();
        }
        if (this._host != null) {
            hashCode ^= this._host.hashCode();
        }
        if (this._name != null) {
            hashCode ^= this._name.hashCode();
        }
        if (this._proxy != null) {
            hashCode ^= this._proxy.hashCode();
        }
        if (this._protocol != null) {
            hashCode ^= this._protocol.hashCode();
        }
        if (this._port != null) {
            hashCode ^= this._port.hashCode();
        }
        hashCode ^= Boolean.toString(this._isSecure).hashCode();
        return hashCode ^= Boolean.toString(this._auto).hashCode();
    }

    public void setAdvancedOptions(Map options) {
        this._advancedOptions.clear();
        this._advancedOptions.putAll(options);
    }

    public void addAdvancedOptions(String key, String value) {
        this._advancedOptions.put(key, value);
    }

    public Map getAdvancedOptions() {
        return new HashMap(this._advancedOptions);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append(this._protocol);
        buffer.append("://");
        buffer.append(this._host);
        buffer.append(':');
        buffer.append(this._port);
        buffer.append(";domain=");
        buffer.append(this._domain);
        return buffer.toString();
    }

    public void setBaseLocations(List baseList) {
        if (this._baseLocations == null) {
            this._baseLocations = new ArrayList(baseList.size());
        } else {
            this._baseLocations.clear();
        }
        this._baseLocations.addAll(baseList);
    }

    public void removeBaseLocation(String base) {
        if (this._baseLocations == null) {
            return;
        }
        this._baseLocations.remove(base);
    }

    public void addBaseLocation(String newBase) {
        if (this._baseLocations == null) {
            this._baseLocations = new ArrayList();
        }
        if (!this._baseLocations.contains(newBase)) {
            this._baseLocations.add(newBase);
        }
    }

    public List getBaseLocations() {
        if (this._baseLocations == null) {
            return Collections.EMPTY_LIST;
        }
        return this._baseLocations;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ServerDef clone = (ServerDef)super.clone();
        clone._advancedOptions = new HashMap(this._advancedOptions);
        if (this._baseLocations != null) {
            clone._baseLocations = new ArrayList(this._baseLocations);
        }
        return clone;
    }

    final boolean hasConflict(ServerDef other) {
        boolean isEqual = false;
        if (this == other) {
            isEqual = true;
        } else if (other != null) {
            boolean bl = isEqual = this._auto == other.getAuto() && this._isSecure == other.getIsSecure();
            if (isEqual) {
                String otherDesc = other.getDescription();
                String otherDomain = other.getDomain();
                String otherHost = other.getHost();
                String otherName = other.getName();
                String otherPort = other.getPort();
                String otherProtocol = other.getProtocol();
                String otherProxy = other.getProxy();
                String thisDesc = this.getDescription();
                String thisDomain = this.getDomain();
                String thisHost = this.getHost();
                String thisName = this.getName();
                String thisPort = this.getPort();
                String thisProtocol = this.getProtocol();
                String thisProxy = this.getProxy();
                boolean bl2 = isEqual = !(otherDesc != null && !"".equals(otherDesc) && thisDesc != null && !Strings.equal((String)otherDesc, (String)thisDesc, (boolean)false, (boolean)false) || otherDomain != null && !"".equals(otherDomain) && thisDomain != null && !Strings.equal((String)otherDomain, (String)thisDomain, (boolean)false, (boolean)false) || otherHost != null && !"".equals(otherHost) && thisHost != null && !Strings.equal((String)otherHost, (String)thisHost, (boolean)false, (boolean)true) || otherName != null && !"".equals(otherName) && thisName != null && !Strings.equal((String)otherName, (String)thisName, (boolean)false, (boolean)false) || otherPort != null && !"".equals(otherPort) && thisPort != null && !Strings.equal((String)otherPort, (String)thisPort, (boolean)false, (boolean)false) || otherProtocol != null && !"".equals(otherProtocol) && thisProtocol != null && !Strings.equal((String)otherProtocol, (String)thisProtocol, (boolean)false, (boolean)false) || otherProxy != null && !"".equals(otherProxy) && thisProxy != null && !Strings.equal((String)otherProxy, (String)thisProxy, (boolean)false, (boolean)false));
                if (isEqual) {
                    Map.Entry mapEntry2 = null;
                    String key = null;
                    String thisValue = null;
                    for (Map.Entry mapEntry2 : other._advancedOptions.entrySet()) {
                        key = (String)mapEntry2.getKey();
                        thisValue = (String)this._advancedOptions.get(key);
                        if (thisValue == null || Strings.equal((String)thisValue, (String)((String)mapEntry2.getValue()), (boolean)false, (boolean)false)) continue;
                        isEqual = false;
                        break;
                    }
                }
            }
        }
        return !isEqual;
    }

    void merge(ServerDef newObject) {
        if (newObject != null) {
            this.setIsSecure(newObject.getIsSecure());
            this.setAuto(newObject.getAuto());
            String value = newObject.getDescription();
            if (value != null) {
                this.setDescription(value);
            }
            if ((value = newObject.getDomain()) != null) {
                this.setDomain(value);
            }
            if ((value = newObject.getHost()) != null) {
                this.setHost(value);
            }
            if ((value = newObject.getName()) != null) {
                this.setName(value);
            }
            if ((value = newObject.getPort()) != null) {
                this.setPort(value);
            }
            if ((value = newObject.getProtocol()) != null) {
                this.setProtocol(value);
            }
            if ((value = newObject.getProxy()) != null) {
                this.setProxy(value);
            }
            Iterator iter = newObject.getBaseLocations().iterator();
            while (iter.hasNext()) {
                this.addBaseLocation((String)iter.next());
            }
            Map.Entry mapEntry2 = null;
            String newOption = null;
            String newOptionValue = null;
            for (Map.Entry mapEntry2 : newObject._advancedOptions.entrySet()) {
                newOption = (String)mapEntry2.getKey();
                newOptionValue = (String)mapEntry2.getValue();
                if (this._advancedOptions.get(newOption) != null) continue;
                this._advancedOptions.put(newOption, newOptionValue);
            }
        }
    }

    void replace(ServerDef newObject) {
        if (newObject != null) {
            this.setDescription(newObject.getDescription());
            this.setDomain(newObject.getDomain());
            this.setHost(newObject.getHost());
            this.setName(newObject.getName());
            this.setPort(newObject.getPort());
            this.setProtocol(newObject.getProtocol());
            this.setProxy(newObject.getProxy());
            this.setAuto(newObject.getAuto());
            this.setIsSecure(newObject.getIsSecure());
            Map.Entry mapEntry2 = null;
            for (Map.Entry mapEntry2 : newObject._advancedOptions.entrySet()) {
                this._advancedOptions.put(mapEntry2.getKey(), mapEntry2.getValue());
            }
        }
    }

    @Override
    public String getResourceID() {
        return this._uid;
    }

    @Override
    public String getResourceValue() {
        return this._name;
    }

    @Override
    public String getLocalizedResourceType() {
        return RB.getStringResource("ServerDef.resourceType.txt");
    }

    @Override
    public String getLocalizedResourceTypeAndValue() {
        return Message.format((ResourceBundle)RB.getResources(), (String)"ResourceTypeValue.server.fmt.txt", (Object)this.getLocalizedResourceType(), (Object)this.getResourceValue());
    }

    @Override
    public String getResourceType() {
        return "Server";
    }

    @Override
    public int getResourceTypeCode() {
        return 5;
    }

    @Override
    public boolean isRequired() {
        return false;
    }
}

