/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.discovery;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceConfigurationInterface;
import com.sas.services.ServiceException;
import com.sas.services.ServiceProxy;
import com.sas.services.discovery.JVMAttribute;
import com.sas.services.discovery.RB;
import com.sas.services.discovery.ServiceDiscoveryConfigurationInterface;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.discovery.Services;
import com.sas.text.Message;
import com.sas.util.Strings;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.rmi.server.RemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class ServicesCache
implements Serializable {
    private static final long serialVersionUID = 8051223269771054636L;
    private static final int TYPICAL_NUM_SERVICES = 10;
    private final Map<String, RemoteServiceInterface> _localServices = Collections.synchronizedMap(new HashMap(10));
    private final Map<String, RemoteServiceInterface> _remoteServices = Collections.synchronizedMap(new HashMap(10));
    private static final transient Logger LOGGER = LogManager.getLogger(ServicesCache.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Services getServices(ServiceTemplate serviceTemplate, int maxNumMatches, Services services, boolean isLocal) {
        Map<String, RemoteServiceInterface> registeredServices;
        Map<String, RemoteServiceInterface> map = registeredServices = isLocal ? this._localServices : this._remoteServices;
        synchronized (map) {
            Iterator<RemoteServiceInterface> iterator = registeredServices.values().iterator();
            int numServices = 0;
            RemoteServiceInterface service = null;
            while (iterator.hasNext() && numServices < maxNumMatches) {
                service = iterator.next();
                if (service == null || !serviceTemplate.isSatisfiedBy(service)) continue;
                services.add(service);
                ++numServices;
            }
        }
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(Services services) {
        Object object = null;
        if (services == null) {
            throw new IllegalArgumentException("A non-null Services parameter must be specified.");
        }
        try {
            Services services2 = services;
            synchronized (services2) {
                Iterator<RemoteServiceInterface> iterator = services.iterator();
                RemoteServiceInterface service = null;
                while (iterator.hasNext()) {
                    service = iterator.next();
                    try {
                        this.add(service);
                    }
                    catch (ServiceException e) {
                        LOGGER.error(ServicesCache.getAddServiceErrorMessage(service), (Throwable)((Object)e));
                    }
                }
            }
        }
        catch (ClassCastException e) {
            LOGGER.error(ServicesCache.getAddServiceErrorMessage(object), (Throwable)e);
        }
    }

    private static final String getAddServiceErrorMessage(Object service) {
        return Message.format((ResourceBundle)RB.getResources(), (String)"ServicesCache.exceptionAddingService.ex.fmt.txt", (Object)service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(RemoteServiceInterface service) throws ServiceException {
        block12: {
            boolean wasProcessed = false;
            Exception exception = null;
            try {
                if (service != null) {
                    boolean isRemote = false;
                    ServiceDiscoveryConfigurationInterface sdc = (ServiceDiscoveryConfigurationInterface)((Object)service.getServiceConfiguration(ServiceConfigurationInterface.CONFIGURATION_SERVICE_DISCOVERY));
                    if (sdc != null) {
                        String thisJVMId = new JVMAttribute().id;
                        isRemote = !thisJVMId.equals(sdc.getJVMId());
                    }
                    RemoteServiceInterface serviceProxy = null;
                    if (service instanceof ServiceProxy) {
                        serviceProxy = service;
                    }
                    if (serviceProxy == null) {
                        serviceProxy = service.getServiceProxy();
                    }
                    RemoteServiceInterface serviceToAdd = serviceProxy instanceof ServiceProxy ? serviceProxy : service;
                    boolean bl = wasProcessed = isRemote ? this.addRemote(serviceToAdd) : this.addLocal(serviceToAdd);
                }
                if (!wasProcessed) {
                    throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"ServicesCache.exceptionServiceNotCacheable.ex.fmt.txt", (Object)service));
                }
            }
            catch (RemoteException e) {
                exception = e;
            }
            catch (IllegalStateException e) {
                exception = e;
            }
            finally {
                if (null == exception) break block12;
                String msg = ServicesCache.getAddServiceErrorMessage(service);
                LOGGER.error(msg, (Throwable)exception);
                throw new ServiceException(exception, msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean addLocal(RemoteServiceInterface service) throws ServiceException {
        boolean wasAdded = false;
        if (service != null && !(service instanceof Proxy) && !(service instanceof RemoteObject)) {
            ServicesCache servicesCache = this;
            synchronized (servicesCache) {
                try {
                    String entityKey = service.getEntityKey();
                    boolean bl = wasAdded = this._localServices.get(entityKey) != null;
                    if (!wasAdded) {
                        this._localServices.put(entityKey, service);
                        wasAdded = true;
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServicesCache.addedServiceToCache.fmt.txt", (Object)RB.getStringResource("ServicesCache.local.txt"), (Object)service));
                        }
                    }
                }
                catch (RemoteException e) {
                    throw new ServiceException(e, Message.format((ResourceBundle)RB.getResources(), (String)"ServicesCache.exceptionAddingService.ex.fmt.txt", (Object)service.getClass().getName()));
                }
            }
        }
        return wasAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean addRemote(RemoteServiceInterface service) throws ServiceException {
        boolean wasAdded = false;
        if (service != null) {
            ServicesCache servicesCache = this;
            synchronized (servicesCache) {
                try {
                    String entityKey = service.getEntityKey();
                    boolean bl = wasAdded = this._remoteServices.get(entityKey) != null;
                    if (!wasAdded) {
                        this._remoteServices.put(entityKey, service);
                        wasAdded = true;
                        if (LOGGER.isDebugEnabled() && wasAdded) {
                            LOGGER.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServicesCache.addedServiceToCache.fmt.txt", (Object)RB.getStringResource("ServicesCache.remoteStub.txt"), (Object)service));
                        }
                    }
                }
                catch (RemoteException e) {
                    throw new ServiceException(e, Message.format((ResourceBundle)RB.getResources(), (String)"ServicesCache.exceptionAddingService.ex.fmt.txt", (Object)service.getClass().getName()));
                }
            }
        }
        return wasAdded;
    }

    public final void remove(RemoteServiceInterface service) {
        if (service != null) {
            boolean isRemoteService;
            boolean bl = isRemoteService = service instanceof Proxy || service instanceof RemoteObject;
            if (!isRemoteService && service instanceof ServiceProxy) {
                isRemoteService = ((ServiceProxy)service).isProxyToRemoteService();
            }
            Map<String, RemoteServiceInterface> services = isRemoteService ? this._remoteServices : this._localServices;
            try {
                services.remove(service.getEntityKey());
            }
            catch (RemoteException e) {
                LOGGER.error(Message.format((ResourceBundle)RB.getResources(), (String)"ServicesCache.remove.ex.fmt.txt", (Object)service.getClass().getName()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Iterator<RemoteServiceInterface> getLocalServices() {
        Iterator<RemoteServiceInterface> iter = null;
        Map<String, RemoteServiceInterface> map = this._localServices;
        synchronized (map) {
            iter = new HashSet<RemoteServiceInterface>(this._localServices.values()).iterator();
        }
        return iter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Iterator<RemoteServiceInterface> getRemoteServices() {
        Iterator<RemoteServiceInterface> iter = null;
        Map<String, RemoteServiceInterface> map = this._remoteServices;
        synchronized (map) {
            iter = new HashSet<RemoteServiceInterface>(this._remoteServices.values()).iterator();
        }
        return iter;
    }

    final List<RemoteServiceInterface> getListOfLocalServices() {
        return new ArrayList<RemoteServiceInterface>(this._localServices.values());
    }

    final List<RemoteServiceInterface> getListOfRemoteServices() {
        return new ArrayList<RemoteServiceInterface>(this._remoteServices.values());
    }

    final void clearLocalServices() {
        this._localServices.clear();
    }

    final void clearRemoteServices() {
        this._remoteServices.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final boolean isServiceInCollection(Collection<RemoteServiceInterface> collection, RemoteServiceInterface service) {
        boolean isAlreadyCached;
        block12: {
            isAlreadyCached = false;
            HashSet<RemoteServiceInterface> services = null;
            try {
                if (collection == null || service == null) break block12;
                Collection<RemoteServiceInterface> collection2 = collection;
                synchronized (collection2) {
                    services = new HashSet<RemoteServiceInterface>(collection);
                }
                isAlreadyCached = services.contains(service);
                if (isAlreadyCached || services.size() <= 0) break block12;
                Iterator iter = services.iterator();
                RemoteServiceInterface aService = null;
                String serviceEntityID = service.getEntityKey();
                while (iter.hasNext()) {
                    aService = (RemoteServiceInterface)iter.next();
                    if (!Strings.equal((String)serviceEntityID, (String)aService.getEntityKey(), (boolean)false, (boolean)false)) continue;
                    isAlreadyCached = true;
                    break;
                }
            }
            catch (RemoteException e) {
                isAlreadyCached = false;
            }
            catch (ClassCastException e) {
                isAlreadyCached = false;
            }
            finally {
                if (services != null) {
                    services.clear();
                }
            }
        }
        return isAlreadyCached;
    }
}

