/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.discovery;

import com.sas.codepolicy.SASScope;
import com.sas.nls.collator.SASCollatorFactory;
import com.sas.services.AbstractServiceAttribute;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceAttributeInterface;
import com.sas.services.ServiceConfigurationInterface;
import com.sas.services.ServiceState;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.discovery.RB;
import com.sas.services.discovery.ServiceComponentAttribute;
import com.sas.services.discovery.ServiceDiscoveryConfigurationInterface;
import com.sas.services.util.AbstractMBean;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.logging.log4j.LogManager;

@SASScope
public final class DiscoveryServiceMBean
extends AbstractMBean {
    private static final String METHOD_NAME_LISTSERVICES = "listServices";
    private static final String METHOD_NAME_GETSERVICEDETAILS = "getServiceDetails";
    private static final String METHOD_NAME_DESTROY = "destroy";
    private static final String ITEM_NAME = "name";
    private static final String ITEM_SERVICE = "service";
    private static final String ITEM_ENTITYKEY = "entityKey";
    private static final String ITEM_INTERFACE = "interfaces";
    private static final String ITEM_VALUE = "value";
    private static final String TYPENAME_FIELD = "field";
    private static final String TYPENAME_INTERFACES = "Interfaces";
    private static final String[] ITEMNAMES_INTERFACES = new String[]{"interfaces"};
    private static final String[] ITEMNAMES_FIELD = new String[]{"name", "value"};
    private static CompositeType COMPOSITETYPE_INTERFACE = null;
    private static TabularType TABULARTYPE_INTERFACES = null;
    private static CompositeType COMPOSITETYPE_FIELD = null;
    private static TabularType TABULARTYPE_FIELD = null;
    private DiscoveryServiceInterface _targetObject;

    public DiscoveryServiceMBean() {
        super(RB.getStringResource("DiscoveryServiceMBean.mBeanDescription.txt"));
        this.addMBeanOperation(METHOD_NAME_LISTSERVICES, RB.getStringResource("DiscoveryServiceMBean.invokeListServicesDesc.txt"), null, String[].class.getName(), 0);
        this.addMBeanOperation(METHOD_NAME_GETSERVICEDETAILS, RB.getStringResource("DiscoveryServiceMBean.invokeListServicesWithDetailsDesc.txt"), null, TabularData.class.getName(), 0);
        this.addMBeanOperation(METHOD_NAME_DESTROY, RB.getStringResource("DiscoveryServiceMBean.destroyDesc.txt"), null, "void", 1);
    }

    public void setTargetObject(DiscoveryServiceInterface discoveryService) {
        this._targetObject = discoveryService;
    }

    @Override
    protected Object getTargetObject() {
        if (this._targetObject == null) {
            this._targetObject = DiscoveryService.defaultInstance();
        }
        return this._targetObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listServices() throws MBeanException {
        String[] services;
        block9: {
            services = null;
            Exception ex = null;
            try {
                Iterator iter = this._targetObject.getLocalServices();
                ArrayList<String> list = new ArrayList<String>(10);
                RemoteServiceInterface service = null;
                ServiceDiscoveryConfigurationInterface svcDiscoveryConfig = null;
                while (iter.hasNext()) {
                    service = (RemoteServiceInterface)iter.next();
                    svcDiscoveryConfig = (ServiceDiscoveryConfigurationInterface)((Object)service.getServiceConfiguration(ServiceConfigurationInterface.CONFIGURATION_SERVICE_DISCOVERY));
                    list.add(DiscoveryServiceMBean.getServiceName(service, svcDiscoveryConfig.getServiceAttributes()));
                }
                Collections.sort(list, SASCollatorFactory.createCollator());
                services = new String[list.size()];
                services = list.toArray(services);
            }
            catch (RemoteException e) {
                ex = e;
                return ex;
            }
            catch (ClassCastException e) {
                ex = e;
                return ex;
            }
            finally {
                if (ex == null) break block9;
                String msg = RB.getStringResource("DiscoveryServiceMBean.invokeListServices.ex.txt");
                LogManager.getLogger(DiscoveryServiceMBean.class).error(msg, (Throwable)ex);
                throw new MBeanException(ex, msg);
            }
        }
        if (services == null) {
            services = new String[]{};
        }
        return services;
    }

    private static String getServiceName(RemoteServiceInterface service, ServiceAttributeInterface[] serviceAttributes) {
        String serviceName = null;
        int numItems = serviceAttributes != null ? serviceAttributes.length : 0;
        ServiceComponentAttribute serviceComponentAttribute = null;
        for (int i = 0; i < numItems; ++i) {
            try {
                serviceComponentAttribute = (ServiceComponentAttribute)serviceAttributes[i];
                if (serviceComponentAttribute == null) continue;
                serviceName = serviceComponentAttribute.name;
                break;
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        if (serviceName == null) {
            serviceName = service.getClass().getName();
        }
        return serviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TabularData getServiceDetails() throws MBeanException {
        TabularDataSupport tdsServices;
        block10: {
            tdsServices = null;
            Exception ex = null;
            try {
                String nameAttribute = "attribute";
                String typeNameAttributes = "attributes";
                String[] compositeTypeAttributesNames = new String[]{"attribute", "configuration"};
                CompositeType compositeTypeAttributes = new CompositeType("attributes", RB.getStringResource("DiscoveryServiceMBean.descAttribute.txt"), compositeTypeAttributesNames, new String[]{RB.getStringResource("DiscoveryServiceMBean.descAttributeClassname.txt"), RB.getStringResource("DiscoveryServiceMBean.descAttributeFields.txt")}, new OpenType[]{SimpleType.STRING, TABULARTYPE_FIELD});
                TabularType tabularTypeAttributes = new TabularType("attributesTab", RB.getStringResource("DiscoveryServiceMBean.descAttributes.txt"), compositeTypeAttributes, new String[]{"attribute"});
                ServiceDiscoveryConfigurationInterface svcDiscoveryConfig = null;
                RemoteServiceInterface service = null;
                Iterator iter = this._targetObject.getLocalServices();
                String[] itemNamesSvcDetail = new String[]{ITEM_SERVICE, ITEM_ENTITYKEY, "serviceInterfaces", "serviceAttributes"};
                CompositeType dataTypeSvcDetail = new CompositeType(RB.getStringResource("DiscoveryServiceMBean.descServiceDetail.txt"), RB.getStringResource("DiscoveryServiceMBean.compositeDescService.txt"), itemNamesSvcDetail, new String[]{RB.getStringResource("DiscoveryServiceMBean.descService.txt"), RB.getStringResource("DiscoveryServiceMBean.descEntityKey.txt"), RB.getStringResource("DiscoveryServiceMBean.descInterfaces.txt"), RB.getStringResource("DiscoveryServiceMBean.descAttributes.txt")}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, TABULARTYPE_INTERFACES, tabularTypeAttributes});
                String[] itemNamesServices = new String[]{ITEM_SERVICE, ITEM_ENTITYKEY, "serviceTemplate"};
                CompositeType dataTypeServices = new CompositeType("Services", RB.getStringResource("DiscoveryServiceMBean.typeDescServices.txt"), itemNamesServices, new String[]{RB.getStringResource("DiscoveryServiceMBean.descService.txt"), RB.getStringResource("DiscoveryServiceMBean.descEntityKey.txt"), RB.getStringResource("DiscoveryServiceMBean.descServiceDetail.txt")}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, dataTypeSvcDetail});
                tdsServices = new TabularDataSupport(new TabularType("AllServices", RB.getStringResource("DiscoveryServiceMBean.descService.txt"), dataTypeServices, new String[]{ITEM_SERVICE, ITEM_ENTITYKEY}));
                String serviceName = null;
                TabularData tdsSvcInterfaces = null;
                TabularData tdsSvcAttributes = null;
                CompositeDataSupport cdDetails = null;
                String svcEntityKey = null;
                iter = this._targetObject.getLocalServices();
                while (iter.hasNext()) {
                    service = (RemoteServiceInterface)iter.next();
                    if (!ServiceState.isStateInitialized(service.getServiceState())) continue;
                    svcDiscoveryConfig = (ServiceDiscoveryConfigurationInterface)((Object)service.getServiceConfiguration(ServiceConfigurationInterface.CONFIGURATION_SERVICE_DISCOVERY));
                    serviceName = DiscoveryServiceMBean.getServiceName(service, svcDiscoveryConfig.getServiceAttributes());
                    tdsSvcInterfaces = this.getServiceInterfacesAsTabularData(svcDiscoveryConfig);
                    svcEntityKey = service.getEntityKey();
                    tdsSvcAttributes = DiscoveryServiceMBean.getServiceAttributesAsTabularData(svcDiscoveryConfig, tabularTypeAttributes);
                    cdDetails = new CompositeDataSupport(dataTypeSvcDetail, itemNamesSvcDetail, new Object[]{serviceName, svcEntityKey, tdsSvcInterfaces, tdsSvcAttributes});
                    tdsServices.put(new CompositeDataSupport(dataTypeServices, itemNamesServices, new Object[]{serviceName, svcEntityKey, cdDetails}));
                }
            }
            catch (RemoteException e) {
                ex = e;
                return ex;
            }
            catch (OpenDataException e) {
                ex = e;
                return ex;
            }
            catch (ClassCastException e) {
                ex = e;
                return ex;
            }
            finally {
                if (ex == null) break block10;
                String msg = RB.getStringResource("DiscoveryServiceMBean.invokeGetServiceDetails.ex.txt");
                LogManager.getLogger(DiscoveryServiceMBean.class).error(msg, (Throwable)ex);
                throw new MBeanException(ex, msg);
            }
        }
        return tdsServices;
    }

    private TabularData getServiceInterfacesAsTabularData(ServiceDiscoveryConfigurationInterface svcDiscoveryConfig) throws OpenDataException {
        TabularDataSupport tabularData = new TabularDataSupport(TABULARTYPE_INTERFACES);
        Class[] serviceTypes = svcDiscoveryConfig.getServiceTypes();
        int numItems = serviceTypes.length;
        for (int i = 0; i < numItems; ++i) {
            tabularData.put(new CompositeDataSupport(COMPOSITETYPE_INTERFACE, ITEMNAMES_INTERFACES, new Object[]{serviceTypes[i].getName()}));
        }
        return tabularData;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        Object rv = null;
        try {
            int actionNameHash = actionName.hashCode();
            rv = METHOD_NAME_LISTSERVICES.hashCode() == actionNameHash && params.length == 0 && (null == signature || signature.length == 0) ? this.listServices() : (METHOD_NAME_GETSERVICEDETAILS.hashCode() == actionNameHash && params.length == 0 && (null == signature || signature.length == 0) ? this.getServiceDetails() : super.invoke(actionName, params, signature));
        }
        catch (AccessControlException e) {
            throw new MBeanException(new Exception(e.getLocalizedMessage()));
        }
        return rv;
    }

    private static TabularData getServiceAttributesAsTabularData(ServiceDiscoveryConfigurationInterface svcDiscoveryConfig, TabularType tabularTypeAttributes) throws OpenDataException {
        TabularDataSupport tdsAttributes = new TabularDataSupport(tabularTypeAttributes);
        CompositeType compositeType = tabularTypeAttributes.getRowType();
        Set<String> namesSet = compositeType.keySet();
        String[] compositeTypeNames = namesSet.toArray(new String[namesSet.size()]);
        ServiceAttributeInterface[] serviceAttributes = svcDiscoveryConfig.getServiceAttributes();
        int numItems = serviceAttributes.length;
        ServiceAttributeInterface serviceAttribute = null;
        AbstractServiceAttribute abstractServiceAttribute = null;
        Map<String, String> fieldMap = null;
        TabularDataSupport tdsAttribute = null;
        String attributeName = null;
        HashMap<String, Integer> attributeNameIndexMap = new HashMap<String, Integer>(numItems);
        HashMap<String, Boolean> attributeNameIsDuplicateMap = new HashMap<String, Boolean>(numItems);
        String className = null;
        for (int i = 0; i < numItems; ++i) {
            className = serviceAttributes[i].getClass().getName();
            if (!attributeNameIsDuplicateMap.containsKey(className)) {
                attributeNameIsDuplicateMap.put(className, Boolean.FALSE);
                attributeNameIndexMap.put(className, 1);
                continue;
            }
            attributeNameIsDuplicateMap.put(className, Boolean.TRUE);
        }
        Integer nameIndex = null;
        for (int i = 0; i < numItems; ++i) {
            serviceAttribute = serviceAttributes[i];
            try {
                abstractServiceAttribute = (AbstractServiceAttribute)serviceAttribute;
                attributeName = serviceAttribute.getClass().getName();
                if (Boolean.TRUE.equals(attributeNameIsDuplicateMap.get(attributeName))) {
                    nameIndex = (Integer)attributeNameIndexMap.get(attributeName);
                    attributeNameIndexMap.put(attributeName, nameIndex + 1);
                    attributeName = Message.format((ResourceBundle)RB.getResources(), (String)"DiscoveryServiceMBean.indexedAttributeName.fmt.txt", (Object)attributeName, (Object)nameIndex.toString());
                }
                fieldMap = abstractServiceAttribute.getFieldNameToValueMap();
                Iterator<Map.Entry<String, String>> iter = fieldMap.entrySet().iterator();
                Map.Entry<String, String> mapEntry = null;
                if (!iter.hasNext()) continue;
                tdsAttribute = new TabularDataSupport(TABULARTYPE_FIELD);
                while (iter.hasNext()) {
                    mapEntry = iter.next();
                    tdsAttribute.put(new CompositeDataSupport(COMPOSITETYPE_FIELD, ITEMNAMES_FIELD, new Object[]{mapEntry.getKey(), mapEntry.getValue()}));
                }
                tdsAttributes.put(new CompositeDataSupport(compositeType, compositeTypeNames, new Object[]{attributeName, tdsAttribute}));
                continue;
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        return tdsAttributes;
    }

    static {
        try {
            String descInterfaces = RB.getStringResource("DiscoveryServiceMBean.descInterfaces.txt");
            COMPOSITETYPE_INTERFACE = new CompositeType(TYPENAME_INTERFACES, descInterfaces, ITEMNAMES_INTERFACES, new String[]{descInterfaces}, new OpenType[]{SimpleType.STRING});
            TABULARTYPE_INTERFACES = new TabularType("InterfacesTab", descInterfaces, COMPOSITETYPE_INTERFACE, new String[]{ITEM_INTERFACE});
            COMPOSITETYPE_FIELD = new CompositeType(TYPENAME_FIELD, RB.getStringResource("DiscoveryServiceMBean.descAttribute.txt"), ITEMNAMES_FIELD, new String[]{RB.getStringResource("DiscoveryServiceMBean.descField.txt"), RB.getStringResource("DiscoveryServiceMBean.descFieldValue.txt")}, new OpenType[]{SimpleType.STRING, SimpleType.STRING});
            TABULARTYPE_FIELD = new TabularType("fieldTab", RB.getStringResource("DiscoveryServiceMBean.descAttribute.txt"), COMPOSITETYPE_FIELD, ITEMNAMES_FIELD);
        }
        catch (OpenDataException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

