/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.discovery;

import com.sas.codepolicy.SASScope;
import com.sas.services.InitializationException;
import com.sas.services.discovery.RB;
import com.sas.services.util.GetPropertyAction;
import com.sas.text.Message;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
final class ClassUtil {
    private static final String JAVA_CLASS_PATH = "java.class.path";
    private static final String JAVA_RMI_SERVER_CODEBASE = "java.rmi.server.codebase";
    private static final String TOKEN_SEPARATORS = ";,";

    private ClassUtil() {
    }

    static void determineIfsAndSuperClasses(Set<Class> interfaces, Set<Class> classes, Class aClass) {
        if (interfaces != null && classes != null && aClass != null) {
            if (aClass.isInterface()) {
                interfaces.add(aClass);
            } else {
                classes.add(aClass);
            }
            Class<?>[] classIfs = aClass.getInterfaces();
            int numIfs = classIfs.length;
            for (int i = 0; i < numIfs; ++i) {
                ClassUtil.determineIfsAndSuperClasses(interfaces, classes, classIfs[i]);
            }
            Class superClass = aClass.getSuperclass();
            if (superClass != null) {
                ClassUtil.determineIfsAndSuperClasses(interfaces, classes, superClass);
            }
        }
    }

    static File[] getRmiServerCodebaseFiles() {
        String rmiServerCodebase = AccessController.doPrivileged(new GetPropertyAction(JAVA_RMI_SERVER_CODEBASE));
        return ClassUtil.getFiles(rmiServerCodebase);
    }

    static File[] getClassPathFiles() {
        String files = AccessController.doPrivileged(new GetPropertyAction(JAVA_CLASS_PATH));
        return ClassUtil.getFiles(files);
    }

    static File[] getFiles(String fileCodebase) {
        File[] files = null;
        if (fileCodebase != null && fileCodebase.trim().length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(fileCodebase, TOKEN_SEPARATORS);
            files = new File[tokenizer.countTokens()];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                files[i++] = new File(tokenizer.nextToken());
            }
        } else {
            files = new File[]{};
        }
        return files;
    }

    static Class[] getClasses(String[] classNames) throws ClassNotFoundException {
        Class[] classes = null;
        ClassLoader classLoader = ClassUtil.class.getClassLoader();
        if (classLoader != null && classNames != null && classNames.length > 0) {
            int numClasses = classNames.length;
            classes = new Class[numClasses];
            for (int i = 0; i < numClasses; ++i) {
                if (classNames[i] == null) {
                    throw new ClassNotFoundException(RB.getStringResource("ClassUtil.noClassSpecified.ex.txt"));
                }
                classes[i] = classLoader.loadClass(classNames[i]);
            }
        } else {
            classes = new Class[]{};
        }
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object invokeMethod(Object anObject, Class aClass, String methodName, Object[] methodParameterObjects, Class[] methodParameterClasses) throws InitializationException {
        Object methodReturnObject;
        block11: {
            methodReturnObject = null;
            ReflectiveOperationException ex = null;
            try {
                Method method = null;
                if (methodName != null && (method = aClass.getMethod(methodName, methodParameterClasses)) != null) {
                    methodReturnObject = method.invoke(anObject, methodParameterObjects);
                }
            }
            catch (NoSuchMethodException e) {
                ex = e;
                return ex;
            }
            catch (IllegalAccessException e) {
                ex = e;
                return ex;
            }
            catch (InvocationTargetException e) {
                ex = e;
                return ex;
            }
            finally {
                if (ex == null) break block11;
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ClassUtil.exceptionUnableToInvokeMethodOnClass.ex.fmt.txt", (Object)methodName, (Object)aClass);
                Logger logger = LogManager.getLogger(ClassUtil.class);
                if (logger != null) {
                    logger.error(msg, (Throwable)ex);
                }
                throw new InitializationException(ex, msg);
            }
        }
        return methodReturnObject;
    }
}

