/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.deployment.RB;
import com.sas.text.Message;
import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class ServicesDeploymentEvent
implements Serializable {
    private static final long serialVersionUID = 487688172453068374L;
    public static final int DEPLOYMENT_STATE_UNITIALIZED = 1;
    public static final int DEPLOYMENT_STATE_DEPLOYING_LOCAL = 2;
    public static final int DEPLOYMENT_STATE_DEPLOYING_REMOTE = 4;
    public static final int DEPLOYMENT_STATE_DEPLOYED_LOCAL = 8;
    public static final int DEPLOYMENT_STATE_DEPLOYED_REMOTE = 16;
    public static final int DEPLOYMENT_STATE_FACADE_INITIALIZED = 32;
    public static final int DEPLOYMENT_STATE_TERMINATING = 64;
    public static final int DEPLOYMENT_STATE_TERMINATED = 128;
    private int _servicesDeploymentState = 0;

    public ServicesDeploymentEvent(int servicesDeploymentState) throws ServiceException {
        this.setServicesDeploymentState(servicesDeploymentState);
    }

    public final int getServicesDeploymentState() {
        return this._servicesDeploymentState;
    }

    private final void setServicesDeploymentState(int servicesDeploymentState) throws ServiceException {
        if (!ServicesDeploymentEvent.isValidState(servicesDeploymentState)) {
            try {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ServicesDeploymentEvent.invalidState.ex.fmt.txt", (Object)servicesDeploymentState);
                throw new ServiceException(msg);
            }
            catch (MissingResourceException e) {
                throw new ServiceException(e.getLocalizedMessage());
            }
        }
        this._servicesDeploymentState = servicesDeploymentState;
    }

    public static final boolean isValidState(int servicesDeploymentState) {
        boolean isValid = false;
        switch (servicesDeploymentState) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 32: 
            case 64: 
            case 128: {
                isValid = true;
                break;
            }
        }
        return isValid;
    }

    public static final boolean isDeployedLocal(int servicesDeploymentState) {
        boolean isMatch = servicesDeploymentState == 8;
        return isMatch;
    }

    public static final boolean isDeployingLocal(int servicesDeploymentState) {
        boolean isMatch = servicesDeploymentState == 2;
        return isMatch;
    }

    public static final boolean isDeployedRemote(int servicesDeploymentState) {
        boolean isMatch = servicesDeploymentState == 16;
        return isMatch;
    }

    public static final boolean isDeployingRemote(int servicesDeploymentState) {
        boolean isMatch = servicesDeploymentState == 4;
        return isMatch;
    }

    public static final boolean isFacadeInitialized(int servicesDeploymentState) {
        boolean isMatch = servicesDeploymentState == 32;
        return isMatch;
    }

    public static final boolean isTerminating(int servicesDeploymentState) {
        boolean isMatch = servicesDeploymentState == 64;
        return isMatch;
    }

    public static final boolean isTerminated(int servicesDeploymentState) {
        boolean isMatch = servicesDeploymentState == 128;
        return isMatch;
    }

    public static final boolean isUnitialized(int servicesDeploymentState) {
        boolean isMatch = servicesDeploymentState == 1;
        return isMatch;
    }
}

