/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.services.ServiceException;
import com.sas.services.deployment.AbstractExporter;
import com.sas.services.deployment.AbstractMetadataSource;
import com.sas.services.deployment.AbstractServiceDeployment;
import com.sas.services.deployment.CLIOptionsConfig;
import com.sas.services.deployment.CLIOptionsMeta;
import com.sas.services.deployment.CLIOptionsServiceDeployment;
import com.sas.services.deployment.Environment;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.ServiceDeploymentImporter;
import com.sas.services.deployment.ServiceDeployments;
import com.sas.services.deployment.SoftwareComponentRemoteExporter;
import com.sas.services.util.UncaughtRuntimeExceptionHandler;
import com.sas.text.Message;
import java.io.File;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class ServiceDeploymentExporter
extends Thread {
    private AbstractExporter _exporter;
    private ServiceException _serviceException;
    private Observable _observable = new Observable();

    public ServiceDeploymentExporter(SoftwareComponent serviceDeployment, File exportDestinationFile) throws IllegalArgumentException {
        this(serviceDeployment, exportDestinationFile, true);
    }

    public ServiceDeploymentExporter(SoftwareComponent serviceDeployment, File exportDestinationFile, boolean isOKToOverwriteFile) throws IllegalArgumentException {
        super(RB.getStringResource("ServiceDeploymentExporter.threadName.txt"));
        this._exporter = new SoftwareComponentRemoteExporter(serviceDeployment, exportDestinationFile, isOKToOverwriteFile);
    }

    public void setIsBeautifyingXML(boolean isBeautifyingXML) {
        this._exporter.setIsBeautifyingXML(isBeautifyingXML);
    }

    @Override
    public void run() {
        try {
            this._serviceException = null;
            this._exporter.export();
        }
        catch (ServiceException e) {
            this._serviceException = e;
        }
        finally {
            this._observable.notifyObservers(this._serviceException);
        }
    }

    public static MdObjectStore newStoreWithCopyOfServiceDeployment(SoftwareComponent softwareComponent) throws IllegalArgumentException, ServiceException {
        if (softwareComponent == null) {
            throw new IllegalArgumentException(RB.getStringResource("AbstractExporter.specifySoftwareComponent.ex.txt"));
        }
        return SoftwareComponentRemoteExporter.newObjectStore(softwareComponent);
    }

    public void setExportDestinationFile(File exportDestinationFile) throws IllegalArgumentException {
        this._exporter.setExportDestinationFile(exportDestinationFile);
    }

    public ServiceException getServiceException() {
        return this._serviceException;
    }

    public void addObserver(Observer observer) {
        this._observable.addObserver(observer);
    }

    public void deleteObserver(Observer observer) {
        this._observable.deleteObserver(observer);
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtRuntimeExceptionHandler(true));
        ServiceException exception = null;
        try {
            ServiceDeploymentExporter.exportDeployment(args);
        }
        catch (ServiceException e) {
            exception = e;
            LogManager.getLogger(ServiceDeploymentImporter.class).error("Unable to export foundation services deployment.", (Throwable)((Object)e));
        }
        System.exit(exception == null ? 0 : -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportDeployment(String[] args) throws ServiceException {
        Logger logger;
        block36: {
            logger = LogManager.getLogger(ServiceDeploymentExporter.class);
            MdStore mdStore = null;
            CLIOptionsMeta cliOptionsMeta = new CLIOptionsMeta();
            Option cliOptionMetaServer = cliOptionsMeta.createOptionMetaServer();
            Option cliOptionMetaPort = cliOptionsMeta.createOptionPort();
            Option cliOptionMetaRepository = cliOptionsMeta.createOptionRepository();
            Option cliOptionIsPrompting = new CLIOptionsConfig().createOptionIsPrompting();
            CLIOptionsServiceDeployment cliDeployment = new CLIOptionsServiceDeployment();
            Option optionDeploymentName = cliDeployment.createOptionDeploymentName();
            optionDeploymentName.setRequired(true);
            Option optionDeploymentFile = cliDeployment.createOptionDeploymentFile();
            optionDeploymentFile.setRequired(true);
            Option optionIsOverwriteFile = cliDeployment.createOptionIsOverwriteFile();
            Option cliOptionMetaUser = cliOptionsMeta.createOptionUser();
            Option cliOptionMetaPassword = cliOptionsMeta.createOptionPassword();
            Option cliOptionMetaPasswordOnStdin = cliOptionsMeta.createOptionPasswordOnStdin();
            Option cliOptionSecPackageList = cliOptionsMeta.createOptionSecPackageList();
            Option cliOptionSPN = cliOptionsMeta.createOptionSPN();
            String serviceDeploymentFile = null;
            String serviceDeploymentName = null;
            ServiceException exception = null;
            try {
                Options options = new Options();
                options.addOption(cliOptionMetaServer);
                options.addOption(cliOptionMetaPort);
                options.addOption(cliOptionMetaRepository);
                options.addOption(cliOptionIsPrompting);
                options.addOption(optionDeploymentFile);
                options.addOption(optionIsOverwriteFile);
                options.addOption(optionDeploymentName);
                OptionGroup optionGroupCx = new OptionGroup();
                optionGroupCx.setRequired(true);
                optionGroupCx.addOption(cliOptionMetaUser);
                optionGroupCx.addOption(cliOptionSecPackageList);
                options.addOptionGroup(optionGroupCx);
                options.addOption(cliOptionMetaPassword);
                options.addOption(cliOptionMetaPasswordOnStdin);
                options.addOption(cliOptionSPN);
                String metaPass = null;
                boolean isValid = false;
                CommandLine cmdLine = null;
                try {
                    cmdLine = new DefaultParser().parse(options, args);
                    String metaHost = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionServer());
                    String metaPort = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionPort());
                    String secPackageList = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionSecPackageList());
                    String metaSPN = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionSPN());
                    String metaUser = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionUser());
                    boolean isPasswordOnStdin = Boolean.parseBoolean(cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionPasswordOnStdin()));
                    metaPass = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionPassword());
                    serviceDeploymentFile = cmdLine.getOptionValue(optionDeploymentFile.getOpt());
                    serviceDeploymentName = cmdLine.getOptionValue(optionDeploymentName.getOpt());
                    boolean bl = isValid = cmdLine.hasOption(cliOptionsMeta.getNameOfOptionServer()) && cmdLine.hasOption(cliOptionsMeta.getNameOfOptionPort()) && cmdLine.hasOption(cliOptionsMeta.getNameOfOptionRepository()) && serviceDeploymentName != null && serviceDeploymentFile != null && (metaUser != null && (isPasswordOnStdin || metaPass != null) || secPackageList != null);
                    if (isValid) {
                        String metadataRepositoryID;
                        HashMap<String, String> metaOptions = new HashMap<String, String>(7);
                        String optionName = cliOptionsMeta.getNameOfOptionServer();
                        metaOptions.put(optionName, metaHost);
                        optionName = cliOptionsMeta.getNameOfOptionPort();
                        metaOptions.put(optionName, metaPort);
                        optionName = cliOptionsMeta.getNameOfOptionRepository();
                        String repositoryName = cmdLine.getOptionValue(optionName);
                        metaOptions.put(optionName, repositoryName);
                        if (secPackageList != null) {
                            optionName = cliOptionsMeta.getNameOfOptionSecPackageList();
                            metaOptions.put(optionName, secPackageList);
                            optionName = cliOptionsMeta.getNameOfOptionSPN();
                            metaOptions.put(optionName, metaSPN);
                        } else {
                            String dashOptionName;
                            optionName = cliOptionsMeta.getNameOfOptionUser();
                            metaOptions.put(optionName, metaUser);
                            if (isPasswordOnStdin && (metaPass = CLIOptionsConfig.getOptionValueFromSystemIn(dashOptionName = '-' + cliOptionsMeta.getNameOfOptionPassword(), Boolean.parseBoolean(cmdLine.getOptionValue(cliOptionIsPrompting.getOpt())) ? Message.format((ResourceBundle)RB.getResources(), (String)"CLIOptionsMeta.specifyMetaPass.fmt.txt", (Object)dashOptionName) : null, null)) == null) {
                                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"CLIOptionsMeta.specifyMetaPass.ex.fmt.txt", (Object)cliOptionsMeta.getNameOfOptionPassword()));
                            }
                        }
                        if (metaPass != null) {
                            metaOptions.put(cliOptionsMeta.getNameOfOptionPassword(), metaPass);
                        }
                        if ((metadataRepositoryID = AbstractServiceDeployment.getRepositoryID((mdStore = AbstractMetadataSource.createMdStore(false, metaOptions, new Environment())).getFactory(), repositoryName)) == null) {
                            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"IllegalArgument.repositoryName.ex.fmt.txt", (Object)repositoryName));
                        }
                        SoftwareComponent softwareComponent = ServiceDeployments.getServiceDeployment(mdStore, metadataRepositoryID, serviceDeploymentName);
                        if (softwareComponent == null) {
                            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeployment.setSoftwareComponent.ex.fmt.txt", (Object)serviceDeploymentName, (Object)repositoryName));
                        }
                        String isOverwriteFileOption = optionIsOverwriteFile.getOpt();
                        ServiceDeploymentExporter.exportServiceDeployment(softwareComponent, serviceDeploymentFile, cmdLine.hasOption(isOverwriteFileOption) && Boolean.parseBoolean(cmdLine.getOptionValue(isOverwriteFileOption)));
                    }
                }
                finally {
                    metaPass = null;
                    if (!isValid) {
                        StringBuilder sb = new StringBuilder();
                        String nextOption = "> -";
                        sb.append(ServiceDeploymentExporter.class.getName());
                        sb.append(" -");
                        sb.append(cliOptionMetaServer.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaServer.getArgName());
                        sb.append("> -");
                        sb.append(cliOptionMetaPort.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaPort.getArgName());
                        sb.append("> -");
                        sb.append(cliOptionMetaRepository.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaRepository.getArgName());
                        sb.append("> -");
                        sb.append(optionDeploymentFile.getOpt());
                        sb.append(" <");
                        sb.append(optionDeploymentFile.getArgName());
                        sb.append("> -");
                        sb.append(optionDeploymentName.getOpt());
                        sb.append(" <");
                        sb.append(optionDeploymentName.getArgName());
                        sb.append("> [-");
                        sb.append(cliOptionMetaUser.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaUser.getArgName());
                        sb.append("> [[-");
                        sb.append(cliOptionMetaPassword.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaPassword.getArgName());
                        sb.append(">] | [-");
                        sb.append(cliOptionMetaPasswordOnStdin.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaPasswordOnStdin.getArgName());
                        sb.append(">]] | [-");
                        sb.append(cliOptionSecPackageList.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionSecPackageList.getArgName());
                        sb.append("> [-");
                        sb.append(cliOptionSPN.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionSPN.getArgName());
                        sb.append(">]]");
                        new HelpFormatter().printHelp(sb.toString(), options);
                    }
                }
            }
            catch (RemoteException e) {
                exception = new ServiceException(e);
            }
            catch (ParseException e) {
                exception = new ServiceException(e);
            }
            catch (IllegalArgumentException e) {
                exception = new ServiceException(e);
            }
            catch (ServiceException e) {
                exception = e;
            }
            finally {
                if (mdStore != null) {
                    try {
                        mdStore.getFactory().dispose();
                    }
                    catch (RemoteException e) {
                        logger.error(RB.getStringResource("ServiceConfigurationFactory.disposeFactory.ex.log"), (Throwable)e);
                    }
                }
                if (exception == null) break block36;
                logger.error(RB.getStringResource("ServiceDeploymentExporter.main.ex.txt"), (Throwable)((Object)exception));
                throw exception;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(RB.getStringResource("ServiceConfigInstaller.returningFromMain.log"));
        }
    }

    public static void exportServiceDeployment(SoftwareComponent softwareComponent, String fileName, boolean isOverwriteFile) throws ServiceException {
        String serviceDeploymentName = null;
        try {
            serviceDeploymentName = softwareComponent.getName();
            new ServiceDeploymentExporter(softwareComponent, new File(fileName), isOverwriteFile).run();
            Logger logger = LogManager.getLogger(ServiceDeploymentExporter.class);
            if (logger.isInfoEnabled()) {
                logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeploymentExporter.export.fmt.txt", (Object)serviceDeploymentName, (Object)fileName));
            }
        }
        catch (RemoteException e) {
            throw new ServiceException(e);
        }
    }
}

