/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.LocalizedResource;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServiceComponent;
import com.sas.metadata.remote.ServiceType;
import com.sas.services.ServiceException;
import com.sas.services.deployment.DependentServicesException;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.RootDeleter;
import com.sas.services.discovery.DiscoveryAdminInterface;
import com.sas.services.discovery.FindServiceInterface;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.logging.log4j.LogManager;

@SASScope
class ServiceDeleter
extends RootDeleter {
    private static final String DELETE_TEMPLATE_SERVICE = "<ServiceComponent>   <Properties/>   <ServiceNames/></ServiceComponent>";
    private final boolean _isValidatingServiceDependencies;

    ServiceDeleter(ServiceComponent serviceComponent, boolean isValidatingServiceDependencies) {
        super((Root)serviceComponent);
        this._isValidatingServiceDependencies = isValidatingServiceDependencies;
    }

    @Override
    protected void addDeletionTemplates(Map<String, String> deletionTemplateMap) throws ServiceException {
        super.addDeletionTemplates(deletionTemplateMap);
        String deleteTemplate = DELETE_TEMPLATE_SERVICE;
        deletionTemplateMap.put("ServiceComponent", deleteTemplate);
        deleteTemplate = ServiceDeleter.getDeleteTemplateNamedService();
        deletionTemplateMap.put("NamedService", deleteTemplate);
        deleteTemplate = ServiceDeleter.getDeleteTemplateLocalizedResource();
        deletionTemplateMap.put("LocalizedResource", deleteTemplate);
        deleteTemplate = ServiceDeleter.getDeleteTemplateTextStore();
        deletionTemplateMap.put("TextStore", deleteTemplate);
        deleteTemplate = ServiceDeleter.getDeleteTemplateProperty();
        deletionTemplateMap.put("Property", deleteTemplate);
    }

    static final void addServiceTypesForDeletion(List<CMetadata> deletedObjects, DeployedComponent deployedComponent) throws ServiceException {
        try {
            AssociationList serviceTypes = deployedComponent.getServiceTypes();
            Iterator iterServiceTypes = serviceTypes.iterator();
            ServiceType serviceType = null;
            Property property2 = null;
            LocalizedResource localizedResource2 = null;
            while (iterServiceTypes.hasNext()) {
                serviceType = (ServiceType)iterServiceTypes.next();
                if (serviceType.getDeployedComponents().size() == 1) {
                    for (Property property2 : serviceType.getLocalizedAttributes()) {
                        RootDeleter.deleteProperty(property2, deletedObjects);
                        for (LocalizedResource localizedResource2 : property2.getResources()) {
                            RootDeleter.deleteProperties((Root)localizedResource2, deletedObjects);
                            deletedObjects.add((CMetadata)localizedResource2);
                        }
                    }
                    deletedObjects.add((CMetadata)serviceType);
                    continue;
                }
                iterServiceTypes.remove();
            }
            if (deletedObjects.size() > 0) {
                deployedComponent.getObjectStore().getFactory().deleteMetadataObjects(deletedObjects);
            }
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
        catch (RemoteException e) {
            throw new ServiceException(e);
        }
        catch (ClassCastException e) {
            throw new ServiceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void verifyIsOKToDelete() throws ServiceException {
        block7: {
            if (this._isValidatingServiceDependencies) {
                ServiceComponent serviceComponent = null;
                ClassCastException exception = null;
                try {
                    serviceComponent = (ServiceComponent)this.getRoot();
                    ServiceDeleter.verifyNoDependentServices(serviceComponent, new HashSet<ServiceComponent>(0));
                }
                catch (ClassCastException e) {
                    exception = e;
                }
                finally {
                    if (exception == null) break block7;
                    String detail = exception.getLocalizedMessage();
                    if (detail == null) {
                        detail = "";
                    }
                    throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeleter.deleteValidation.ex.fmt.txt", (Object)detail));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deleteMetadataObjects(List<CMetadata> deletedObjects) throws ServiceException {
        block7: {
            Exception exception = null;
            String name = null;
            try {
                DeployedComponent deployedComponent = (DeployedComponent)this.getRoot();
                name = deployedComponent.getName();
                ServiceDeleter.addServiceTypesForDeletion(deletedObjects, deployedComponent);
                super.deleteMetadataObjects(deletedObjects);
            }
            catch (ClassCastException e) {
                exception = e;
            }
            catch (RemoteException e) {
                exception = e;
            }
            finally {
                if (exception == null) break block7;
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeleter.delete.ex.fmt.txt", (Object)name);
                LogManager.getLogger(ServiceDeleter.class).error(msg, (Throwable)exception);
                throw new ServiceException(exception, msg);
            }
        }
    }

    public static final void verifyNoDependentServices(ServiceComponent serviceComponent, Set<ServiceComponent> servicesToExclude) throws DependentServicesException, ServiceException {
        try {
            AssociationList serviceTypes = serviceComponent.getServiceTypes();
            String findServiceInterface = FindServiceInterface.class.getName();
            String discoveryAdminInterface = DiscoveryAdminInterface.class.getName();
            boolean isFindService = false;
            boolean isDiscoveryAdmin = false;
            String interfaceName = null;
            for (ServiceType serviceType : serviceTypes) {
                interfaceName = serviceType.getInterfaceName();
                if (findServiceInterface.equals(interfaceName)) {
                    isFindService = true;
                    if (!isDiscoveryAdmin) continue;
                    break;
                }
                if (!discoveryAdminInterface.equals(interfaceName)) continue;
                isDiscoveryAdmin = true;
                if (!isFindService) continue;
                break;
            }
            if (!isFindService || !isDiscoveryAdmin) {
                int numDependentServices;
                Set<ServiceComponent> dependentServices = ServiceDeleter.getDependentServices(serviceComponent);
                if (servicesToExclude != null && servicesToExclude.size() > 0) {
                    Iterator<ServiceComponent> iter = servicesToExclude.iterator();
                    Iterator<ServiceComponent> iter2 = null;
                    ServiceComponent nextService = null;
                    while (iter.hasNext()) {
                        nextService = iter.next();
                        iter2 = dependentServices.iterator();
                        while (iter2.hasNext()) {
                            if (!nextService.equals(iter2.next())) continue;
                            iter2.remove();
                        }
                    }
                }
                int n = numDependentServices = dependentServices == null ? 0 : dependentServices.size();
                if (numDependentServices > 0) {
                    throw new DependentServicesException((DeployedComponent)serviceComponent, (DeployedComponent)dependentServices.iterator().next());
                }
            }
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
        catch (RemoteException e) {
            throw new ServiceException(e);
        }
    }

    private static Set<ServiceComponent> getDependentServices(ServiceComponent serviceComponent) throws MdException {
        HashSet<ServiceComponent> dependentList = new HashSet<ServiceComponent>(5);
        try {
            AssociationList usedByComponents = serviceComponent.getUsedByComponents();
            Iterator iter = usedByComponents.iterator();
            Object deployedComponent = null;
            while (iter.hasNext()) {
                deployedComponent = iter.next();
                if (!(deployedComponent instanceof ServiceComponent)) continue;
                dependentList.add(deployedComponent);
            }
        }
        catch (RemoteException e) {
            throw new MdException((Throwable)e);
        }
        return dependentList;
    }
}

