/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.SASScope;
import com.sas.services.deployment.RB;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

@SASScope
public final class SAXErrorHandler
extends DefaultHandler {
    private final Logger _logger;
    private final List<SAXParseException> _exceptions = new ArrayList<SAXParseException>(5);

    public SAXErrorHandler(Logger logger) {
        this._logger = logger;
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.handleException(exception);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.handleException(exception);
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.handleException(exception);
    }

    public List<SAXParseException> getExceptions() {
        return new ArrayList<SAXParseException>(this._exceptions);
    }

    public void clearExceptions() {
        this._exceptions.clear();
    }

    private void handleException(SAXParseException exception) {
        this._exceptions.add(exception);
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("DeploymentStrategy.parse.ex.txt"), (Throwable)exception);
        }
    }
}

