/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.NamedService;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServiceComponent;
import com.sas.services.ServiceException;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.RootDeleter;
import com.sas.services.deployment.ServiceDeleter;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;

@SASScope
final class RegistryDeleter
extends RootDeleter {
    private static final String DELETE_TEMPLATE_SERVICE_REGISTRY = "<DeployedComponent>   <Properties/>   <NamedServices/></DeployedComponent>";

    RegistryDeleter(DeployedComponent deployedComponent) {
        super((Root)deployedComponent);
    }

    @Override
    protected void addDeletionTemplates(Map<String, String> deletionTemplateMap) throws ServiceException {
        super.addDeletionTemplates(deletionTemplateMap);
        String deleteTemplate = DELETE_TEMPLATE_SERVICE_REGISTRY;
        deletionTemplateMap.put("DeployedComponent", deleteTemplate);
        deleteTemplate = RegistryDeleter.getDeleteTemplateLocalizedResource();
        deletionTemplateMap.put("LocalizedResource", deleteTemplate);
        deleteTemplate = RegistryDeleter.getDeleteTemplateTextStore();
        deletionTemplateMap.put("TextStore", deleteTemplate);
        deleteTemplate = RegistryDeleter.getDeleteTemplateProperty();
        deletionTemplateMap.put("Property", deleteTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deleteMetadataObjects(List<CMetadata> deletedObjects) throws ServiceException {
        block9: {
            Throwable exception = null;
            String name = null;
            try {
                DeployedComponent deployedComponent = (DeployedComponent)this.getRoot();
                name = deployedComponent.getName();
                RegistryDeleter.deleteNamedServices((List<NamedService>)deployedComponent.getNamedServices(), deletedObjects);
                ServiceDeleter.addServiceTypesForDeletion(deletedObjects, deployedComponent);
                super.deleteMetadataObjects(deletedObjects);
            }
            catch (MdException e) {
                exception = e;
            }
            catch (RemoteException e) {
                exception = e;
            }
            catch (ClassCastException e) {
                exception = e;
            }
            finally {
                if (exception == null) break block9;
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"RegistryDeleter.delete.ex.fmt.txt", (Object)name);
                LogManager.getLogger(RegistryDeleter.class).error(msg, exception);
                throw new ServiceException(exception, msg);
            }
        }
    }

    private static void deleteNamedServices(List<NamedService> namedServiceList, List<CMetadata> deletedObjects) throws MdException {
        MdStore mdStore = null;
        try {
            int numNamedServices = namedServiceList.size();
            ArrayList<DeployedComponent> removedServices = new ArrayList<DeployedComponent>(numNamedServices);
            Iterator<NamedService> iter = namedServiceList.iterator();
            NamedService namedService = null;
            ArrayList<DeployedComponent> namedComponents = new ArrayList<DeployedComponent>(numNamedServices);
            ServiceComponent serviceComponent = null;
            while (iter.hasNext()) {
                namedService = iter.next();
                deletedObjects.add((CMetadata)namedService);
                namedComponents.add(namedService.getNamedComponent());
                removedServices.add(namedService.getNamedComponent());
                namedService.setNamedComponent(null);
                mdStore = namedService.getObjectStore();
                RootDeleter.deleteProperties((Root)namedService, deletedObjects);
                iter.remove();
            }
            for (DeployedComponent deployedComponent : namedComponents) {
                if (!(deployedComponent instanceof ServiceComponent) || (serviceComponent = (ServiceComponent)deployedComponent).getServiceNames().size() != 0 || serviceComponent.getIsRemotelyAccessible() != 1) continue;
                serviceComponent.setIsRemotelyAccessible(0);
                mdStore = serviceComponent.getObjectStore();
            }
            if (mdStore != null) {
                mdStore.updatedMetadataAll();
            }
        }
        catch (RemoteException e) {
            throw new MdException((Throwable)e);
        }
    }
}

