/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.InitializationException;
import com.sas.services.deployment.AbstractMetadataSource;
import com.sas.services.deployment.MetadataSourceInterface;
import com.sas.services.deployment.OMRMetadataSource;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.URLMetadataSource;
import com.sas.text.Message;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class PlatformServicesConfiguration {
    public static final String URL_OMR = "sas-oma://";
    public static final String URL_FILE = "file:/";
    private static final String REPOSNAME = ";reposname=";
    private final List<MetadataSourceInterface> _localMetadataSources = new ArrayList<MetadataSourceInterface>(5);
    private final List<MetadataSourceInterface> _remoteMetadataSources = new ArrayList<MetadataSourceInterface>(5);

    public PlatformServicesConfiguration(MetadataSourceInterface[] localMetadataSources, MetadataSourceInterface[] remoteMetadataSources) throws IllegalArgumentException {
        int i;
        int numRemoteItems;
        if (localMetadataSources == null && remoteMetadataSources == null) {
            throw new IllegalArgumentException();
        }
        int numLocalItems = localMetadataSources == null ? 0 : localMetadataSources.length;
        int n = numRemoteItems = remoteMetadataSources == null ? 0 : remoteMetadataSources.length;
        if (numLocalItems == 0 && numRemoteItems == 0) {
            throw new IllegalArgumentException();
        }
        for (i = 0; i < numLocalItems; ++i) {
            this._localMetadataSources.add(localMetadataSources[i]);
        }
        for (i = 0; i < numRemoteItems; ++i) {
            this._remoteMetadataSources.add(remoteMetadataSources[i]);
        }
    }

    public static final boolean isOpenMetadataRepositoryURL(String deploymentConfigurationURL) {
        boolean isOMRURL = false;
        if (deploymentConfigurationURL != null && deploymentConfigurationURL.startsWith(URL_OMR)) {
            isOMRURL = true;
        }
        return isOMRURL;
    }

    public MetadataSourceInterface[] getLocalMetadataSources() {
        MetadataSourceInterface[] metadataSources = null;
        if (this._localMetadataSources != null) {
            int numSources = this._localMetadataSources.size();
            metadataSources = new MetadataSourceInterface[numSources];
            System.arraycopy(this._localMetadataSources.toArray(), 0, metadataSources, 0, numSources);
        }
        return metadataSources;
    }

    public MetadataSourceInterface[] getRemoteMetadataSources() {
        MetadataSourceInterface[] metadataSources = null;
        if (this._remoteMetadataSources != null) {
            int numSources = this._remoteMetadataSources.size();
            metadataSources = new MetadataSourceInterface[numSources];
            System.arraycopy(this._remoteMetadataSources.toArray(), 0, metadataSources, 0, numSources);
        }
        return metadataSources;
    }

    public static final MetadataSourceInterface createMetadataSource(String url, String userId, String userPassword) {
        AbstractMetadataSource metadataSource = null;
        if (url != null) {
            int indexStart = URL_OMR.length();
            if (url.startsWith(URL_OMR)) {
                int index = url.indexOf(59, indexStart);
                if (index > 0) {
                    String hostPort = url.substring(indexStart, index);
                    index = hostPort.indexOf(58);
                    String host = hostPort;
                    String port = null;
                    String repositoryName = null;
                    int hostPortLength = hostPort.length();
                    if (index > 0 && index < hostPortLength) {
                        host = hostPort.substring(0, index);
                        port = hostPort.substring(++index, hostPortLength);
                    }
                    index = url.indexOf(REPOSNAME);
                    int endIndex = url.indexOf(59, index + 1);
                    if (index > 0 && endIndex > 0) {
                        repositoryName = url.substring(index + REPOSNAME.length(), endIndex);
                    }
                    try {
                        metadataSource = new OMRMetadataSource(host, port, userId, userPassword, repositoryName);
                    }
                    catch (InitializationException e) {
                        LogManager.getLogger(PlatformServicesConfiguration.class).error(RB.getStringResource("PlatformServicesConfiguration.newOMRMetadataSource.ex.txt"), (Throwable)((Object)e));
                        throw new IllegalArgumentException(e.getLocalizedMessage());
                    }
                }
            } else {
                try {
                    metadataSource = new URLMetadataSource(new URL(url));
                }
                catch (MalformedURLException e) {
                    LogManager.getLogger(PlatformServicesConfiguration.class).error(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataSourceFactory.malformedURL.ex.fmt.txt", (Object)url), (Throwable)e);
                    throw new IllegalArgumentException(e.getLocalizedMessage());
                }
            }
        }
        return metadataSource;
    }
}

