/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceException;
import com.sas.services.deployment.Environment;
import com.sas.services.deployment.MetadataSourceInterface;
import com.sas.services.deployment.PlatformServicesConfiguration;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.ServiceLoader;
import com.sas.services.deployment.ServiceLookupFailedException;
import com.sas.services.deployment.ServicesDeploymentEvent;
import com.sas.services.deployment.ServicesDeploymentEventListenerInterface;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.discovery.LocalDiscoveryServiceInterface;
import com.sas.services.discovery.ServiceNotAvailableException;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.discovery.Services;
import com.sas.text.Message;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class PlatformServices {
    private static int _servicesDeploymentState = 1;
    private static final List<ServicesDeploymentEventListenerInterface> SERVICE_DEPLOYMENT_LISTENERS = new ArrayList<ServicesDeploymentEventListenerInterface>(5);
    private static PlatformServicesConfiguration _pfsConfiguration = null;
    private static Environment _environment;

    private PlatformServices() {
    }

    public static final void setServicesConfiguration(PlatformServicesConfiguration servicesConfiguration) throws ServiceException {
        if (servicesConfiguration == null) {
            throw new ServiceException(RB.getStringResource("PlatformServices.invalidServiceConfiguration.ex.txt"));
        }
        _pfsConfiguration = servicesConfiguration;
    }

    public static final void setEnvironment(Environment environment) {
        _environment = environment;
    }

    public static final boolean setJAASAppConfigurationEntry(AppConfigurationEntry[] appConfigurationEntries) throws ServiceException {
        boolean isEnvironmentDefined;
        Environment environment = _environment;
        boolean bl = isEnvironmentDefined = environment != null;
        if (isEnvironmentDefined) {
            environment.setAppConfigurationEntry(appConfigurationEntries);
        }
        return isEnvironmentDefined;
    }

    static final void setDeploymentState(int deploymentState) throws ServiceException {
        if (ServicesDeploymentEvent.isValidState(deploymentState) && _servicesDeploymentState != deploymentState) {
            _servicesDeploymentState = deploymentState;
            PlatformServices.notifyServicesDeploymentListeners(new ServicesDeploymentEvent(deploymentState));
        }
    }

    static void notifyServicesDeploymentListeners(ServicesDeploymentEvent deploymentEvent) {
        if (deploymentEvent != null) {
            for (ServicesDeploymentEventListenerInterface listener : new ArrayList<ServicesDeploymentEventListenerInterface>(SERVICE_DEPLOYMENT_LISTENERS)) {
                try {
                    listener.handleServicesDeploymentEvent(deploymentEvent);
                }
                catch (RemoteException e) {
                    PlatformServices.removeServicesDeploymentListener(listener);
                }
            }
        }
    }

    public static final void addServicesDeploymentListener(ServicesDeploymentEventListenerInterface listener) throws ServiceException {
        try {
            if (listener != null && !SERVICE_DEPLOYMENT_LISTENERS.contains(listener)) {
                SERVICE_DEPLOYMENT_LISTENERS.add(listener);
                listener.handleServicesDeploymentEvent(new ServicesDeploymentEvent(_servicesDeploymentState));
            }
        }
        catch (RemoteException e) {
            throw new ServiceException(e);
        }
    }

    public static final void removeServicesDeploymentListener(ServicesDeploymentEventListenerInterface listener) {
        if (listener != null) {
            SERVICE_DEPLOYMENT_LISTENERS.remove(listener);
        }
    }

    public static void startServices() throws ServiceException, ServiceLookupFailedException {
        PlatformServices.startLocalServices();
        PlatformServices.lookupRemoteServices();
    }

    public static void startLocalServices() throws ServiceException {
        PlatformServices.setDeploymentState(2);
        Logger logger = LogManager.getLogger(PlatformServices.class);
        if (_pfsConfiguration != null) {
            int numSources;
            MetadataSourceInterface[] metadataSources = _pfsConfiguration.getLocalMetadataSources();
            int n = numSources = metadataSources == null ? 0 : metadataSources.length;
            if (numSources == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug(RB.getStringResource("PlatformServices.noLocalDeploymentsDefined.txt"));
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug(RB.getStringResource("PlatformServices.startingLocalServices.txt"));
                }
                MetadataSourceInterface metadataSource = null;
                try {
                    for (int i = 0; i < numSources; ++i) {
                        metadataSource = metadataSources[i];
                        ServiceLoader.deployServices(metadataSource, _environment, PlatformServices.getDiscoveryService());
                    }
                }
                catch (ServiceException e) {
                    logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"PlatformServices.errorEncounteredStartingServices.ex.fmt.txt", metadataSource), (Throwable)((Object)e));
                    throw e;
                }
            }
        }
        PlatformServices.setDeploymentState(8);
    }

    public static void lookupRemoteServices() throws ServiceException, ServiceLookupFailedException {
        PlatformServices.setDeploymentState(4);
        Logger logger = LogManager.getLogger(PlatformServices.class);
        if (_pfsConfiguration != null) {
            int numSources;
            MetadataSourceInterface[] metadataSources = _pfsConfiguration.getRemoteMetadataSources();
            int n = numSources = metadataSources == null ? 0 : metadataSources.length;
            if (numSources == 0) {
                if (logger != null && logger.isDebugEnabled()) {
                    logger.debug(RB.getStringResource("PlatformServices.noRemoteDeploymentsDefined.txt"));
                }
            } else {
                if (logger != null && logger.isDebugEnabled()) {
                    logger.debug(RB.getStringResource("PlatformServices.lookingUpRemoteServices.txt"));
                }
                MetadataSourceInterface metadataSource = null;
                try {
                    for (int i = 0; i < numSources; ++i) {
                        metadataSource = metadataSources[i];
                        ServiceLoader.lookupRemoteDiscoveryServices(metadataSource, PlatformServices.getDiscoveryService());
                    }
                }
                catch (ServiceException e) {
                    if (logger != null) {
                        logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"PlatformServices.errorEncounteredLookingUpServices.ex.fmt.txt", (Object)metadataSource), (Throwable)((Object)e));
                    }
                    throw e;
                }
            }
        }
        PlatformServices.setDeploymentState(16);
    }

    public static void terminateServices() throws ServiceException {
        LocalDiscoveryServiceInterface discoverySvc;
        PlatformServices.setDeploymentState(64);
        Logger logger = LogManager.getLogger(PlatformServices.class);
        if (logger.isDebugEnabled()) {
            logger.debug(RB.getStringResource("PlatformServices.terminatingServices.txt"));
        }
        if ((discoverySvc = DiscoveryService.defaultInstance()) != null) {
            try {
                discoverySvc.destroy();
            }
            catch (RemoteException e) {
                throw new ServiceException(e, RB.getStringResource("PlatformServices.exceptionEncounteredTerminatingSvcs.ex.txt"));
            }
        }
        PlatformServices.setDeploymentState(128);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final RemoteServiceInterface findServiceUsingId(String serviceId) throws ServiceException, ServiceNotAvailableException {
        RemoteServiceInterface service = null;
        DiscoveryServiceInterface discoverySvc = PlatformServices.getDiscoveryService();
        if (discoverySvc == null) {
            throw new ServiceNotAvailableException(RB.getStringResource("PlatformServices.noLocalDiscoveryService.ext.txt"));
        }
        Serializable exception = null;
        try {
            service = discoverySvc.findServiceUsingId(serviceId);
        }
        catch (RemoteException e) {
            exception = e;
        }
        catch (ServiceException e) {
            exception = e;
        }
        finally {
            if (exception != null) {
                try {
                    PlatformServices.lookupRemoteServices();
                    service = discoverySvc.findServiceUsingId(serviceId);
                }
                catch (RemoteException e) {
                    throw new ServiceNotAvailableException(e, Message.format((ResourceBundle)RB.getResources(), (String)"PlatformServices.findServiceByIdRemoteEx.ex.fmt.txt", (Object)serviceId));
                }
            }
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final RemoteServiceInterface findService(ServiceTemplate serviceTemplate) throws ServiceException, ServiceNotAvailableException {
        RemoteServiceInterface service = null;
        DiscoveryServiceInterface discoverySvc = PlatformServices.getDiscoveryService();
        if (discoverySvc == null) {
            throw new ServiceNotAvailableException(RB.getStringResource("PlatformServices.noLocalDiscoveryService.ext.txt"));
        }
        Serializable exception = null;
        try {
            service = discoverySvc.findService(serviceTemplate);
        }
        catch (ServiceException e) {
            exception = e;
        }
        catch (RemoteException e) {
            exception = e;
        }
        finally {
            if (exception != null) {
                try {
                    PlatformServices.lookupRemoteServices();
                    service = PlatformServices.getDiscoveryService().findService(serviceTemplate);
                }
                catch (RemoteException e) {
                    throw new ServiceNotAvailableException(e, Message.format((ResourceBundle)RB.getResources(), (String)"PlatformServices.findServiceByTemplateRemoteEx.ex.fmt.txt", (Object)serviceTemplate));
                }
            }
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Services findServices(ServiceTemplate serviceTemplate, int maxNumMatches, Services services) throws ServiceException, ServiceNotAvailableException {
        Services discoveredServices = services == null ? new Services() : services;
        DiscoveryServiceInterface discoverySvc = PlatformServices.getDiscoveryService();
        if (discoverySvc == null) {
            throw new ServiceNotAvailableException(RB.getStringResource("PlatformServices.noLocalDiscoveryService.ext.txt"));
        }
        Serializable exception = null;
        try {
            discoveredServices = discoverySvc.findServices(serviceTemplate, maxNumMatches, services);
        }
        catch (RemoteException e) {
            exception = e;
        }
        catch (ServiceException e) {
            exception = e;
        }
        finally {
            if (exception != null) {
                try {
                    PlatformServices.lookupRemoteServices();
                    discoveredServices = PlatformServices.getDiscoveryService().findServices(serviceTemplate, maxNumMatches, services);
                }
                catch (RemoteException e) {
                    throw new ServiceNotAvailableException(e, Message.format((ResourceBundle)RB.getResources(), (String)"PlatformServices.findServiceByTemplateRemoteEx.ex.fmt.txt", (Object)serviceTemplate));
                }
            }
        }
        return discoveredServices;
    }

    public static final DiscoveryServiceInterface getDiscoveryService() {
        return DiscoveryService.defaultInstance();
    }

    public static final Services getServices() throws ServiceException {
        Services services = new Services();
        try {
            services = PlatformServices.getDiscoveryService().findServices(new ServiceTemplate(new Class[]{RemoteServiceInterface.class}), Integer.MAX_VALUE, services);
        }
        catch (RemoteException e) {
            throw new ServiceException(e);
        }
        return services;
    }
}

