/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.deployment.RB;
import com.sas.text.Message;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class MetadataSourceProperties {
    private final Properties _properties = new Properties();

    public MetadataSourceProperties() {
    }

    public MetadataSourceProperties(Properties properties) throws ServiceException {
        this.setProperties(properties);
    }

    public void setPropertiesURL(URL propertiesURL) throws ServiceException {
        if (propertiesURL != null) {
            InputStream inputStream = null;
            try {
                Properties properties = new Properties();
                inputStream = propertiesURL.openStream();
                properties.load(inputStream);
                this.setProperties(properties);
            }
            catch (IOException e) {
                throw new ServiceException(e, Message.format((ResourceBundle)RB.getResources(), (String)"MetadataSourceProperties.setPropertiesURL.ex.fmt.txt", (Object)propertiesURL));
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        LogManager.getLogger(MetadataSourceProperties.class).error(RB.getStringResource("IOStream.close.ex.log"), (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(Properties properties) throws ServiceException {
        Properties properties2 = this._properties;
        synchronized (properties2) {
            this._properties.clear();
            if (properties != null) {
                this._properties.putAll((Map<?, ?>)properties);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getProperties() {
        Properties properties = new Properties();
        Properties properties2 = this._properties;
        synchronized (properties2) {
            properties.putAll((Map<?, ?>)this._properties);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Properties properties = this._properties;
        synchronized (properties) {
            this._properties.clear();
        }
    }
}

