/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.services.ServiceException;
import com.sas.services.deployment.AbstractDeploymentStrategy;
import com.sas.services.deployment.DeploymentStrategyInterface;
import com.sas.services.deployment.RB;
import java.io.File;
import java.util.HashMap;
import java.util.Properties;
import org.w3c.dom.Document;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class DeploymentDescriptorContext
implements DeploymentStrategyInterface {
    private AbstractDeploymentStrategy _strategy;

    public DeploymentDescriptorContext(AbstractDeploymentStrategy strategy) throws ServiceException {
        if (strategy == null) {
            throw new ServiceException(RB.getStringResource("IllegalArgument.specifyStrategy.ex.txt"));
        }
        this._strategy = strategy;
    }

    public final void setProperty(String key, String value) {
        this._strategy.setProperty(key, value);
    }

    public final String getProperty(String key) {
        return this._strategy.getProperty(key);
    }

    public final String getPropertySoftwareComponent() {
        return this._strategy.getProperty("software_component");
    }

    public final void setPropertySoftwareComponent(String softwareComponentName) {
        this._strategy.setProperty("software_component", softwareComponentName);
    }

    public Document createDocument(SoftwareComponent softwareComponent) throws ServiceException {
        return this._strategy.createDocument(softwareComponent, new HashMap(5));
    }

    @Override
    public void createFile(SoftwareComponent softwareComponent, File file) throws ServiceException {
        this._strategy.createFile(softwareComponent, file);
    }

    @Override
    public void createFiles(SoftwareComponent softwareComponent, File file, File clientFile) throws ServiceException {
        this._strategy.createFiles(softwareComponent, file, clientFile);
    }

    @Override
    public void reconfigure(Properties properties, File inputFile, File outputFile) throws ServiceException {
        this._strategy.reconfigure(properties, inputFile, outputFile);
    }
}

