/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.SASScope;
import com.sas.services.deployment.ConsumedResourceInterface;
import com.sas.services.deployment.Consumer;
import com.sas.services.deployment.ConsumerResourceAssoc;
import com.sas.services.deployment.RB;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.UsageVersion;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SASScope
public final class ConsumerUsage
implements Cloneable {
    public static final String XML_ELEMENT_CONSUMERUSAGE = "ConsumerUsage";
    static final String XML_ELEMENT_CONSUMERESOURCEASSOCS = "ConsumerResourceAssocs";
    static final String XML_ELEMENT_CONSUMERS = "Consumers";
    private static final String XML_ATTRIBUTE_VERSION = "version";
    private UsageVersion _usageVersionOldest = new UsageVersion(0, 0);
    private UsageVersion _usageVersionCurrent = new UsageVersion(0, 0);
    private UsageVersion _usageVersion = new UsageVersion(0, 0);
    private Map<String, Consumer> _consumerMap = new HashMap<String, Consumer>(5);
    private Map<String, ConsumerResourceAssoc> _consumerResourceAssocMap = new HashMap<String, ConsumerResourceAssoc>(5);
    private Map<String, ConsumedResourceInterface> _consumedResourceMap = new HashMap<String, ConsumedResourceInterface>(25);

    public ConsumerUsage() {
    }

    public ConsumerUsage(Element element) throws IllegalArgumentException {
        this.configureUsingElement(element);
    }

    public void configureUsingElement(Element element) throws IllegalArgumentException {
        NodeList nodeList;
        int numNodes;
        if (element == null || !XML_ELEMENT_CONSUMERUSAGE.equals(element.getNodeName())) {
            throw new IllegalArgumentException();
        }
        String value = element.getAttribute(XML_ATTRIBUTE_VERSION);
        if (value.trim().length() > 0) {
            try {
                this.setUsageVersion(UsageVersion.decode((double)Double.valueOf(value)));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        if ((numNodes = (nodeList = element.getChildNodes()).getLength()) > 0) {
            Node node = null;
            String nodeName = null;
            for (int i = 0; i < numNodes; ++i) {
                int j;
                int numChildNodes;
                NodeList childNodes;
                node = nodeList.item(i);
                if (1 != node.getNodeType()) continue;
                nodeName = node.getNodeName();
                if (XML_ELEMENT_CONSUMERS.equals(nodeName)) {
                    childNodes = node.getChildNodes();
                    numChildNodes = childNodes.getLength();
                    for (j = 0; j < numChildNodes; ++j) {
                        node = childNodes.item(j);
                        if (1 != node.getNodeType() || !"Consumer".equals(node.getNodeName())) continue;
                        this.addConsumer(new Consumer((Element)node), false);
                    }
                    continue;
                }
                if (!XML_ELEMENT_CONSUMERESOURCEASSOCS.equals(nodeName)) continue;
                childNodes = node.getChildNodes();
                numChildNodes = childNodes.getLength();
                for (j = 0; j < numChildNodes; ++j) {
                    node = childNodes.item(j);
                    if (1 != node.getNodeType() || !"ConsumerResourceAssoc".equals(node.getNodeName())) continue;
                    this.addConsumerResource(new ConsumerResourceAssoc((Element)node));
                }
            }
        }
    }

    public Consumer addConsumer(Consumer consumer, boolean isConsumer) {
        String consumerID;
        Consumer consumerAdded = null;
        if (consumer != null && (consumerAdded = this._consumerMap.get(consumerID = consumer.getID())) == null) {
            String name = consumer.getName();
            for (Consumer nextConsumer : this._consumerMap.values()) {
                if (!name.equals(nextConsumer.getName())) continue;
                consumerAdded = nextConsumer;
                break;
            }
            if (consumerAdded == null) {
                this._consumerMap.put(consumerID, consumer);
                consumerAdded = consumer;
                ConsumedResourceInterface consumedResource = null;
                ConsumerResourceAssoc consumerResourceAssoc = null;
                for (Map.Entry<String, ConsumedResourceInterface> mapEntry : this._consumedResourceMap.entrySet()) {
                    consumedResource = mapEntry.getValue();
                    consumerResourceAssoc = new ConsumerResourceAssoc(null, consumerID, consumedResource.getResourceID(), isConsumer);
                    this._consumerResourceAssocMap.put(consumerResourceAssoc.getID(), consumerResourceAssoc);
                }
            }
        }
        return consumerAdded;
    }

    public Consumer removeConsumer(Consumer consumer) {
        Consumer removedObject = null;
        if (consumer != null) {
            String consumerID = consumer.getID();
            removedObject = this._consumerMap.remove(consumerID);
            ConsumerResourceAssoc consumerResource = null;
            Iterator<ConsumerResourceAssoc> iter = this._consumerResourceAssocMap.values().iterator();
            while (iter.hasNext()) {
                consumerResource = iter.next();
                if (!consumerID.equals(consumerResource.getConsumerID())) continue;
                iter.remove();
            }
        }
        return removedObject;
    }

    public void setIsConsumer(Consumer consumer, boolean isConsumer) {
        if (consumer != null) {
            for (ConsumerResourceAssoc consumerResourceAssoc : this.getConsumerResourceAssocsForConsumer(consumer.getID())) {
                consumerResourceAssoc.setIsConsumer(isConsumer);
            }
        }
    }

    public ConsumedResourceInterface getResourceUsingUID(String id) {
        ConsumedResourceInterface consumedResource = null;
        if (id != null) {
            consumedResource = this._consumedResourceMap.get(id);
        }
        return consumedResource;
    }

    public Set<String> getResourceIDs() {
        return new HashSet<String>(this._consumedResourceMap.keySet());
    }

    public Consumer getConsumerUsingUID(String id) {
        Consumer consumer = null;
        if (id != null) {
            consumer = this._consumerMap.get(id);
        }
        return consumer;
    }

    public Set<Consumer> getConsumers() {
        return new HashSet<Consumer>(this._consumerMap.values());
    }

    public Consumer getConsumerUsingName(String name) {
        Consumer consumer = null;
        if (name != null) {
            for (Consumer nextConsumer : this._consumerMap.values()) {
                if (!name.equals(nextConsumer.getName())) continue;
                consumer = nextConsumer;
                break;
            }
        }
        return consumer;
    }

    public void addResource(ConsumedResourceInterface consumedResource) {
        String resourceId;
        ConsumedResourceInterface consumedResource2;
        if (consumedResource != null && (consumedResource2 = this._consumedResourceMap.get(resourceId = consumedResource.getResourceID())) == null) {
            this._consumedResourceMap.put(resourceId, consumedResource);
            for (Consumer consumer : this._consumerMap.values()) {
                this.addConsumerResource(new ConsumerResourceAssoc(null, consumer.getID(), resourceId, false));
            }
        }
    }

    public ConsumedResourceInterface removeResource(String resourceID) {
        ConsumedResourceInterface removedObject = null;
        if (resourceID != null) {
            removedObject = this._consumedResourceMap.remove(resourceID);
            ConsumerResourceAssoc consumerResource = null;
            Iterator<ConsumerResourceAssoc> iter = this._consumerResourceAssocMap.values().iterator();
            while (iter.hasNext()) {
                consumerResource = iter.next();
                if (!resourceID.equals(consumerResource.getResourceID())) continue;
                iter.remove();
            }
        }
        return removedObject;
    }

    public ConsumedResourceInterface getConsumedResource(String id) {
        return this._consumedResourceMap.get(id);
    }

    public Set<ConsumedResourceInterface> getConsumedResources() {
        return new HashSet<ConsumedResourceInterface>(this._consumedResourceMap.values());
    }

    private ConsumerResourceAssoc addConsumerResource(ConsumerResourceAssoc consumerResourceAssoc) {
        ConsumerResourceAssoc addedConsumerResource = null;
        if (consumerResourceAssoc != null) {
            addedConsumerResource = this._consumerResourceAssocMap.get(consumerResourceAssoc.getID());
            if (addedConsumerResource == null) {
                String consumerId = consumerResourceAssoc.getConsumerID();
                String resourceId = consumerResourceAssoc.getResourceID();
                for (ConsumerResourceAssoc nextConsumerResource : this._consumerResourceAssocMap.values()) {
                    if (!consumerId.equals(nextConsumerResource.getConsumerID()) || !resourceId.equals(nextConsumerResource.getResourceID())) continue;
                    nextConsumerResource.setIsConsumer(consumerResourceAssoc.isConsumer());
                    addedConsumerResource = nextConsumerResource;
                    break;
                }
                if (addedConsumerResource == null) {
                    this._consumerResourceAssocMap.put(consumerResourceAssoc.getID(), consumerResourceAssoc);
                    addedConsumerResource = consumerResourceAssoc;
                }
            } else {
                addedConsumerResource.setIsConsumer(consumerResourceAssoc.isConsumer());
            }
        }
        return addedConsumerResource;
    }

    public Set<ConsumerResourceAssoc> getConsumerResourceAssocs() {
        return new HashSet<ConsumerResourceAssoc>(this._consumerResourceAssocMap.values());
    }

    public Set<ConsumerResourceAssoc> getConsumerResourceAssocsForResourceID(String resourceID) {
        HashSet<ConsumerResourceAssoc> set = new HashSet<ConsumerResourceAssoc>(this._consumerResourceAssocMap.size());
        if (resourceID != null) {
            for (ConsumerResourceAssoc cra : new HashSet<ConsumerResourceAssoc>(this._consumerResourceAssocMap.values())) {
                if (!resourceID.equals(cra.getResourceID())) continue;
                set.add(cra);
            }
        }
        return set;
    }

    public ConsumerResourceAssoc getConsumerResourceAssocUsingID(String consumerResourceAssocID) {
        return this._consumerResourceAssocMap.get(consumerResourceAssocID);
    }

    public ConsumerResourceAssoc getConsumerResourceAssoc(ConsumerResourceAssoc consumerResourceAssocIn) {
        ConsumerResourceAssoc consumerResourceAssoc = null;
        if (consumerResourceAssocIn != null && (consumerResourceAssoc = this.getConsumerResourceAssocUsingID(consumerResourceAssocIn.getID())) != null) {
            String consumerID = consumerResourceAssoc.getConsumerID();
            String resourceID = consumerResourceAssoc.getResourceID();
            for (ConsumerResourceAssoc nextConsumerResourceAssoc : this._consumerResourceAssocMap.values()) {
                if (!consumerID.equals(nextConsumerResourceAssoc.getConsumerID()) || !resourceID.equals(nextConsumerResourceAssoc.getResourceID())) continue;
                consumerResourceAssoc = nextConsumerResourceAssoc;
                break;
            }
        }
        return consumerResourceAssoc;
    }

    public boolean addConsumerResourceAssoc(ConsumerResourceAssoc consumerResourceAssoc) {
        boolean wasAdded = false;
        if (consumerResourceAssoc != null) {
            String id = consumerResourceAssoc.getID();
            ConsumerResourceAssoc consumerResourceAssoc2 = this.getConsumerResourceAssoc(consumerResourceAssoc);
            if (consumerResourceAssoc2 == null) {
                this._consumerResourceAssocMap.put(id, consumerResourceAssoc);
                wasAdded = true;
            } else {
                consumerResourceAssoc2.setIsConsumer(consumerResourceAssoc.isConsumer());
                wasAdded = true;
            }
        }
        return wasAdded;
    }

    public Set<ConsumerResourceAssoc> getConsumerResourceAssocsForConsumer(String consumerID) {
        HashSet<ConsumerResourceAssoc> consumerResourceAssocs = new HashSet<ConsumerResourceAssoc>(this._consumerResourceAssocMap.size());
        if (consumerID != null) {
            for (ConsumerResourceAssoc consumerResourceAssoc : this._consumerResourceAssocMap.values()) {
                if (!consumerID.equals(consumerResourceAssoc.getConsumerID())) continue;
                consumerResourceAssocs.add(consumerResourceAssoc);
            }
        }
        return consumerResourceAssocs;
    }

    public Set<Consumer> getConsumersForResource(String resourceID, boolean isConsumed) {
        HashSet<Consumer> consumers = new HashSet<Consumer>(5);
        if (resourceID != null) {
            Consumer consumer = null;
            for (ConsumerResourceAssoc consumerResourceAssoc : this._consumerResourceAssocMap.values()) {
                if (isConsumed != consumerResourceAssoc.isConsumer() || !resourceID.equals(consumerResourceAssoc.getResourceID()) || (consumer = this.getConsumerUsingUID(consumerResourceAssoc.getConsumerID())) == null) continue;
                consumers.add(consumer);
            }
        }
        return consumers;
    }

    public Set<ConsumerResourceAssoc> getConsumerResourceAssocsForConsumers(Set<String> consumerIDs, Boolean isConsumed) {
        HashSet<ConsumerResourceAssoc> consumerResourceAssocs = new HashSet<ConsumerResourceAssoc>(this._consumerResourceAssocMap.size());
        if (consumerIDs != null) {
            for (ConsumerResourceAssoc consumerResourceAssoc : this._consumerResourceAssocMap.values()) {
                for (String consumerID : consumerIDs) {
                    if (!consumerID.equals(consumerResourceAssoc.getConsumerID()) || isConsumed != null && consumerResourceAssoc.isConsumer() != isConsumed.booleanValue()) continue;
                    consumerResourceAssocs.add(consumerResourceAssoc);
                }
            }
        }
        return consumerResourceAssocs;
    }

    public ConsumerResourceAssoc getConsumerResourceAssocsForConsumerAndResource(String consumerID, String resourceID) {
        ConsumerResourceAssoc consumerResourceAssoc = null;
        if (consumerID != null && resourceID != null) {
            for (ConsumerResourceAssoc nextConsumerResourceAssoc : this._consumerResourceAssocMap.values()) {
                if (!consumerID.equals(nextConsumerResourceAssoc.getConsumerID()) || !resourceID.equals(nextConsumerResourceAssoc.getResourceID())) continue;
                consumerResourceAssoc = nextConsumerResourceAssoc;
                break;
            }
        }
        return consumerResourceAssoc;
    }

    public ConsumerResourceAssoc getConsumerResourceUsingUID(String id) {
        ConsumerResourceAssoc consumerResource = null;
        if (id != null) {
            consumerResource = this._consumerResourceAssocMap.get(id);
        }
        return consumerResource;
    }

    public Element createElement(Document document) {
        if (document == null) {
            throw new IllegalArgumentException();
        }
        Element element = document.createElement(XML_ELEMENT_CONSUMERUSAGE);
        element.setAttribute(XML_ATTRIBUTE_VERSION, Integer.toString(Double.valueOf(this._usageVersionCurrent.encode()).intValue()));
        if (this._consumerMap.size() > 0) {
            Element consumersElement = document.createElement(XML_ELEMENT_CONSUMERS);
            element.appendChild(consumersElement);
            for (Consumer consumer : this._consumerMap.values()) {
                consumersElement.appendChild(consumer.createElement(document));
            }
        }
        if (this._consumerResourceAssocMap.size() > 0) {
            Element consumedResourcesElement = document.createElement(XML_ELEMENT_CONSUMERESOURCEASSOCS);
            element.appendChild(consumedResourcesElement);
            for (ConsumerResourceAssoc consumerResourceAssoc : this._consumerResourceAssocMap.values()) {
                consumedResourcesElement.appendChild(consumerResourceAssoc.createElement(document));
            }
        }
        return element;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        String lineSep = System.getProperty("line.separator");
        sb.append(lineSep);
        sb.append("Consumers: ");
        sb.append(lineSep);
        for (Consumer consumer : this._consumerMap.values()) {
            sb.append(consumer.toString());
            sb.append(lineSep);
        }
        sb.append("Resources: ");
        sb.append(lineSep);
        for (ConsumedResourceInterface resource : this._consumedResourceMap.values()) {
            sb.append(resource.getResourceType() + ": " + resource.getResourceValue() + " - " + resource.getResourceID());
            sb.append(lineSep);
        }
        sb.append("ConsumedResourceAssocs: ");
        sb.append(lineSep);
        for (ConsumerResourceAssoc consumerResource : this._consumerResourceAssocMap.values()) {
            sb.append(consumerResource.toString());
            sb.append(lineSep);
        }
        return sb.toString();
    }

    private void setUsageVersion(UsageVersion usageVersion) {
        if (!usageVersion.isCompatible(this._usageVersionOldest, this._usageVersionCurrent)) {
            throw new IllegalArgumentException();
        }
        this._usageVersion = usageVersion;
    }

    public Set<ConsumerResourceAssoc> validate() {
        HashSet<ConsumerResourceAssoc> removedConsumerResourceAssocs = new HashSet<ConsumerResourceAssoc>(5);
        Logger logger = LogManager.getLogger(ConsumerUsage.class);
        boolean isDebugLogEnabled = logger.isDebugEnabled();
        ConsumerResourceAssoc consumerResourceAssoc = null;
        Iterator<ConsumerResourceAssoc> iter = this._consumerResourceAssocMap.values().iterator();
        while (iter.hasNext()) {
            consumerResourceAssoc = iter.next();
            if (this.getConsumedResource(consumerResourceAssoc.getResourceID()) == null) {
                iter.remove();
                removedConsumerResourceAssocs.add(consumerResourceAssoc);
                System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"ConsumerUsage.removedAssocForUndefinedResource.fmt.log", (Object)consumerResourceAssoc.getResourceID()));
                if (!isDebugLogEnabled) continue;
                logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ConsumerUsage.removedAssocForUndefinedResource.fmt.log", (Object)consumerResourceAssoc.getResourceID()));
                continue;
            }
            if (this.getConsumerUsingUID(consumerResourceAssoc.getConsumerID()) != null) continue;
            iter.remove();
            removedConsumerResourceAssocs.add(consumerResourceAssoc);
            if (isDebugLogEnabled) {
                logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ConsumerUsage.removedAssocForUndefinedConsumer.fmt.log", (Object)consumerResourceAssoc.getConsumerID()));
            }
            System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"ConsumerUsage.removedAssocForUndefinedConsumer.fmt.log", (Object)consumerResourceAssoc.getConsumerID()));
        }
        return removedConsumerResourceAssocs;
    }

    public Object clone() throws CloneNotSupportedException {
        ConsumerUsage clone = (ConsumerUsage)super.clone();
        clone._usageVersion = new UsageVersion(this._usageVersion.getMajorVersion(), this._usageVersion.getMinorVersion(), this._usageVersion.getMicroVersion());
        clone._usageVersionOldest = new UsageVersion(this._usageVersionOldest.getMajorVersion(), this._usageVersionOldest.getMinorVersion(), this._usageVersionOldest.getMicroVersion());
        clone._usageVersionCurrent = new UsageVersion(this._usageVersionCurrent.getMajorVersion(), this._usageVersionCurrent.getMinorVersion(), this._usageVersionCurrent.getMicroVersion());
        clone._consumerMap = new HashMap<String, Consumer>(this._consumerMap.size());
        for (Map.Entry<String, Consumer> entry : this._consumerMap.entrySet()) {
            clone._consumerMap.put(entry.getKey(), (Consumer)entry.getValue().clone());
        }
        clone._consumerResourceAssocMap = new HashMap<String, ConsumerResourceAssoc>(this._consumerResourceAssocMap.size());
        for (Map.Entry<String, Cloneable> entry : this._consumerResourceAssocMap.entrySet()) {
            clone._consumerResourceAssocMap.put(entry.getKey(), (ConsumerResourceAssoc)((ConsumerResourceAssoc)entry.getValue()).clone());
        }
        clone._consumedResourceMap = new HashMap<String, ConsumedResourceInterface>(this._consumedResourceMap.size());
        for (Map.Entry<String, Cloneable> entry : this._consumedResourceMap.entrySet()) {
            clone._consumedResourceMap.put(entry.getKey(), (ConsumedResourceInterface)((ConsumedResourceInterface)entry.getValue()).clone());
        }
        return clone;
    }

    public void merge(ConsumerUsage otherConsumerUsage, Map<String, String> resourceIdMap) {
        if (resourceIdMap != null && otherConsumerUsage != null) {
            Consumer otherConsumer2 = null;
            Consumer thisConsumer = null;
            ConsumerResourceAssoc otherConsumerResourceAssoc2 = null;
            ConsumerResourceAssoc thisConsumerResourceAssoc2 = null;
            Set<ConsumerResourceAssoc> otherConsumerResourceAssocSet = null;
            String otherConsumerID = null;
            String otherConsumerName = null;
            String otherResourceID = null;
            String thisResourceID = null;
            for (Consumer otherConsumer2 : otherConsumerUsage.getConsumers()) {
                otherConsumerID = otherConsumer2.getID();
                otherConsumerName = otherConsumer2.getName();
                thisConsumer = this.getConsumerUsingName(otherConsumerName);
                if (thisConsumer == null) {
                    thisConsumer = this.addConsumer(new Consumer(otherConsumerName), false);
                }
                if ((otherConsumerResourceAssocSet = otherConsumerUsage.getConsumerResourceAssocsForConsumer(otherConsumerID)).size() > 0) {
                    for (ConsumerResourceAssoc otherConsumerResourceAssoc2 : otherConsumerResourceAssocSet) {
                        otherResourceID = otherConsumerResourceAssoc2.getResourceID();
                        thisResourceID = resourceIdMap.get(otherResourceID);
                        if (thisResourceID == null) continue;
                        thisConsumerResourceAssoc2 = this.getConsumerResourceAssocsForConsumerAndResource(thisConsumer.getID(), thisResourceID);
                        if (thisConsumerResourceAssoc2 == null) {
                            this.addConsumerResourceAssoc(new ConsumerResourceAssoc(null, thisConsumer.getID(), thisResourceID, otherConsumerResourceAssoc2.isConsumer()));
                            continue;
                        }
                        thisConsumerResourceAssoc2.setIsConsumer(otherConsumerResourceAssoc2.isConsumer());
                    }
                    continue;
                }
                for (ConsumerResourceAssoc thisConsumerResourceAssoc2 : this.getConsumerResourceAssocsForConsumer(thisConsumer.getID())) {
                    if (thisConsumerResourceAssoc2 == null) continue;
                    thisConsumerResourceAssoc2.setIsConsumer(false);
                }
            }
        }
    }

    boolean renameConsumer(String oldConsumerName, String newConsumerName) {
        boolean wasRenamed = false;
        for (Consumer consumer : this._consumerMap.values()) {
            if (!Strings.equal((String)oldConsumerName, (String)consumer.getName(), (boolean)true, (boolean)false)) continue;
            consumer.setName(newConsumerName);
            wasRenamed = true;
        }
        return wasRenamed;
    }
}

