/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services;

import com.sas.services.RB;
import com.sas.services.ServiceException;
import com.sas.text.Message;
import java.io.Serializable;
import java.util.ResourceBundle;

public class ServiceState
implements Serializable {
    private static final long serialVersionUID = -2164634773505166526L;
    public static final short SERVICE_STATE_UNINITIALIZED = 0;
    public static final short SERVICE_STATE_INITIALIZED = 1;
    public static final short SERVICE_STATE_DEACTIVATED = 2;
    private short _serviceState = 0;

    public ServiceState() {
    }

    public ServiceState(short serviceState) throws ServiceException {
        this.setServiceState(serviceState);
    }

    public final short getServiceState() {
        return this._serviceState;
    }

    public final void setServiceState(short serviceState) throws ServiceException {
        switch (serviceState) {
            case 0: 
            case 1: 
            case 2: {
                this._serviceState = serviceState;
                break;
            }
            default: {
                ServiceState.handleInvalidServiceState(serviceState);
            }
        }
    }

    public final String getDescription() {
        return ServiceState.getDescriptionForState(this._serviceState);
    }

    public static final boolean isStateUninitialized(short serviceState) {
        return 0 == serviceState;
    }

    public static final boolean isStateInitialized(short serviceState) {
        return 1 == serviceState;
    }

    public static final boolean isStateDeactivated(short serviceState) {
        return 2 == serviceState;
    }

    public static final String getDescriptionForState(short serviceState) throws IllegalArgumentException {
        String desc = null;
        switch (serviceState) {
            case 0: {
                desc = RB.getStringResource("ServiceState.descUninitialized.txt");
                break;
            }
            case 1: {
                desc = RB.getStringResource("ServiceState.descInitialized.txt");
                break;
            }
            case 2: {
                desc = RB.getStringResource("ServiceState.descDeactivated.txt");
                break;
            }
            default: {
                ServiceState.throwIllegalArgumentException(serviceState);
            }
        }
        return desc;
    }

    private static final void handleInvalidServiceState(short invalidServiceState) throws ServiceException {
        throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceState.invalidServiceState.ex.fmt.txt", (Object)invalidServiceState));
    }

    private static final void throwIllegalArgumentException(short invalidServiceState) throws IllegalArgumentException {
        throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceState.invalidServiceState.ex.fmt.txt", (Object)invalidServiceState));
    }
}

