/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServiceComponent;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TextStore;
import com.sas.services.AbstractServiceComponentConfig;
import com.sas.services.RB;
import com.sas.services.ServiceAggregateConfig;
import com.sas.services.ServiceComponentConfigInterface;
import com.sas.services.ServiceConfigDocument;
import com.sas.services.ServiceException;
import com.sas.services.deployment.Consumer;
import com.sas.services.deployment.ExportServiceConfigInterface;
import com.sas.services.deployment.MergeServiceConfigInterface;
import com.sas.services.deployment.ServiceDeployment;
import com.sas.services.util.XMLUtil;
import com.sas.text.Message;
import java.io.File;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ResourceBundle;
import org.w3c.dom.Document;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class ServiceProfile
implements ExportServiceConfigInterface,
MergeServiceConfigInterface {
    public static final int ACTION_EXPORT = 1;
    public static final int ACTION_MERGE = 2;
    public static final int ACTION_INSTALL = 4;
    private static final String CONFIGURATIONTYPE_APPLICATION = "Application Configuration";
    private static final String CONFIGURATIONTYPE_BASE = "Base Configuration";
    private static final String DEPRECATED = "mode=\"deprecated\"";
    private boolean _isDeprecated = false;
    private ServiceComponentConfigInterface _serviceComponentConfiguration;
    private final int _supportedActions;
    private String[] _dependentServiceInterfaces;
    private String _serviceInterfaceClass;
    private String _serviceImplementationClass;
    private String _configUserInterfaceClassName;
    private final boolean _isSingletonService;

    public ServiceProfile(ServiceComponentConfigInterface serviceComponentConfiguration, int supportedActions, String[] dependentServiceInterfaces, String serviceInterfaceClass, String serviceImplementationClass, String configUserInterfaceClassName, boolean isSingletonService) throws IllegalArgumentException {
        this._supportedActions = supportedActions;
        this._isSingletonService = isSingletonService;
        this.setDependentServiceInterfaces(dependentServiceInterfaces);
        this.setServiceInterfaceClass(serviceInterfaceClass);
        this.setServiceImplementationClass(serviceImplementationClass);
        this.setConfigUserInterfaceClassName(configUserInterfaceClassName);
        this.setServiceComponentConfiguration(serviceComponentConfiguration);
    }

    public boolean hasServiceConfig() {
        return this._serviceComponentConfiguration != null;
    }

    public boolean hasServiceConfig(ServiceComponent serviceComponent) throws MdException, RemoteException {
        if (!this.hasServiceConfig()) {
            return false;
        }
        boolean hasConfig = true;
        AssociationList properties = serviceComponent.getProperties();
        for (Property property : properties) {
            TextStore textStore;
            String xmlString;
            if (!"INIT_DATA".equals(property.getPropertyName()) || !"".equals(xmlString = (textStore = (TextStore)property.getStoredConfiguration()).getStoredText()) && xmlString.indexOf(DEPRECATED) == -1) continue;
            hasConfig = false;
            break;
        }
        return hasConfig;
    }

    public String getServiceInterfaceClass() {
        return this._serviceInterfaceClass;
    }

    public final void setServiceInterfaceClass(String serviceInterface) {
        this._serviceInterfaceClass = serviceInterface;
    }

    public String getServiceImplementationClass() {
        return this._serviceImplementationClass;
    }

    public final void setServiceImplementationClass(String serviceImplemenationClass) {
        this._serviceImplementationClass = serviceImplemenationClass;
    }

    public final boolean supportsAction(int desiredActions) {
        return (this._supportedActions & desiredActions) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[] getDependentServiceInterfaces() {
        String[] dependentServiceInterfaces = null;
        ServiceProfile serviceProfile = this;
        synchronized (serviceProfile) {
            int numItems = this._dependentServiceInterfaces.length;
            dependentServiceInterfaces = new String[numItems];
            if (numItems > 0) {
                System.arraycopy(this._dependentServiceInterfaces, 0, dependentServiceInterfaces, 0, numItems);
            }
        }
        return dependentServiceInterfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setDependentServiceInterfaces(String[] dependentServiceInterfaces) {
        ServiceProfile serviceProfile = this;
        synchronized (serviceProfile) {
            int numItems = dependentServiceInterfaces == null ? 0 : dependentServiceInterfaces.length;
            this._dependentServiceInterfaces = new String[numItems];
            if (numItems > 0) {
                System.arraycopy(dependentServiceInterfaces, 0, this._dependentServiceInterfaces, 0, numItems);
            }
        }
    }

    public final void setServiceComponentConfiguration(ServiceComponentConfigInterface serviceComponentConfiguration) {
        this._serviceComponentConfiguration = serviceComponentConfiguration;
    }

    public ServiceComponentConfigInterface getServiceComponentConfiguration() {
        return this._serviceComponentConfiguration;
    }

    public AbstractServiceComponentConfig createServiceComponentConfig(String configName, Document document) throws ServiceException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceConfigDocument getServiceConfigDocument(Property property) throws ServiceException {
        ServiceConfigDocument serviceConfigDocument;
        block9: {
            serviceConfigDocument = null;
            if (property != null) {
                Throwable exception = null;
                try {
                    TextStore textStore = (TextStore)property.getStoredConfiguration();
                    if (textStore != null && "".equals((serviceConfigDocument = ServiceProfile.createServiceConfigDocument(property.getName(), textStore.getStoredText())).getConfigName()) && AbstractServiceComponentConfig.isBaseConfig(property)) {
                        serviceConfigDocument.setConfigName(RB.getStringResource("AbstractServiceComponentConfig.baseConfig.txt"));
                    }
                }
                catch (MdException e) {
                    exception = e;
                    return exception;
                }
                catch (RemoteException e) {
                    exception = e;
                    return exception;
                }
                finally {
                    if (exception == null) break block9;
                    throw new ServiceException(exception, RB.getStringResource("AbstractServiceFactory.createServiceConfig.ex.txt"));
                }
            }
        }
        return serviceConfigDocument;
    }

    private static final ServiceConfigDocument createServiceConfigDocument(String configName, String xml) {
        return new ServiceConfigDocument(configName, xml != null && xml.trim().length() > 0 ? XMLUtil.convertStringToDocument(xml) : null);
    }

    public AbstractServiceComponentConfig createServiceConfigForProperty(Property property) throws ServiceException {
        AbstractServiceComponentConfig serviceConfig = null;
        if (property != null) {
            serviceConfig = this.createServiceConfig(ServiceProfile.getServiceConfigDocument(property));
        }
        return serviceConfig;
    }

    public AbstractServiceComponentConfig createServiceConfig(ServiceConfigDocument serviceConfigDocument) throws ServiceException {
        AbstractServiceComponentConfig serviceConfig = null;
        if (serviceConfigDocument != null) {
            Document document = serviceConfigDocument.getDocument();
            serviceConfig = document == null ? this.getDefaultServiceConfig(serviceConfigDocument.getConfigName()) : this.createServiceComponentConfig(serviceConfigDocument.getConfigName(), document);
        }
        return serviceConfig;
    }

    public Property createServiceConfigProperty(ServiceComponent serviceComponent, String configName, String configDesc, Document configDocument, boolean isApplicationConfig) throws ServiceException {
        Property property = null;
        try {
            MdObjectStore mdObjectStore = (MdObjectStore)serviceComponent.getObjectStore();
            MdStore parentStore = mdObjectStore.getOwningStore();
            String reposID = serviceComponent.getRepositoryID();
            MdFactory mdFactory = mdObjectStore.getFactory();
            property = (Property)mdFactory.createComplexMetadataObject(mdObjectStore, parentStore, "Initialization Data", "Property", reposID, null);
            property.setPropertyName("INIT_DATA");
            property.setIsUpdateable(this.isServiceConfigurationUpdateable() ? 1 : 0);
            PropertyType propertyType = (PropertyType)mdFactory.createComplexMetadataObject(mdObjectStore, parentStore, "String", "PropertyType", reposID, null);
            propertyType.setSQLType(12);
            property.setOwningType(propertyType);
            property.setName(configName);
            property.setDesc(configDesc);
            property.setPropertyRole(isApplicationConfig ? CONFIGURATIONTYPE_APPLICATION : CONFIGURATIONTYPE_BASE);
            TextStore textStore = (TextStore)mdFactory.createComplexMetadataObject(mdObjectStore, parentStore, "Initialization Data", "TextStore", reposID, null);
            textStore.setTextRole("initialization");
            property.setStoredConfiguration((Text)textStore);
            serviceComponent.getProperties().add((Object)property);
            AbstractServiceComponentConfig newConfig = this.createNewConfig(new ServiceAggregateConfig(serviceComponent), configName, configDocument);
            if (newConfig != null) {
                textStore.setStoredText(newConfig.toXMLString());
            }
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
        catch (RemoteException e) {
            throw new ServiceException(e);
        }
        return property;
    }

    public Property createServiceConfigProperty(ServiceComponent serviceComponent, String configName, String configDesc, Document configDocument) throws ServiceException {
        AbstractServiceComponentConfig newConfig = this.createNewConfig(new ServiceAggregateConfig(serviceComponent), configName, configDocument);
        Property property = null;
        try {
            MdObjectStore mdObjectStore = (MdObjectStore)serviceComponent.getObjectStore();
            String reposID = serviceComponent.getFQID().substring(0, 8);
            MdFactory mdFactory = mdObjectStore.getFactory();
            property = (Property)mdFactory.createComplexMetadataObject(mdObjectStore, null, "Initialization Data", "Property", reposID, null);
            property.setPropertyName("INIT_DATA");
            property.setIsUpdateable(this.isServiceConfigurationUpdateable() ? 1 : 0);
            PropertyType propertyType = (PropertyType)mdFactory.createComplexMetadataObject(mdObjectStore, null, "String", "PropertyType", reposID, null);
            propertyType.setSQLType(12);
            property.setOwningType(propertyType);
            property.setName(configName);
            property.setDesc(configDesc);
            TextStore textStore = (TextStore)mdFactory.createComplexMetadataObject(mdObjectStore, null, "Initialization Data", "TextStore", reposID, null);
            textStore.setTextRole("initialization");
            if (newConfig != null) {
                textStore.setStoredText(newConfig.toXMLString());
            }
            property.setStoredConfiguration((Text)textStore);
            property.setAssociatedObject((Root)serviceComponent);
        }
        catch (RemoteException e) {
            throw new ServiceException(e, RB.getStringResource("AbstractServiceFactory.createProperty.ex.txt"));
        }
        return property;
    }

    public AbstractServiceComponentConfig getDefaultServiceConfig(String configName) throws ServiceException {
        return this._serviceComponentConfiguration instanceof AbstractServiceComponentConfig ? (AbstractServiceComponentConfig)this._serviceComponentConfiguration : null;
    }

    public String getDefaultServiceConfigFilename() {
        return Message.format((ResourceBundle)RB.getResources(), (String)"ServiceProfile.defaultConfigFilename.fmt.txt", (Object)this.getDefaultFilename());
    }

    protected String getDefaultFilename() {
        return "";
    }

    public AbstractServiceComponentConfig createConfig(String configName, Document document) throws ServiceException {
        return this.createServiceComponentConfig(configName, document);
    }

    private AbstractServiceComponentConfig createNewConfig(ServiceAggregateConfig serviceAggConfig, String configName, Document configDocument) throws ServiceException, IllegalArgumentException {
        AbstractServiceComponentConfig defaultConfig;
        AbstractServiceComponentConfig newConfig = null;
        Document document = configDocument;
        if (configDocument == null && (defaultConfig = this.getDefaultServiceConfig(RB.getStringResource("AbstractServiceFactory.defaultConfigName.txt"))) != null) {
            document = defaultConfig.getDocument();
        }
        if (document != null) {
            AbstractServiceComponentConfig serviceConfig = serviceAggConfig.getAggregateServiceConfig();
            newConfig = this.createConfig(configName, document);
            serviceConfig.mergeConfiguration(newConfig);
        }
        return newConfig;
    }

    public final Document createDocument(ServiceComponent serviceComponent) throws ServiceException {
        return this._serviceComponentConfiguration == null ? null : this._serviceComponentConfiguration.createDocument(serviceComponent);
    }

    private final boolean isServiceConfigurationUpdateable() {
        return this._serviceComponentConfiguration == null ? false : this._serviceComponentConfiguration.isConfigurationUpdateable();
    }

    public String getConfigUserInterfaceClassName() {
        return this._configUserInterfaceClassName;
    }

    public final void setConfigUserInterfaceClassName(String configUserInterfaceClassName) {
        this._configUserInterfaceClassName = configUserInterfaceClassName;
    }

    public ExportServiceConfigInterface getServiceConfigExporter() {
        return this;
    }

    public MergeServiceConfigInterface getServiceConfigMerger() {
        return this;
    }

    @Override
    public void exportServiceConfig(File file, ServiceAggregateConfig serviceAggregateConfig, boolean isExportingBaseConfig, List<String> consumerNames) throws ServiceException {
        try {
            AbstractServiceComponentConfig origConfig = serviceAggregateConfig.getServiceConfig();
            if (null != origConfig) {
                AbstractServiceComponentConfig exportConfig = (AbstractServiceComponentConfig)origConfig.clone();
                for (Consumer consumer : exportConfig.getConsumerUsage().getConsumers()) {
                    if (consumerNames.contains(consumer.getName())) continue;
                    exportConfig.removeConsumer(consumer, true);
                }
                exportConfig.writeServiceConfigToFile(file);
            }
        }
        catch (CloneNotSupportedException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public void mergeServiceConfig(File file, ServiceDeployment serviceDeployment, ServiceComponent serviceComponent, Property applicationConfigProperty) throws ServiceException {
        serviceDeployment.mergeServiceConfiguration(file, serviceComponent, applicationConfigProperty);
    }

    public String getServiceDisplayName() {
        return RB.getStringResource("ServiceProfile.serviceName.txt");
    }

    public String getServiceDisplayDescription() {
        return RB.getStringResource("ServiceProfile.serviceDesc.txt");
    }

    public String getBeanIdForService(CMetadata cMetadata) throws MdException {
        String id = null;
        try {
            id = this.getServiceImplementationClass() + '_' + cMetadata.getFQID();
        }
        catch (RemoteException e) {
            throw new MdException((Throwable)e);
        }
        return id;
    }

    public boolean isSingletonService() {
        return this._isSingletonService;
    }

    public boolean isDeprecated() {
        return this._isDeprecated;
    }

    public void setDeprecated(boolean isDeprecated) {
        this._isDeprecated = isDeprecated;
    }
}

