/*
 * Decompiled with CFR 0.152.
 */
package com.sas.app;

import com.sas.app.SDSImageServerConnection;
import com.sas.app.SDSTraversalPath;
import com.sas.app.Util;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.List;

class SDSImageServerPath
implements SDSTraversalPath {
    private static final int NUM_CONNECTIONS = 1;
    private final List m_parents = new ArrayList();
    private LocData m_current;
    private SDSImageServerConnection[] m_connections;
    private int m_indexNextConnection;

    SDSImageServerPath(String path) {
        SDSImageServerConnection.validatePath(path);
        this.m_current = new LocData(path);
    }

    @Override
    public void push(String name) {
        SDSImageServerConnection.validateSimpleName(name);
        this.m_parents.add(this.m_current);
        this.m_current = new LocData(this.m_current, name);
    }

    @Override
    public void pop() throws EmptyStackException {
        int n = this.m_parents.size();
        if (n <= 0) {
            throw new EmptyStackException();
        }
        this.m_current = (LocData)this.m_parents.remove(n - 1);
    }

    @Override
    public int relativeDepth() {
        return this.m_parents.size();
    }

    @Override
    public String getPath() {
        return this.m_current.getPath();
    }

    @Override
    public String getRelPath() {
        String path;
        int n = this.m_parents.size();
        if (n <= 0) {
            return "/";
        }
        String base = ((LocData)this.m_parents.get(0)).m_locPath;
        if (!base.endsWith("/")) {
            base = base + "/";
        }
        if (!(path = this.m_current.m_locPath).startsWith(base)) {
            assert (false);
            throw new IllegalStateException();
        }
        return path.substring(base.length());
    }

    @Override
    public void close() {
        SDSImageServerConnection[] conn = this.m_connections;
        this.m_connections = null;
        if (conn == null) {
            return;
        }
        for (int i = 0; i < conn.length; ++i) {
            SDSImageServerConnection c = conn[i];
            if (c == null) continue;
            c.close();
        }
    }

    private SDSImageServerConnection getConnection() throws IOException {
        SDSImageServerConnection[] conn = this.m_connections;
        if (conn == null) {
            conn = new SDSImageServerConnection[1];
            for (int i = 0; i < conn.length; ++i) {
                conn[i] = SDSImageServerConnection.connect();
            }
            this.m_connections = conn;
        }
        SDSImageServerConnection rc = conn[this.m_indexNextConnection];
        if (++this.m_indexNextConnection >= this.m_connections.length) {
            this.m_indexNextConnection = 0;
        }
        return rc;
    }

    @Override
    public String[] list() {
        return this.m_current.list();
    }

    @Override
    public boolean isDirectory() {
        return this.m_current.isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.m_current.isFile();
    }

    @Override
    public boolean exists() {
        return this.m_current.exists();
    }

    @Override
    public long lastModified() {
        return this.m_current.lastModified();
    }

    @Override
    public long length() {
        return this.m_current.length();
    }

    @Override
    public InputStream openSource() throws IOException {
        return this.m_current.openSource();
    }

    private class LocData {
        private final String m_locPath;
        private SDSImageServerConnection.Reply m_data;

        LocData(String path) {
            SDSImageServerConnection.validatePath(path);
            if (path.length() > 1 && path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            this.m_locPath = path;
        }

        LocData(LocData parent, String name) {
            if (parent == null) {
                throw Util.illegalNull("parent");
            }
            SDSImageServerConnection.validateSimpleName(name);
            String p = parent.m_locPath;
            String usePath = p.equals("/") ? "/" + name : p + "/" + name;
            SDSImageServerConnection.validatePath(usePath);
            this.m_locPath = usePath;
        }

        private SDSImageServerConnection.Reply refresh() {
            try {
                SDSImageServerConnection.Reply rc;
                SDSImageServerConnection conn = SDSImageServerPath.this.getConnection();
                this.m_data = rc = conn.list(this.m_locPath);
                return rc;
            }
            catch (IOException e) {
                return null;
            }
        }

        private SDSImageServerConnection.Reply getData() {
            SDSImageServerConnection.Reply rc = this.m_data;
            if (rc == null) {
                rc = this.refresh();
            }
            return rc;
        }

        public String getPath() {
            return this.m_locPath;
        }

        public boolean isDirectory() {
            SDSImageServerConnection.Reply data = this.getData();
            return data != null ? data.isDirectory() : false;
        }

        public boolean isFile() {
            SDSImageServerConnection.Reply data = this.getData();
            return data != null ? data.isFile() : false;
        }

        public boolean exists() {
            SDSImageServerConnection.Reply data = this.getData();
            return data != null ? data.exists() : false;
        }

        public long lastModified() {
            SDSImageServerConnection.Reply data = this.getData();
            return data != null ? data.lastModified() : 0L;
        }

        public long length() {
            SDSImageServerConnection.Reply data = this.getData();
            return data != null ? data.length() : 0L;
        }

        public String[] list() {
            SDSImageServerConnection.Reply data = this.getData();
            return data != null ? data.list() : null;
        }

        public InputStream openSource() throws IOException {
            SDSImageServerConnection.Reply data = this.m_data;
            if (data != null && !data.isFile()) {
                throw new FileNotFoundException();
            }
            SDSImageServerConnection conn = SDSImageServerPath.this.getConnection();
            data = conn.get(this.m_locPath);
            InputStream rc = data.getStream();
            if (rc == null) {
                throw new IOException();
            }
            return rc;
        }
    }
}

