/*
 * Decompiled with CFR 0.152.
 */
package com.sas.app;

import com.sas.app.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

final class MainAttrParser {
    static final String BUNDLE_CLASSPATH = "Bundle-ClassPath";
    static final String REQUIRE_BUNDLE = "Require-Bundle";
    static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    static final String BUNDLE_NAME = "Bundle-Name";
    static final String BUNDLE_VERSION = "Bundle-Version";
    static final String FRAGMENT_HOST = "Fragment-Host";
    static final String BUNDLE_NATIVE_CODE = "Bundle-NativeCode";
    static final String SAS_CYCLE_REQUIRE_BUNDLE = "SAS-Cycle-Require-Bundle";
    static final String TAINTED = "Tainted";
    private final String[] m_lowerKeys;
    private final Pattern m_pattern;
    private final String m_singlePattern;
    private Attributes.Name[] m_fallbackKeys;

    public MainAttrParser(String[] soughtKeys) throws IllegalArgumentException {
        if (soughtKeys == null) {
            throw Util.illegalNull("soughtKeys");
        }
        if (soughtKeys.length <= 0) {
            throw Util.illegalArgument("soughtKeys", soughtKeys);
        }
        String[] lowerKeys = new String[soughtKeys.length];
        HashSet<String> lower = new HashSet<String>();
        for (int i = 0; i < soughtKeys.length; ++i) {
            String s = soughtKeys[i];
            if (s == null) {
                throw Util.illegalNull("soughtKeys[" + i + ']');
            }
            if (!lower.add(s = s.toLowerCase(Locale.US))) {
                throw new IllegalArgumentException(Util.format("MainAttrParser.soughtKey.dup.ex.fmt.txt", s));
            }
            lowerKeys[i] = s;
        }
        if (lowerKeys.length > 1) {
            StringBuffer b = new StringBuffer();
            b.append("^(?:");
            for (int i = 0; i < lowerKeys.length; ++i) {
                if (i > 0) {
                    b.append('|');
                }
                b.append('(').append(lowerKeys[i]).append(')');
            }
            b.append("): ");
            this.m_pattern = Pattern.compile(b.toString(), 2);
            this.m_singlePattern = null;
        } else {
            this.m_pattern = null;
            this.m_singlePattern = lowerKeys[0] + ": ";
        }
        this.m_lowerKeys = lowerKeys;
    }

    public String[] getKeys() {
        return (String[])this.m_lowerKeys.clone();
    }

    public String[] parseValues(InputStream s) throws IOException, IllegalArgumentException {
        if (s == null) {
            throw Util.illegalNull("s");
        }
        return this.parseValues(new BufferedReader(new InputStreamReader(s, Util.UTF8)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] parseValues(BufferedReader r) throws IOException {
        Matcher matcher;
        if (r == null) {
            throw Util.illegalNull("r");
        }
        String[] rc = new String[this.m_lowerKeys.length];
        int remaining = rc.length;
        String nextLine = null;
        Matcher matcher2 = matcher = this.m_pattern != null ? this.m_pattern.matcher("") : null;
        while (true) {
            String value;
            String line;
            if (nextLine != null) {
                line = nextLine;
                nextLine = null;
            } else {
                line = r.readLine();
                if (line == null) return rc;
            }
            int lineLen = line.length();
            if (lineLen <= 0) return rc;
            int whichKey = -1;
            if (this.m_singlePattern != null) {
                if (lineLen <= this.m_singlePattern.length() || !line.regionMatches(true, 0, this.m_singlePattern, 0, this.m_singlePattern.length())) continue;
                value = line.substring(this.m_singlePattern.length());
                whichKey = 0;
            } else {
                matcher.reset(line);
                if (!matcher.lookingAt()) continue;
                for (int i = 0; i < rc.length; ++i) {
                    if (matcher.start(i + 1) < 0) continue;
                    whichKey = i;
                    break;
                }
                if (whichKey < 0) continue;
                value = line.substring(matcher.end());
            }
            StringBuffer continuedValue = null;
            while ((nextLine = r.readLine()) != null && nextLine.length() > 0 && nextLine.charAt(0) == ' ') {
                if (continuedValue == null) {
                    continuedValue = new StringBuffer(value);
                }
                continuedValue.append(nextLine.substring(1));
            }
            if (continuedValue != null) {
                value = continuedValue.toString();
            }
            if (rc[whichKey] == null) {
                --remaining;
            }
            rc[whichKey] = value;
            if (remaining <= 0 || nextLine == null) return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] parseValues(File file) throws IllegalArgumentException {
        String[] stringArray;
        if (file == null) {
            throw Util.illegalNull("file");
        }
        FileInputStream s = null;
        try {
            s = new FileInputStream(file);
            stringArray = this.parseValues(new BufferedReader(new InputStreamReader((InputStream)s, Util.UTF8)));
        }
        catch (IOException iOException) {
            Util.close(s);
            return new String[this.m_lowerKeys.length];
        }
        catch (Throwable throwable) {
            Util.close(s);
            throw throwable;
        }
        Util.close(s);
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String[] parseValuesFromJar(File jar, boolean allowFallback) throws IllegalArgumentException {
        ZipInputStream zis;
        FileInputStream s;
        block14: {
            String[] stringArray2;
            if (jar == null) {
                throw Util.illegalNull("jar");
            }
            s = null;
            zis = null;
            try {
                s = new FileInputStream(jar);
                zis = new ZipInputStream(s);
                ZipEntry entry = zis.getNextEntry();
                while (entry != null && entry.isDirectory()) {
                    entry = zis.getNextEntry();
                }
                if (entry == null) break block14;
                String entryName = entry.getName();
                if (entryName.startsWith("./")) {
                    entryName = entryName.substring(2);
                } else if (entryName.startsWith("/")) {
                    entryName = entryName.substring(1);
                }
                if (!"META-INF/MANIFEST.MF".equalsIgnoreCase(entryName)) break block14;
                stringArray2 = this.parseValues(zis);
            }
            catch (IOException entry) {
                Util.close(zis);
                zis = null;
                Util.close(s);
                s = null;
                catch (Throwable throwable) {
                    Util.close(zis);
                    zis = null;
                    Util.close(s);
                    s = null;
                    throw throwable;
                }
            }
            Util.close(zis);
            zis = null;
            Util.close(s);
            s = null;
            return stringArray2;
        }
        Util.close(zis);
        zis = null;
        Util.close(s);
        s = null;
        if (allowFallback) {
            String[] stringArray;
            JarFile j = null;
            try {
                j = new JarFile(jar, true);
                stringArray = this.fallback(j);
            }
            catch (IOException iOException) {
                Util.close(j);
                catch (Throwable throwable) {
                    Util.close(j);
                    throw throwable;
                }
            }
            Util.close(j);
            return stringArray;
        }
        return new String[this.m_lowerKeys.length];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] fallback(JarFile jf) throws IllegalArgumentException, IOException {
        Attributes.Name[] fallbackKeys;
        if (jf == null) {
            throw Util.illegalNull("jf");
        }
        String[] rc = new String[this.m_lowerKeys.length];
        Manifest mf = jf.getManifest();
        if (mf == null) {
            return rc;
        }
        Attributes attr = mf.getMainAttributes();
        MainAttrParser mainAttrParser = this;
        synchronized (mainAttrParser) {
            fallbackKeys = this.m_fallbackKeys;
            if (fallbackKeys == null) {
                fallbackKeys = new Attributes.Name[rc.length];
                for (int i = 0; i < rc.length; ++i) {
                    fallbackKeys[i] = new Attributes.Name(this.m_lowerKeys[i]);
                }
            }
            this.m_fallbackKeys = fallbackKeys;
        }
        for (int i = 0; i < rc.length; ++i) {
            rc[i] = attr.getValue(fallbackKeys[i]);
        }
        return rc;
    }
}

