/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.springframework.config;

import com.sas.svcs.authorization.acl.client.AceCreatingInterceptor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.aop.config.AopNamespaceUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class AceLifecycleBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final Logger logger = LogManager.getLogger(AceLifecycleBeanDefinitionParser.class);
    static final String ACE_CREATOR_ID = "sas.svcs.security.aceCreator";
    static final String ACL_SERVICE_ID = "aclService";
    static final String ATT_ACL_REF = "acl-service-ref";
    static final String ATT_EXPRESSION_HANDLER_REF = "expression-handler-ref";

    private static void registerAceCreator(BeanDefinitionRegistry registry, String aclServiceId, String expressionHandlerId) {
        if (!registry.containsBeanDefinition(ACE_CREATOR_ID)) {
            if (logger.isInfoEnabled()) {
                logger.info("Creating new sas.svcs.security.aceCreator bean");
            }
            if (!StringUtils.hasText((String)aclServiceId)) {
                aclServiceId = ACL_SERVICE_ID;
            } else if (logger.isInfoEnabled()) {
                logger.info("Using bean " + aclServiceId + " as aclService");
            }
            if (!StringUtils.hasText((String)expressionHandlerId)) {
                expressionHandlerId = "sas.svcs.security.expressionHandler";
            } else if (logger.isInfoEnabled()) {
                logger.info("Using bean " + expressionHandlerId + " as expressionHandler");
            }
            BeanDefinitionBuilder aceCreatorBuilder = BeanDefinitionBuilder.rootBeanDefinition(AceCreatingInterceptor.class);
            aceCreatorBuilder.addPropertyReference(ACL_SERVICE_ID, aclServiceId);
            aceCreatorBuilder.addPropertyReference("expressionHandler", expressionHandlerId);
            registry.registerBeanDefinition(ACE_CREATOR_ID, (BeanDefinition)aceCreatorBuilder.getBeanDefinition());
        } else if (logger.isInfoEnabled()) {
            logger.info("Using pre-defined sas.svcs.security.aceCreator bean");
        }
    }

    private static void registerAceAspectjAdvisor(ParserContext parserContext) {
        BeanDefinitionBuilder advisorBuilder = BeanDefinitionBuilder.rootBeanDefinition(AspectJExpressionPointcutAdvisor.class);
        advisorBuilder.addPropertyValue("expression", (Object)"@annotation(com.sas.svcs.authorization.acl.client.CreateAccessControl)");
        advisorBuilder.addPropertyReference("advice", ACE_CREATOR_ID);
        AbstractBeanDefinition advisor = advisorBuilder.getBeanDefinition();
        String beanName = parserContext.getReaderContext().generateBeanName((BeanDefinition)advisor);
        parserContext.getRegistry().registerBeanDefinition(beanName, (BeanDefinition)advisor);
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        String aclServiceId = element.getAttribute(ATT_ACL_REF);
        String expressionHandlerId = element.getAttribute(ATT_EXPRESSION_HANDLER_REF);
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        AceLifecycleBeanDefinitionParser.registerAceCreator(registry, aclServiceId, expressionHandlerId);
        AceLifecycleBeanDefinitionParser.registerAceAspectjAdvisor(parserContext);
        AopNamespaceUtils.registerAspectJAutoProxyCreatorIfNecessary((ParserContext)parserContext, (Element)element);
        return null;
    }
}

