/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.authorization.client;

import com.sas.svcs.authorization.client.AuthorityType;
import com.sas.svcs.authorization.client.AuthorizationPrincipal;
import com.sas.svcs.authorization.client.TypedGrantedAuthority;
import org.springframework.security.acls.domain.GrantedAuthoritySid;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;

public final class GroupGrantedAuthority
extends TypedGrantedAuthority
implements GrantedAuthority {
    private static final long serialVersionUID = 1L;
    private static final String _groupAuthorityPrefix = "GROUP_";
    private final String _groupName;

    public GroupGrantedAuthority(String groupName) {
        super(_groupAuthorityPrefix + groupName, AuthorityType.GROUP);
        Assert.hasText((String)groupName, (String)"A granted authority textual representation is required");
        this._groupName = groupName;
    }

    public GroupGrantedAuthority(GrantedAuthoritySid sid) {
        super(sid.getGrantedAuthority(), AuthorityType.GROUP);
        if (!this.getAuthority().startsWith(_groupAuthorityPrefix)) {
            throw new IllegalArgumentException("GrantedAuthoritySid does not represent a group");
        }
        this._groupName = this.authority.substring(_groupAuthorityPrefix.length());
    }

    public GroupGrantedAuthority(AuthorizationPrincipal principal) {
        super(_groupAuthorityPrefix + principal.getName(), AuthorityType.GROUP);
        AuthorizationPrincipal.PrincipalType type = principal.getType();
        if (!AuthorizationPrincipal.PrincipalType.Group.equals((Object)type)) {
            throw new IllegalArgumentException("AuthorizationPrincipal does not represent a group");
        }
        this._groupName = principal.getName();
    }

    public String getGroupName() {
        return this._groupName;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || !(that instanceof GroupGrantedAuthority)) {
            return false;
        }
        return this._groupName.equals(((GroupGrantedAuthority)that).getGroupName());
    }

    @Override
    public int hashCode() {
        int hc = this.getClass().hashCode();
        return hc ^= this._groupName.hashCode();
    }

    @Override
    public String toString() {
        return this.getAuthority();
    }
}

