/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.authorization.client;

import java.io.Serializable;
import java.security.Principal;

public class AuthorizationPrincipal
implements Principal,
Serializable {
    public static final String AUTHENTICATED_USERS_GROUP = "SAS_AUTHENTICATED_USERS";
    private static final long serialVersionUID = 1L;
    private String _name;
    private PrincipalType _type;

    public AuthorizationPrincipal() {
    }

    public AuthorizationPrincipal(String name) {
        this(name, PrincipalType.User);
    }

    public AuthorizationPrincipal(String name, PrincipalType type) {
        this._name = name.toString();
        if (type == null) {
            throw new NullPointerException("Authorization principal type cannot be null");
        }
        this._type = type;
    }

    public PrincipalType getType() {
        return this._type;
    }

    @Override
    public final String getName() {
        return this._name;
    }

    @Override
    public int hashCode() {
        int hc = this.getClass().getName().hashCode();
        hc ^= this._name.hashCode();
        return hc ^= this._type.hashCode();
    }

    @Override
    public boolean equals(Object that) {
        Class<?> thatClass;
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        Class<?> thisClass = this.getClass();
        if (!thisClass.isAssignableFrom(thatClass = that.getClass()) || !thatClass.isAssignableFrom(thisClass)) {
            return false;
        }
        AuthorizationPrincipal thatPrin = (AuthorizationPrincipal)that;
        if (!this._name.equals(thatPrin.getName())) {
            return false;
        }
        return this._type.equals((Object)thatPrin.getType());
    }

    @Override
    public final String toString() {
        return this.getName();
    }

    public static enum PrincipalType {
        User,
        Group;

    }
}

