/*
 * Decompiled with CFR 0.152.
 */
package com.esri.arcgis.geoprocessing.gen.params;

import com.esri.arcgis.geodatabase.IGPValue;
import com.esri.arcgis.geoprocessing.GPParameter;
import com.esri.arcgis.geoprocessing.gen.GPImporter;
import com.esri.arcgis.geoprocessing.gen.GenMethod;
import com.esri.arcgis.geoprocessing.gen.GenUtil;
import com.esri.arcgis.geoprocessing.gen.params.GPParamImporter;
import com.esri.arcgis.geoprocessing.gen.params.GPParamUtils;

public class GPDoubleImporter
implements GPParamImporter {
    public String getDataTypeName() {
        return "GPDouble";
    }

    public void createDefaultConstructorStatement(GPImporter gPImporter, GenMethod genMethod, GPParameter gPParameter, int n2) throws Exception {
        if (gPParameter.getParameterType() == 2) {
            return;
        }
        IGPValue iGPValue = gPParameter.getValue();
        if (iGPValue == null) {
            return;
        }
        String string = iGPValue.getAsText();
        if (string != null && !"".equals(string.trim())) {
            string = string.trim();
            genMethod.statements.add("vals[" + n2 + "] = new Double(" + string + ")" + ";" + " //" + gPParameter.getName());
        }
    }

    public void createRequiredParamsConstructorArgsAndStatement(GPImporter gPImporter, GenMethod genMethod, GPParameter gPParameter, int n2) throws Exception {
        if (gPParameter.getParameterType() != 0) {
            return;
        }
        String string = "double";
        String string2 = gPParameter.getName();
        String string3 = GenUtil.firstToLowerCase(GenUtil.removeSpecialChars(string2, GPImporter.removeChars));
        genMethod.params.put(string3, "double");
        genMethod.comments.add("@param " + string3 + " " + GPParamUtils.getParameterComment(gPImporter, gPParameter));
        genMethod.statements.add("vals[" + n2 + "] = new Double(" + string3 + ")" + ";" + " //" + string2);
    }

    public void createMethods(GPImporter gPImporter, GPParameter gPParameter, int n2) throws Exception {
        String string = "double";
        String string2 = gPParameter.getName();
        GenMethod genMethod = GPParamUtils.createGetterMethodTemplate(gPImporter, gPParameter, "double");
        genMethod.statements.add("return vals[" + n2 + "] == null ? 0D : " + "((Double)" + "vals" + "[" + n2 + "]).doubleValue()" + ";");
        gPImporter.gclass.methods.add(genMethod);
        if (gPParameter.getParameterType() == 2) {
            return;
        }
        GenMethod genMethod2 = GPParamUtils.createSetterMethodTemplate(gPImporter, gPParameter, "double");
        genMethod2.statements.add("vals[" + n2 + "] = new Double(" + GenUtil.firstToLowerCase(GenUtil.removeSpecialChars(string2, GPImporter.removeChars)) + ")" + ";");
        gPImporter.gclass.methods.add(genMethod2);
    }
}

