/*
 * Decompiled with CFR 0.152.
 */
package com.esri.arcgis.geoprocessing.gen;

import com.esri.arcgis.datasourcesGDB.AccessWorkspaceFactory;
import com.esri.arcgis.datasourcesGDB.FileGDBWorkspaceFactory;
import com.esri.arcgis.datasourcesGDB.SdeWorkspaceFactory;
import com.esri.arcgis.geodatabase.IMetadataProxy;
import com.esri.arcgis.geodatabase.IXmlPropertySet2Proxy;
import com.esri.arcgis.geodatabase.XmlPropertySet;
import com.esri.arcgis.geoprocessing.GPParameter;
import com.esri.arcgis.geoprocessing.IGPFunction;
import com.esri.arcgis.geoprocessing.IGPFunctionToolProxy;
import com.esri.arcgis.geoprocessing.IGPTool;
import com.esri.arcgis.geoprocessing.IToolboxWorkspaceProxy;
import com.esri.arcgis.geoprocessing.ToolboxWorkspaceFactory;
import com.esri.arcgis.geoprocessing.gen.GenClass;
import com.esri.arcgis.geoprocessing.gen.GenMethod;
import com.esri.arcgis.geoprocessing.gen.GenUtil;
import com.esri.arcgis.geoprocessing.gen.a;
import com.esri.arcgis.geoprocessing.gen.b;
import com.esri.arcgis.geoprocessing.gen.params.DefaultParamImporter;
import com.esri.arcgis.geoprocessing.gen.params.GPBooleanImporter;
import com.esri.arcgis.geoprocessing.gen.params.GPDoubleImporter;
import com.esri.arcgis.geoprocessing.gen.params.GPLongImporter;
import com.esri.arcgis.geoprocessing.gen.params.GPParamImporter;
import com.esri.arcgis.geoprocessing.gen.params.GPStringImporter;
import com.esri.arcgis.system.IArray;
import com.esri.arcgis.system.IPropertySet;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class GPImporter {
    private static final Logger a = Logger.getLogger((c == null ? (c = GPImporter.a("com.esri.arcgis.geoprocessing.gen.GPImporter")) : c).getName());
    public static final String tab = "\t";
    public static final String sc = ";";
    public static final String em = "";
    public static final String qt = "\"";
    public static final String prefix = "../../../../../../../../shared/geoprocessing/";
    public static final String valsVar = "vals";
    public static final char[] removeChars = new char[]{'_', '-', ' '};
    public static final GPParamImporter defaultParamImporter = new DefaultParamImporter();
    public static final HashMap paramImporters = new HashMap();
    public HashMap helpStrs;
    public GenClass gclass;
    public IGPTool tool;
    public IGPFunction func;
    public String toolName;
    public String toolboxName;
    public String toolboxAlias;
    private static String b;
    static /* synthetic */ Class c;
    static /* synthetic */ Class d;

    public static void addParamImporter(GPParamImporter gPParamImporter) {
        paramImporters.put(gPParamImporter.getDataTypeName(), gPParamImporter);
    }

    public GPImporter(String string, String string2) throws Exception {
        this(string, b, string2, System.getProperty("ARCENGINEHOME") + File.separator + "ArcToolbox" + File.separator + "Toolboxes", System.getProperty("ARCENGINEHOME") + File.separator + "Help" + File.separator + "gp");
    }

    public GPImporter(String string, String string2, String string3, String string4) throws Exception {
        this(string, null, string2, string3, string4);
    }

    public GPImporter(String string, String string2, String string3, String string4, String string5) throws Exception {
        block22: {
            block21: {
                Object object;
                int n2;
                block19: {
                    block20: {
                        block18: {
                            Serializable serializable;
                            n2 = GenMethod.a;
                            this.helpStrs = new HashMap();
                            this.toolName = string;
                            if (string2 != null) {
                                b = string2;
                            }
                            this.toolboxName = string3;
                            ToolboxWorkspaceFactory toolboxWorkspaceFactory = new ToolboxWorkspaceFactory();
                            IToolboxWorkspaceProxy iToolboxWorkspaceProxy = null;
                            if (string4.endsWith(".sde")) {
                                serializable = new SdeWorkspaceFactory();
                                object = ((SdeWorkspaceFactory)serializable).openFromFile(string4, 0);
                                iToolboxWorkspaceProxy = new IToolboxWorkspaceProxy(object);
                            } else if (string4.endsWith(".mdb")) {
                                serializable = new AccessWorkspaceFactory();
                                object = ((AccessWorkspaceFactory)serializable).openFromFile(string4, 0);
                                iToolboxWorkspaceProxy = new IToolboxWorkspaceProxy(object);
                            } else if (string4.endsWith(".gdb")) {
                                serializable = new FileGDBWorkspaceFactory();
                                object = ((FileGDBWorkspaceFactory)serializable).openFromFile(string4, 0);
                                iToolboxWorkspaceProxy = new IToolboxWorkspaceProxy(object);
                            } else {
                                serializable = new ToolboxWorkspaceFactory();
                                iToolboxWorkspaceProxy = new IToolboxWorkspaceProxy(serializable.openFromFile(string4, 0));
                            }
                            serializable = iToolboxWorkspaceProxy.openToolbox(string3);
                            this.toolboxAlias = serializable.getAlias();
                            this.tool = serializable.openTool(string);
                            try {
                                this.func = new IGPFunctionToolProxy(this.tool).getFunction();
                            }
                            catch (Exception exception) {
                                a.warning("IGPFunction for the tool " + string + " in the " + string3 + " is not found.");
                            }
                            object = null;
                            if (this.func != null) break block18;
                            object = string + "_" + this.toolboxAlias + ".xml";
                            break block19;
                        }
                        object = this.func.getMetadataFile();
                        if (object != null) break block20;
                        object = string + "_" + this.toolboxAlias + ".xml";
                        if (n2 == 0) break block19;
                    }
                    if (((String)object).endsWith("_raster.xml") || ((String)object).endsWith("_globe.xml")) {
                        a.warning("The returned metadata filename is invalid: " + (String)object + " suffix should be " + this.toolboxAlias);
                        object = string + "_" + this.toolboxAlias + ".xml";
                    }
                }
                object = string5 + File.separator + (String)object;
                if (!new File((String)object).exists()) break block21;
                this.a(DocumentBuilderFactory.newInstance().newDocumentBuilder().parse((String)object));
                if (n2 == 0) break block22;
            }
            IMetadataProxy iMetadataProxy = new IMetadataProxy(this.tool);
            IPropertySet iPropertySet = iMetadataProxy.getMetadata();
            XmlPropertySet xmlPropertySet = new XmlPropertySet(iPropertySet);
            String string6 = new IXmlPropertySet2Proxy(xmlPropertySet).getXml(null);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string6.getBytes());
            try {
                Document document = documentBuilder.parse(byteArrayInputStream);
                this.a(document);
            }
            catch (SAXParseException sAXParseException) {
                a.severe("There is no valid metadata for " + string + " from " + string3 + sAXParseException.getMessage());
            }
        }
    }

    public void start() throws Exception {
        this.a();
        this.e();
        this.b();
        this.c();
        this.d();
    }

    private void a() throws Exception {
        block18: {
            List list;
            int n2;
            block17: {
                String string;
                String string2;
                block16: {
                    String string3;
                    block15: {
                        char c2;
                        String string4;
                        n2 = GenMethod.a;
                        this.gclass = new GenClass();
                        this.gclass.name = GenUtil.removeSpaces(this.toolName);
                        if ("Con".equals(this.gclass.name)) {
                            this.gclass.name = "ConTool";
                        }
                        if ((string4 = GenUtil.removeSpaces(GenUtil.allLowerCase(this.toolboxName))).equals("3danalysttools")) {
                            string4 = "analyst3dtools";
                        }
                        if (Character.isDigit(c2 = string4.charAt(0))) {
                            string4 = "_" + string4;
                        }
                        this.gclass.packageName = b + "." + string4;
                        this.gclass.imports.add((d == null ? (d = GPImporter.a("com.esri.arcgis.geoprocessing.AbstractGPTool")) : d).getName());
                        this.gclass.extClass = "AbstractGPTool";
                        string3 = (String)this.helpStrs.get(this.toolName);
                        if (string3 != null) break block15;
                        a.warning("The summary section of the the metadatafile for " + this.gclass.name + " from " + this.toolboxName + " toolbox is not valid.");
                        if (n2 == 0) break block16;
                    }
                    this.gclass.comments.add(string3);
                }
                this.gclass.comments.add("The " + this.tool.getDisplayName() + " tool is contained in the " + this.toolboxName + " tool box.");
                b b2 = (b)this.helpStrs.get(this.toolName + "Httpref");
                if (b2 != null) {
                    this.gclass.comments.add("<br><a href=\"../../../../../../../../shared/geoprocessing/" + b2.ref + "\">" + b2.desc + "</a>");
                }
                if ((string2 = (String)this.helpStrs.get("softwarerestriction")) != null) {
                    this.gclass.comments.add("<p><b>Software restrictions: </b>" + string2 + "</p>");
                }
                if ((string = (String)this.helpStrs.get("toolIllust")) != null) {
                    this.gclass.comments.add("<h4>Illustration:</h4>");
                    this.gclass.comments.add("<div><img src=\"doc-files/" + string + "\"></div>");
                }
                if ((list = (List)this.helpStrs.get("usage")) != null && !list.isEmpty()) break block17;
                a.warning("The usage section of the the metadatafile for " + this.gclass.name + " from " + this.toolboxName + " toolbox is not valid.");
                if (n2 == 0) break block18;
            }
            this.gclass.comments.add("<h4>Usage tips:</h4>");
            this.gclass.comments.add("<ul>");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                block20: {
                    Object e2;
                    block19: {
                        e2 = iterator.next();
                        if (!(e2 instanceof String)) break block19;
                        this.gclass.comments.add("<li>" + e2);
                        if (n2 == 0) break block20;
                    }
                    if (e2 instanceof List) {
                        Iterator iterator2 = ((List)e2).iterator();
                        while (iterator2.hasNext()) {
                            Object e3 = iterator2.next();
                            this.gclass.comments.add((String)e3);
                            if (n2 == 0) continue;
                        }
                    }
                }
                if (n2 == 0) continue;
            }
            this.gclass.comments.add("</ul>");
        }
    }

    private String a(int n2) {
        switch (n2) {
            case 3: {
                return "Script";
            }
            case 2: {
                return "Model";
            }
            case 4: {
                return "Custom";
            }
        }
        return "Function";
    }

    private void b() throws Exception {
        GenMethod genMethod = new GenMethod();
        genMethod.name = "getToolName";
        genMethod.returnType = "String";
        genMethod.statements.add("return \"" + this.toolName + qt + sc);
        genMethod.comments.add("Returns the name of this tool.");
        genMethod.comments.add(em);
        genMethod.comments.add("@return\tthe tool name");
        this.gclass.methods.add(genMethod);
    }

    private void c() throws Exception {
        GenMethod genMethod = new GenMethod();
        genMethod.name = "getToolboxName";
        genMethod.returnType = "String";
        genMethod.statements.add("return \"" + this.toolboxName + qt + sc);
        genMethod.comments.add("Returns the name of the tool box containing this tool.");
        genMethod.comments.add(em);
        genMethod.comments.add("@return\tthe tool box name");
        this.gclass.methods.add(genMethod);
    }

    private void d() throws Exception {
        GenMethod genMethod = new GenMethod();
        genMethod.name = "getToolboxAlias";
        genMethod.returnType = "String";
        genMethod.statements.add("return \"" + this.toolboxAlias + qt + sc);
        genMethod.comments.add("Returns the alias of the tool box containing this tool.");
        genMethod.comments.add(em);
        genMethod.comments.add("@return\tthe tool box alias");
        this.gclass.methods.add(genMethod);
    }

    private void e() throws Exception {
        Object object;
        Object object2;
        int n2 = GenMethod.a;
        GenMethod genMethod = new GenMethod();
        genMethod.type = GenMethod.Type.constructor;
        genMethod.name = this.gclass.name;
        GenMethod genMethod2 = new GenMethod();
        genMethod2.type = GenMethod.Type.constructor;
        genMethod2.name = this.gclass.name;
        genMethod.comments.add("Creates the " + this.tool.getDisplayName() + " tool with defaults.");
        genMethod.comments.add("<p>");
        genMethod.comments.add("Initializes the array of tool parameters with the default values specified when the tool was created.");
        genMethod2.comments.add("Creates the " + this.tool.getDisplayName() + " tool with the required parameters.");
        genMethod2.comments.add("<p>");
        genMethod2.comments.add("Initializes the array of tool parameters with the values as specified for the required parameters and with the default values for the other parameters.");
        IArray iArray = this.tool.getParameterInfo();
        int n3 = iArray.getCount();
        genMethod.statements.add("vals = new Object[" + n3 + "];");
        genMethod2.statements.add("this();");
        GPParamImporter gPParamImporter = null;
        GPParameter gPParameter = null;
        for (int i2 = 0; i2 < n3; ++i2) {
            GPParamImporter gPParamImporter2;
            gPParamImporter = defaultParamImporter;
            gPParameter = new GPParameter(iArray.getElement(i2));
            object2 = gPParameter.getDataType();
            if (object2 != null && (gPParamImporter2 = (GPParamImporter)paramImporters.get(object = object2.getName())) != null) {
                gPParamImporter = gPParamImporter2;
            }
            gPParamImporter.createDefaultConstructorStatement(this, genMethod, gPParameter, i2);
            gPParamImporter.createRequiredParamsConstructorArgsAndStatement(this, genMethod2, gPParameter, i2);
            gPParamImporter.createMethods(this, gPParameter, i2);
            if (n2 == 0) continue;
        }
        this.gclass.constructors.add(genMethod);
        if (genMethod2.params.size() > 0) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            object = genMethod2.comments.iterator();
            while (object.hasNext()) {
                object2 = (String)object.next();
                if (object2 == null || !((String)object2).trim().startsWith("@")) continue;
                arrayList.add(object2);
                if (n2 == 0) continue;
            }
            genMethod2.comments.removeAll(arrayList);
            genMethod2.comments.addAll(arrayList);
            this.gclass.constructors.add(genMethod2);
        }
    }

    private Node a(Node node, short s2, String string) {
        int n2 = GenMethod.a;
        if (node.getNodeType() == s2 && node.getNodeName().equalsIgnoreCase(string)) {
            return node;
        }
        NodeList nodeList = node.getChildNodes();
        if (nodeList == null) {
            return null;
        }
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Node node2 = nodeList.item(i2);
            Node node3 = this.a(node2, s2, string);
            if (node3 == null) continue;
            return node3;
        }
        return null;
    }

    private void a(Document document) {
        int n2 = GenMethod.a;
        try {
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getChildNodes();
            Node node = null;
            NodeList nodeList2 = null;
            Node node2 = null;
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                node = nodeList.item(i2);
                if (node.getNodeType() != 1 || !node.getNodeName().equals("tool")) continue;
                node2 = node;
                break;
            }
            if (node2 == null) {
                return;
            }
            NodeList nodeList3 = node2.getChildNodes();
            for (int i3 = 0; i3 < nodeList3.getLength(); ++i3) {
                Object object;
                Object object2;
                Object object3;
                Node node3;
                int n3;
                NodeList nodeList4;
                Object object4;
                CharSequence charSequence;
                Object object5;
                Object object6;
                node = nodeList3.item(i3);
                if (node.getNodeType() == 1 && node.getNodeName().equals("softwarerestriction")) {
                    this.helpStrs.put("softwarerestriction", node.getFirstChild().getNodeValue().trim());
                    if (n2 == 0) continue;
                }
                if (node.getNodeType() == 1 && node.getNodeName().equals("summary")) {
                    nodeList2 = node.getChildNodes();
                    for (int i4 = 0; i4 < nodeList2.getLength(); ++i4) {
                        node = nodeList2.item(i4);
                        if (node.getNodeType() != 1 || !node.getNodeName().equals("para")) continue;
                        if (i4 == 1) {
                            this.helpStrs.put(this.toolName, node.getFirstChild().getNodeValue().trim());
                            if (n2 == 0) continue;
                        }
                        if ((object6 = this.a(node, (short)1, "link")) == null) continue;
                        object5 = object6.getAttributes().getNamedItem("src").getNodeValue();
                        charSequence = object6.getFirstChild().getNodeValue().trim();
                        this.helpStrs.put(this.toolName + "Httpref", new b((String)object5, (String)charSequence));
                        if (n2 == 0) continue;
                    }
                    if (n2 == 0) continue;
                }
                if (node.getNodeType() == 1 && node.getNodeName().equalsIgnoreCase("toolIllust")) {
                    if ((node = this.a(node, (short)1, "img")) == null) continue;
                    Node node4 = node.getAttributes().getNamedItem("src");
                    this.helpStrs.put("toolIllust", node4.getNodeValue());
                    if (n2 == 0) continue;
                }
                if (node.getNodeType() == 1 && node.getNodeName().equals("usage")) {
                    NodeList nodeList5 = node.getChildNodes();
                    object6 = new ArrayList();
                    for (int i5 = 0; i5 < nodeList5.getLength(); ++i5) {
                        node = nodeList5.item(i5);
                        charSequence = new StringBuffer();
                        if (node.getNodeType() != 1 || !node.getNodeName().equals("bullet_item")) continue;
                        object4 = node.getChildNodes();
                        for (int i6 = 0; i6 < object4.getLength(); ++i6) {
                            node = object4.item(i6);
                            if (node.getNodeType() != 1 || !node.getNodeName().equals("para")) continue;
                            nodeList4 = node.getChildNodes();
                            for (n3 = 0; n3 < nodeList4.getLength(); ++n3) {
                                CharSequence charSequence2;
                                node3 = nodeList4.item(n3);
                                if (node3.getNodeType() == 1 && (node3.getNodeName().equals("link") || node3.getNodeName().equals("special_link"))) {
                                    object3 = node3.getAttributes().getNamedItem("src").getNodeValue();
                                    charSequence2 = node3.getFirstChild().getNodeValue().trim();
                                    object2 = new b((String)object3, (String)charSequence2);
                                    ((StringBuffer)charSequence).append(" <a href=\"../../../../../../../../shared/geoprocessing/" + ((b)object2).ref + "\">" + ((b)object2).desc + "</a>; ");
                                    if (n2 == 0) continue;
                                }
                                if (node3.getNodeType() == 1 && node3.getNodeName().equals("img")) {
                                    object3 = node3.getAttributes().getNamedItem("src").getNodeValue();
                                    charSequence2 = node3.getAttributes().getNamedItem("alt").getNodeValue();
                                    object2 = new a((String)object3, (String)charSequence2);
                                    ((StringBuffer)charSequence).append("<div><img src=\"doc-files/" + ((a)object2).pict + "\"></div>");
                                    object6.add(object2);
                                    if (n2 == 0) continue;
                                }
                                if (node3.getNodeType() == 1 && node3.getNodeName().equals("code")) {
                                    object3 = this.a(node3, (short)1, "para");
                                    charSequence2 = new StringBuffer();
                                    object = new char[]{'.'};
                                    for (object2 = object3.getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
                                        if (object2.getNodeType() != 3) continue;
                                        String string = object2.getNodeValue();
                                        if (string.endsWith(",")) {
                                            ((StringBuffer)charSequence2).append(string + " ");
                                            if (n2 == 0) continue;
                                        }
                                        ((StringBuffer)charSequence2).append(GenUtil.removeSpecialChars(string, (char[])object) + "; ");
                                        if (n2 == 0) continue;
                                    }
                                    if (((StringBuffer)charSequence2).length() != 0) {
                                        ((StringBuffer)charSequence).append(((StringBuffer)charSequence2).toString());
                                    }
                                    if (n2 == 0) continue;
                                }
                                if (node3.getNodeType() != 3 || node3.getNodeValue().trim().length() == 0 || ",".equals(node3.getNodeValue().trim()) || ".".equals(node3.getNodeValue().trim())) continue;
                                ((StringBuffer)charSequence).append(node3.getNodeValue().trim());
                                if (n2 == 0) continue;
                            }
                            if (n2 == 0) continue;
                        }
                        object6.add(((StringBuffer)charSequence).toString());
                        if (n2 == 0) continue;
                    }
                    this.helpStrs.put("usage", object6);
                    if (n2 == 0) continue;
                }
                if (node.getNodeType() != 1 || !node.getNodeName().equals("parameters")) continue;
                NodeList nodeList6 = node.getChildNodes();
                for (int i7 = 0; i7 < nodeList6.getLength(); ++i7) {
                    object5 = nodeList6.item(i7);
                    if (object5.getNodeType() != 1 || !object5.getNodeName().equals("param")) continue;
                    charSequence = object5.getAttributes().getNamedItem("name").getNodeValue();
                    object4 = object5.getAttributes().getNamedItem("Datatype");
                    String string = null;
                    if (object4 != null) {
                        string = object4.getNodeValue();
                    }
                    nodeList4 = object5.getChildNodes();
                    for (n3 = 0; n3 < nodeList4.getLength(); ++n3) {
                        node3 = nodeList4.item(n3);
                        if (node3.getNodeType() != 1 || !node3.getNodeName().equals("commandReference")) continue;
                        object3 = node3.getChildNodes();
                        for (int i8 = 0; i8 < object3.getLength(); ++i8) {
                            object2 = object3.item(i8);
                            if (object2.getNodeType() != 1 || !object2.getNodeName().equals("para")) continue;
                            object = object2.getChildNodes();
                            for (int i9 = 0; i9 < object.getLength(); ++i9) {
                                Node node5 = object.item(i9);
                                if (!(node5.getNodeType() != 3 || node5.getNodeValue().trim().length() == 0 || ",".equals(node5.getNodeValue().trim()) || ".".equals(node5.getNodeValue().trim()) || ", and".equals(node5.getNodeValue().trim()))) {
                                    if (string == null) {
                                        this.helpStrs.put(charSequence, GenUtil.firstToLowerCase(node5.getNodeValue().trim()));
                                        if (n2 == 0) continue;
                                    }
                                    if (string.equalsIgnoreCase("Boolean")) {
                                        this.helpStrs.put(charSequence, "String, " + GenUtil.firstToLowerCase(node5.getNodeValue().trim()));
                                        if (n2 == 0) continue;
                                    }
                                    this.helpStrs.put(charSequence, string + ", " + GenUtil.firstToLowerCase(node5.getNodeValue().trim()));
                                    if (n2 == 0) continue;
                                }
                                if (node5.getNodeType() != 1 || !node5.getNodeName().equals("bulletList")) continue;
                                NodeList nodeList7 = node5.getChildNodes();
                                ArrayList<String> arrayList = new ArrayList<String>(nodeList7.getLength() - 1);
                                for (int i10 = 0; i10 < nodeList7.getLength(); ++i10) {
                                    Node node6 = nodeList7.item(i10);
                                    if (node6.getNodeType() != 1 || !node6.getNodeName().equals("bullet_item")) continue;
                                    String string2 = node6.getFirstChild().getNodeValue();
                                    arrayList.add(string2);
                                    if (n2 == 0) continue;
                                }
                                this.helpStrs.put((String)charSequence + "Hints", arrayList);
                                if (n2 == 0) continue;
                            }
                            if (n2 == 0) continue;
                        }
                        if (n2 == 0) continue;
                    }
                    if (n2 == 0) continue;
                }
                if (n2 == 0) continue;
                break;
            }
        }
        catch (Exception exception) {
            a.warning("Unable to generate metadata strings successfully. " + exception);
        }
    }

    static /* synthetic */ Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        GPImporter.addParamImporter(new GPStringImporter());
        GPImporter.addParamImporter(new GPLongImporter());
        GPImporter.addParamImporter(new GPDoubleImporter());
        GPImporter.addParamImporter(new GPBooleanImporter());
        b = "com.esri.arcgis.geoprocessing.tools";
    }
}

