/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sxle.map;

import com.sas.sxle.map.LogItem;
import com.sas.sxle.map.Logger;
import com.sas.sxle.map.SXLEContext;
import com.sas.sxle.map.Tuple;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.apache.xerces.impl.Version;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.util.SecurityManager;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.XNIException;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class XMLQuickValidator
extends SAXParser
implements ContentHandler,
LexicalHandler,
DeclHandler,
DTDHandler,
DocumentHandler,
ErrorHandler {
    private long elements;
    private long attributes;
    private long characters;
    private long ignorableWhitespace;
    private long len;
    private boolean xmlValid = true;
    private static ResourceBundle res = ResourceBundle.getBundle("com.sas.sxle.map.Resources");

    public XMLQuickValidator() {
        this.setContentHandler(this);
        this.setDTDHandler(this);
        this.setErrorHandler(this);
        this.setDocumentHandler(this);
        try {
            this.setDeclHandler(this);
            this.setLexicalHandler(this);
            SecurityManager sm = new SecurityManager();
            sm.setEntityExpansionLimit(0);
            switch (SXLEContext.validationLevel()) {
                case 1: {
                    Logger.log(res.getString("MsgParseValLevelMin.txt"), 3);
                    this.setFeature("http://xml.org/sax/features/validation", true);
                    this.setFeature("http://apache.org/xml/features/validation/schema", true);
                    this.setFeature("http://apache.org/xml/features/validation/dynamic", true);
                    this.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
                    this.setFeature("http://apache.org/xml/features/standard-uri-conformant", true);
                    this.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                    this.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    this.setProperty("http://apache.org/xml/properties/security-manager", sm);
                    break;
                }
                case 2: {
                    if (!SXLEContext.isLocal()) {
                        ArrayList<Tuple> details = new ArrayList<Tuple>();
                        details.add(new Tuple(res.getString("MsgParseValLevelOffWarn.txt"), "http://xerces.apache.org/xerces2-j/features.html"));
                        Logger.log(res.getString("MsgParseValLevelOff.txt"), details, 2);
                    }
                    this.setFeature("http://xml.org/sax/features/validation", false);
                    this.setFeature("http://apache.org/xml/features/validation/schema", false);
                    this.setFeature("http://apache.org/xml/features/validation/dynamic", false);
                    this.setFeature("http://apache.org/xml/features/validation/schema-full-checking", false);
                    this.setFeature("http://apache.org/xml/features/standard-uri-conformant", false);
                    this.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                    this.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    this.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                    this.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                    this.setProperty("http://apache.org/xml/properties/security-manager", sm);
                    break;
                }
                default: {
                    ArrayList<Tuple> details = new ArrayList<Tuple>();
                    details.add(new Tuple(res.getString("MsgParseValLevelHighWarn1.txt"), res.getString("MsgParseValLevelHighWarn2.txt")));
                    Logger.log(res.getString("MsgParseValLevelHigh.txt"), details, 2);
                    this.setFeature("http://xml.org/sax/features/validation", true);
                    this.setFeature("http://apache.org/xml/features/validation/schema", true);
                    this.setFeature("http://apache.org/xml/features/validation/dynamic", true);
                    this.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
                    this.setFeature("http://apache.org/xml/features/standard-uri-conformant", true);
                    break;
                }
            }
        }
        catch (SAXNotRecognizedException e) {
            Logger.log(new LogItem("Not recognized: " + e.getLocalizedMessage(), 1));
            this.xmlValid = false;
        }
        catch (SAXNotSupportedException e) {
            Logger.log(new LogItem("Not supported: " + e.getLocalizedMessage(), 1));
            this.xmlValid = false;
        }
    }

    public void parse(String src) {
        try {
            super.parse(src);
        }
        catch (IOException e) {
            Logger.log(new LogItem("Parse IOException: " + e.getLocalizedMessage(), 1));
            this.xmlValid = false;
        }
        catch (SAXException e) {
            Logger.log(new LogItem("Parse SAXException: " + e.getLocalizedMessage(), 1));
            this.xmlValid = false;
        }
    }

    @Override
    public void startDocument() {
        this.elements = 0L;
        this.attributes = 0L;
        this.characters = 0L;
        this.ignorableWhitespace = 0L;
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(String uri, String lname, String qname, Attributes attrs) {
        ++this.elements;
        this.attributes += (long)attrs.getLength();
        for (int a = 0; a < attrs.getLength(); ++a) {
            if (attrs.getValue(a) == null) continue;
            this.characters += (long)attrs.getValue(a).length();
            if (attrs.getQName(a) == null || !attrs.getQName(a).startsWith("xsi")) continue;
            Logger.log(new LogItem("XSD: " + attrs.getValue(a), 1));
        }
    }

    @Override
    public void endElement(String uri, String lname, String qname) {
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.characters += (long)length;
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
        this.ignorableWhitespace += (long)length;
    }

    public void logException(SAXParseException ex) {
        Logger.log(new LogItem("Exception class: " + ex.getClass().getName(), 1));
        Logger.log(new LogItem("Message: " + ex.getLocalizedMessage(), 1));
        if (ex.getPublicId() != null) {
            Logger.log(new LogItem("ID: " + ex.getPublicId(), 1));
        }
        Logger.log(new LogItem("Location: line " + Integer.toString(ex.getLineNumber()) + ", column " + Integer.toString(ex.getColumnNumber()), 1));
    }

    @Override
    public void warning(SAXParseException ex) {
        this.logException(ex);
        this.xmlValid = false;
    }

    @Override
    public void error(SAXParseException ex) {
        this.logException(ex);
        this.xmlValid = false;
    }

    @Override
    public void fatalError(SAXParseException ex) {
        this.logException(ex);
        this.xmlValid = false;
    }

    @Override
    public void comment(char[] ch, int start, int length) {
    }

    @Override
    public void endCDATA() {
    }

    @Override
    public void endDTD() {
    }

    @Override
    public void endEntity(String name) {
    }

    @Override
    public void startCDATA() {
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) {
        Logger.log(new LogItem("DTD: " + systemId, 3));
    }

    @Override
    public void startEntity(String name) {
    }

    @Override
    public void endPrefixMapping(String prefix) {
    }

    @Override
    public void processingInstruction(String target, String data) {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
    }

    public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) throws XNIException {
        String decl = "XMLDecl:";
        if (version != null) {
            decl = decl + " version=" + version;
        }
        if (encoding != null) {
            decl = decl + " encoding=" + encoding;
        }
        if (standalone != null) {
            decl = decl + " standalone=" + standalone;
        }
        Logger.log(new LogItem(decl, 3));
    }

    public void logResults() {
        String msg = "Validation summary: ";
        msg = msg + this.elements;
        msg = msg + " elements, ";
        msg = msg + this.attributes;
        msg = msg + " attributes, ";
        msg = msg + this.characters;
        msg = msg + " characters";
        NumberFormat nf = NumberFormat.getPercentInstance();
        Logger.log(new LogItem(msg, 3));
        msg = "File size: " + this.len + " Overhead: " + nf.format(1.0 - (double)this.characters / (double)this.len);
        Logger.log(new LogItem(msg, 3));
    }

    @Override
    public void notationDecl(String name, String publicID, String systemID) {
    }

    @Override
    public void unparsedEntityDecl(String name, String publicID, String systemID, String notationName) {
    }

    @Override
    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) {
    }

    @Override
    public void elementDecl(String name, String model) {
    }

    @Override
    public void externalEntityDecl(String name, String publicId, String systemId) {
    }

    @Override
    public void internalEntityDecl(String name, String value) {
    }

    public static int validate(String fname) {
        XMLQuickValidator qv = new XMLQuickValidator();
        Logger.log(new LogItem("Parser: " + Version.getVersion(), 3));
        try {
            File f = new File(fname);
            qv.len = f.length();
            qv.parse(f.toURI().toString());
        }
        catch (Exception e) {
            Logger.log(new LogItem("Exception: " + e.getMessage(), 1));
            qv.xmlValid = false;
        }
        if (qv.xmlValid) {
            qv.logResults();
        }
        Logger.log(new LogItem("Status: " + (qv.xmlValid ? "PASS" : "FAIL"), 3));
        return qv.xmlValid ? 0 : -1;
    }

    @Override
    public void endElement(String name) throws SAXException {
    }

    @Override
    public void startElement(String name, AttributeList atts) throws SAXException {
    }
}

