/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sxle.map;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.Vector;
import javax.swing.JOptionPane;

public class XMLFile
extends File {
    private static final long serialVersionUID = -3634734482389718149L;
    String m_encoding = null;
    int m_BOMlen = 0;
    FileInputStream m_fis = new FileInputStream(this);
    FileChannel m_fc = this.m_fis.getChannel();
    static ResourceBundle res = ResourceBundle.getBundle("com.sas.sxle.map.Resources");
    private static final String EOL = System.getProperty("line.separator");

    public XMLFile(String pathname) throws FileNotFoundException, IOException {
        super(pathname);
        this.detectBOM();
    }

    public XMLFile(File file) throws FileNotFoundException, IOException {
        super(file.getPath());
        this.detectBOM();
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public void setEncoding(String encoding) {
        this.m_encoding = encoding;
    }

    private void detectBOM() throws IOException {
        this.m_encoding = null;
        this.m_BOMlen = 0;
        ByteBuffer code = ByteBuffer.allocateDirect(4);
        this.m_fc.read(code, 0L);
        byte b1 = code.get(0);
        byte b2 = code.get(1);
        byte b3 = code.get(2);
        byte b4 = code.get(3);
        if (b1 == -1 && b2 == -2 && b3 == 60 && b4 == 0) {
            this.m_encoding = "UTF-16LE";
            this.m_BOMlen = 2;
        }
        if (b1 == -2 && b2 == -1 && b3 == 0 && b4 == 60) {
            this.m_encoding = "UTF-16BE";
            this.m_BOMlen = 2;
        }
        if (b1 == 60 && b2 == 0 && b3 == 63 && b4 == 0) {
            this.m_encoding = "UTF-16LE";
        }
        if (b1 == 0 && b2 == 60 && b3 == 0 && b4 == 63) {
            this.m_encoding = "UTF-16BE";
        }
        if (b1 == -1 && b2 == -2 && b3 == 0 && b4 == 0) {
            this.m_encoding = "UTF-32LE";
            this.m_BOMlen = 4;
        }
        if (b1 == 0 && b2 == 0 && b3 == -2 && b4 == -1) {
            this.m_encoding = "UTF-32BE";
            this.m_BOMlen = 4;
        }
        if (b1 == 60 && b2 == 0 && b3 == 0 && b4 == 0) {
            this.m_encoding = "UTF-32LE";
        }
        if (b1 == 0 && b2 == 0 && b3 == 0 && b4 == 60) {
            this.m_encoding = "UTF-32BE";
        }
        if (b1 == -17 && b2 == -69 && b3 == -72 && b4 == -1) {
            this.m_encoding = "UTF-8";
            this.m_BOMlen = 3;
        }
        if (b1 == 76 && b2 == 111 && b3 == -89 && b4 == -108) {
            this.m_encoding = "EBCDIC";
        }
    }

    public CharBuffer getContents() throws IOException {
        Charset charset;
        MappedByteBuffer txtMBB = this.m_fc.map(FileChannel.MapMode.READ_ONLY, 0L, this.length());
        if (this.m_encoding == null) {
            this.m_encoding = XMLFile.getDefaultEncoding().name();
        }
        try {
            charset = Charset.forName(this.m_encoding);
        }
        catch (Exception e) {
            String msg = e.toString();
            msg = msg + EOL + EOL + res.getString("MsgAvailableEncodings.txt") + EOL;
            SortedMap<String, Charset> map = Charset.availableCharsets();
            Iterator<String> it = map.keySet().iterator();
            int ctr = 0;
            while (it.hasNext()) {
                String charsetName = it.next();
                msg = msg + charsetName + (++ctr % 8 == 0 ? EOL : " ");
            }
            JOptionPane.showMessageDialog(null, msg, "MsgErrEncoding.txt", 0);
            return null;
        }
        CharsetDecoder cd = charset.newDecoder();
        CharBuffer cb = cd.decode(txtMBB);
        return cb;
    }

    public static Vector<String> getEncodings() {
        SortedMap<String, Charset> charsets = Charset.availableCharsets();
        Vector<String> enc = new Vector<String>(charsets.size());
        Iterator<String> it = charsets.keySet().iterator();
        while (it.hasNext()) {
            enc.add(it.next());
        }
        return enc;
    }

    public static Charset getDefaultEncoding() {
        Charset defCharset;
        block2: {
            InputStreamReader isr = new InputStreamReader(System.in);
            String defEnc = isr.getEncoding();
            defCharset = null;
            Charset utfCharset = null;
            try {
                utfCharset = Charset.forName("UTF-8");
                defCharset = Charset.forName(defEnc);
            }
            catch (Exception e) {
                defCharset = utfCharset;
                if (defCharset != null) break block2;
                e.printStackTrace();
            }
        }
        return defCharset;
    }

    public void close() {
        if (this.m_fc != null) {
            try {
                this.m_fc.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.m_fis != null) {
            try {
                this.m_fis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

