/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sxle.map;

import com.sas.sxle.map.Atom;
import com.sas.sxle.map.Column;
import com.sas.sxle.map.Map;
import com.sas.sxle.map.Namespace;
import com.sas.sxle.map.SASName;
import com.sas.sxle.map.ValidationIssue;
import com.sas.sxle.map.XPath;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;

public class Table
extends Atom {
    private static final long serialVersionUID = 4555808781023866153L;
    static ResourceBundle res = ResourceBundle.getBundle("com.sas.sxle.map.Resources");
    private XPath m_xPath;
    private XPath m_optXPath;
    private ArrayList<Atom> m_columns;
    private int m_pathMode;

    public Table() {
        this.m_columns = this.m_children;
    }

    public Table(Table tab) {
        this.m_columns = this.m_children;
        if (tab.getOptXPath() != null) {
            this.m_optXPath = new XPath(tab.getOptXPath());
        }
        this.m_pathMode = tab.m_pathMode;
        if (tab.getName() != null) {
            this.setName(tab.getName());
        }
        if (tab.getDescription() != null) {
            this.m_description = new String(tab.getDescription());
        }
        if (tab.getXPath() != null) {
            this.m_xPath = new XPath(tab.getXPath());
        }
        this.m_namespace = tab.m_namespace;
        this.m_parent = null;
        this.m_dirty = true;
        for (int c = 0; c < tab.getChildCount(); ++c) {
            this.addColumn(new Column(tab.getColumn(c)));
        }
    }

    public ArrayList<Atom> getColumns() {
        return this.m_columns;
    }

    public Column getColumn(int i) {
        return (Column)this.m_columns.get(i);
    }

    public int addColumn(Column col) {
        this.m_columns.add(col);
        this.m_dirty = true;
        col.setParent(this);
        this.extractNamespaces(col.getPolymer(), (Map)this.getParent());
        return this.m_columns.size();
    }

    public int addColumnAt(Column col, int index) {
        this.m_columns.add(index, col);
        this.m_dirty = true;
        col.setParent(this);
        this.extractNamespaces(col.getPolymer(), (Map)this.getParent());
        return this.m_columns.size();
    }

    private void extractNamespaces(Atom atom, Map map) {
        Atom a = atom;
        while (a != null) {
            if (a.getNamespace() != null) {
                map.getNamespaces().add(new Namespace(a.m_namespace));
            }
            a = a.m_parent;
        }
    }

    public void deleteColumn(int i) {
        this.m_columns.remove(i);
        this.m_dirty = true;
    }

    @Override
    public String getXPathName() {
        return this.m_xPath.getValue();
    }

    public XPath getXPath() {
        return this.m_xPath;
    }

    public void setXPath(XPath xPath) {
        this.m_xPath = xPath;
        this.m_dirty = true;
    }

    public void setXPath(String xp) {
        if (this.m_xPath == null) {
            this.m_xPath = new XPath(xp);
        } else {
            this.m_xPath.setValue(xp);
        }
        this.m_dirty = true;
    }

    public XPath getOptXPath() {
        return this.m_optXPath;
    }

    public int getColumnCount() {
        return this.m_columns.size();
    }

    public void setOptXPath(XPath optXPath) {
        this.m_optXPath = optXPath;
        this.m_dirty = true;
    }

    public void setOptXPath(String xp) {
        if (this.m_optXPath == null) {
            this.m_optXPath = new XPath(xp);
        } else {
            this.m_optXPath.setValue(xp);
        }
        this.m_dirty = true;
    }

    public void setColumns(ArrayList<Atom> cols) {
        this.m_columns = cols;
        this.m_dirty = true;
    }

    public boolean validate(ArrayList<ValidationIssue> issues) {
        String msg;
        boolean isOK = true;
        if (!SASName.isValid(this.getName())) {
            isOK = false;
            msg = MessageFormat.format(res.getString("VMsgTableNameInvalid.txt"), this.getName());
            issues.add(new ValidationIssue(1, msg, this));
        }
        if (SASName.isReserved(this.getName())) {
            isOK = false;
            msg = MessageFormat.format(res.getString("VMsgTableNameReserved.txt"), this.getName());
            issues.add(new ValidationIssue(1, msg, this));
        }
        if (this.m_xPath == null) {
            isOK = false;
            msg = MessageFormat.format(res.getString("VMsgTableNoXPath.txt"), this.getName());
            issues.add(new ValidationIssue(1, msg, this));
        } else if (!this.m_xPath.isValid()) {
            isOK = false;
            msg = MessageFormat.format(res.getString("VMsgTableBadXpath.txt"), this.getName(), this.m_xPath.getValue());
            issues.add(new ValidationIssue(1, msg, this));
        }
        if (this.m_columns == null || this.m_columns.size() == 0) {
            isOK = false;
            msg = MessageFormat.format(res.getString("VMsgTableNoColumns.txt"), this.getName());
            issues.add(new ValidationIssue(1, msg, this));
        } else {
            for (int c = 0; c < this.m_columns.size(); ++c) {
                String colName = ((Column)this.m_columns.get(c)).getName();
                if (colName.compareToIgnoreCase(this.getName()) == 0 && ((Map)this.getParent()).getVersionID() < 2) {
                    isOK = false;
                    String msg2 = MessageFormat.format(res.getString("VMsgTableColSame.txt"), this.getName());
                    issues.add(new ValidationIssue(1, msg2, (Column)this.m_columns.get(c)));
                }
                for (int c2 = c + 1; c2 < this.m_columns.size(); ++c2) {
                    String col2Name = ((Column)this.m_columns.get(c2)).getName();
                    if (colName.compareToIgnoreCase(col2Name) != 0) continue;
                    isOK = false;
                    String msg3 = MessageFormat.format(res.getString("VMsgTableDupColumn.txt"), colName);
                    issues.add(new ValidationIssue(1, msg3, this.m_columns.get(c)));
                }
                isOK &= ((Column)this.m_columns.get(c)).validate(issues);
            }
        }
        return isOK;
    }
}

