/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sxle.map;

import com.sas.sxle.map.AVPair;
import com.sas.sxle.map.Atom;
import com.sas.sxle.map.Column;
import com.sas.sxle.map.Map;
import com.sas.sxle.map.Molecule;
import com.sas.sxle.map.NamespaceList;
import com.sas.sxle.map.Output;
import com.sas.sxle.map.Polymer;
import com.sas.sxle.map.Sample;
import com.sas.sxle.map.Table;
import com.sas.sxle.map.XPath;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;

public class SXLETransferable
implements Transferable,
ClipboardOwner {
    static ResourceBundle res = ResourceBundle.getBundle("com.sas.sxle.map.Resources");
    public static final DataFlavor listFlavor = new DataFlavor(new ArrayList().getClass(), "SXLE.List");
    public static final DataFlavor polymerFlavor = new DataFlavor(new Polymer().getClass(), "SXLE.Polymer");
    public static final DataFlavor moleculeFlavor = new DataFlavor(new Molecule().getClass(), "SXLE.Molecule");
    public static final DataFlavor atomFlavor = new DataFlavor(new Atom().getClass(), "SXLE.Atom");
    public static final DataFlavor xPathFlavor = new DataFlavor(new XPath().getClass(), "SXLE.XPath");
    public static final DataFlavor nameFlavor = new DataFlavor(new String().getClass(), "SXLE.Name");
    public static final DataFlavor valueFlavor = new DataFlavor(new String().getClass(), "SXLE.Value");
    public static final DataFlavor attrFlavor = new DataFlavor(new String().getClass(), "SXLE.Attribute");
    public static final DataFlavor attrGroupFlavor = new DataFlavor(new String().getClass(), "SXLE.AttributeGroup");
    public static final DataFlavor columnFlavor = new DataFlavor(new Column().getClass(), "SXLE.Column");
    public static final DataFlavor tableFlavor = new DataFlavor(new Table().getClass(), "SXLE.Table");
    public static final DataFlavor[] flavors = new DataFlavor[]{polymerFlavor, moleculeFlavor, atomFlavor, xPathFlavor, nameFlavor, valueFlavor, DataFlavor.stringFlavor};
    public static final DataFlavor[] attrFlavors = new DataFlavor[]{listFlavor, polymerFlavor, moleculeFlavor, atomFlavor, xPathFlavor, nameFlavor, valueFlavor, attrFlavor, DataFlavor.stringFlavor};
    public static final DataFlavor[] attrGroupFlavors = new DataFlavor[]{moleculeFlavor, atomFlavor, attrGroupFlavor, DataFlavor.stringFlavor};
    public static final DataFlavor[] simpleFlavors = new DataFlavor[]{nameFlavor, valueFlavor, DataFlavor.stringFlavor};
    public static final DataFlavor[] sampleFlavors = new DataFlavor[]{valueFlavor, DataFlavor.stringFlavor};
    public static final DataFlavor[] mapFlavors = new DataFlavor[]{columnFlavor, tableFlavor};
    public static final DataFlavor[] multiFlavors = new DataFlavor[]{listFlavor};
    private static final List<DataFlavor> flavorList = Arrays.asList(flavors);
    private static final List<DataFlavor> sampleFlavorList = Arrays.asList(sampleFlavors);
    private static final List<DataFlavor> attrFlavorList = Arrays.asList(attrFlavors);
    private static final List<DataFlavor> attrGroupFlavorList = Arrays.asList(attrGroupFlavors);
    private static final List<DataFlavor> multiFlavorList = Arrays.asList(multiFlavors);
    private static final List<DataFlavor> mapFlavorList = Arrays.asList(mapFlavors);
    Object m_obj;

    public SXLETransferable(Object obj) {
        this.m_obj = obj;
    }

    public SXLETransferable(ArrayList<?> list) {
        this.m_obj = list;
    }

    @Override
    public synchronized DataFlavor[] getTransferDataFlavors() {
        if (this.m_obj instanceof Map || this.m_obj instanceof NamespaceList || this.m_obj instanceof Output) {
            return new DataFlavor[0];
        }
        if (this.m_obj instanceof Column) {
            return new DataFlavor[]{columnFlavor};
        }
        if (this.m_obj instanceof Table) {
            return new DataFlavor[]{tableFlavor};
        }
        if (this.m_obj instanceof Molecule && ((Molecule)this.m_obj).getType() == 7) {
            return attrFlavors;
        }
        if (this.m_obj instanceof Molecule && (((Molecule)this.m_obj).getType() == 6 || ((Molecule)this.m_obj).getType() == 2)) {
            return attrGroupFlavors;
        }
        if (this.m_obj instanceof Molecule && (((Molecule)this.m_obj).getType() == 4 || ((Molecule)this.m_obj).getType() == 0 || ((Molecule)this.m_obj).getType() == 3 || ((Molecule)this.m_obj).getType() == 5)) {
            return simpleFlavors;
        }
        if (this.m_obj instanceof Sample) {
            return sampleFlavors;
        }
        if (this.m_obj instanceof Atom) {
            return flavors;
        }
        if (this.m_obj instanceof ArrayList) {
            return multiFlavors;
        }
        return new DataFlavor[0];
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor df) {
        boolean isOK = false;
        if (this.m_obj instanceof Column) {
            isOK = df == columnFlavor;
        } else if (this.m_obj instanceof Table) {
            isOK = df == tableFlavor;
        } else if (this.m_obj instanceof Molecule && ((Molecule)this.m_obj).getType() == 7) {
            isOK = attrFlavorList.contains(df);
        } else if (this.m_obj instanceof Molecule && ((Molecule)this.m_obj).getType() == 6) {
            isOK = attrGroupFlavorList.contains(df);
        } else if (this.m_obj instanceof Sample) {
            isOK = sampleFlavorList.contains(df);
        } else if (this.m_obj instanceof Atom) {
            isOK = flavorList.contains(df);
        } else if (this.m_obj instanceof ArrayList) {
            isOK = multiFlavorList.contains(df);
        }
        return isOK;
    }

    @Override
    public void lostOwnership(Clipboard c, Transferable t) {
        this.m_obj = null;
    }

    @Override
    public synchronized Object getTransferData(DataFlavor df) {
        if (df == DataFlavor.stringFlavor) {
            if (this.m_obj instanceof Molecule && (((Molecule)this.m_obj).getType() == 4 || ((Molecule)this.m_obj).getType() == 0 || ((Molecule)this.m_obj).getType() == 2 || ((Molecule)this.m_obj).getType() == 3 || ((Molecule)this.m_obj).getType() == 5)) {
                return this.m_obj.toString();
            }
            if (this.m_obj instanceof Atom) {
                return ((Atom)this.m_obj).getName();
            }
            return this.m_obj.toString();
        }
        if (df == xPathFlavor) {
            return ((Atom)this.m_obj).getXPathName();
        }
        if (df == nameFlavor) {
            return ((Atom)this.m_obj).getName();
        }
        if (df == attrFlavor) {
            return new AVPair(((Molecule)this.m_obj).getName(), ((Molecule)this.m_obj).getValue());
        }
        if (df == valueFlavor) {
            if (this.m_obj instanceof Sample) {
                return ((Sample)this.m_obj).getValue();
            }
            if (this.m_obj instanceof Molecule) {
                return ((Molecule)this.m_obj).getValue();
            }
            return null;
        }
        return this.m_obj;
    }
}

