/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sxle.map;

import com.sas.sxle.map.Map;
import com.sas.sxle.map.SXLEContext;
import com.sas.sxle.map.Table;
import java.util.ResourceBundle;

public class SASCodeGenerator {
    static ResourceBundle res = ResourceBundle.getBundle("com.sas.sxle.map.Resources");
    private static final String EOL = System.getProperty("line.separator");

    public String sasifyName(String name) {
        String s = "";
        int vc = 0;
        int sc = 0;
        while (vc < 8 && sc < name.length()) {
            char c;
            if (!Character.isLetter(c = name.charAt(sc++)) && (vc <= 0 || !Character.isLetterOrDigit(c))) continue;
            s = s + c;
            ++vc;
        }
        return s;
    }

    public String generate(Map map, String xmlFileName, String mapFileName, boolean genCat, boolean genContents, boolean genPrint, boolean genWork) {
        Table t;
        int i;
        String mapPath;
        String srcPath;
        String libName = "";
        if (xmlFileName != null) {
            int pDel = Math.max(xmlFileName.lastIndexOf("\\"), xmlFileName.lastIndexOf("/"));
            String temp = xmlFileName.substring(pDel + 1);
            int end = temp.indexOf(".");
            if (end < 0) {
                end = temp.length();
            }
            temp = temp.substring(0, end);
            libName = this.sasifyName(temp);
        }
        if (libName == null || libName.length() < 1 || libName.equalsIgnoreCase("SXLEMAP")) {
            libName = "SXLELIB";
        }
        if ((srcPath = xmlFileName) == null) {
            srcPath = "<fileName>.xml";
        }
        if ((mapPath = mapFileName) == null) {
            mapPath = "<mapName>.map";
        }
        String SASText = "";
        String AppVersion = SXLEContext.getVersion();
        SASText = "/********************************************************************************" + EOL;
        SASText = SASText + " *  Generated by XML Mapper, ";
        SASText = SASText + AppVersion + EOL;
        SASText = SASText + " ********************************************************************************/" + EOL + EOL;
        SASText = SASText + "/*" + EOL;
        SASText = SASText + " *  Environment" + EOL;
        SASText = SASText + " */" + EOL;
        SASText = SASText + "filename  " + libName + " '" + srcPath + "';" + EOL;
        SASText = SASText + "filename  SXLEMAP '" + mapPath + "';" + EOL;
        SASText = map.getVersionID() >= 3 ? SASText + "libname   " + libName + " xmlv2 xmlmap=SXLEMAP access=READONLY;" + EOL + EOL : SASText + "libname   " + libName + " xml xmlmap=SXLEMAP access=READONLY;" + EOL + EOL;
        if (genCat) {
            SASText = SASText + "/*" + EOL;
            SASText = SASText + " *  Catalog" + EOL;
            SASText = SASText + " */" + EOL + EOL;
            SASText = SASText + "proc datasets lib=" + libName + "; run;" + EOL + EOL;
        }
        String obs = "";
        int obsLimit = SXLEContext.sampleLimit();
        if (obsLimit > 0) {
            obs = "(obs=" + Integer.toString(obsLimit) + ")";
        }
        if (genContents) {
            SASText = SASText + "/*" + EOL;
            SASText = SASText + " *  Contents" + EOL;
            SASText = SASText + " */" + EOL + EOL;
            for (i = 0; i < map.getTableCount(); ++i) {
                t = map.getTable(i);
                SASText = SASText + "proc contents data=";
                SASText = SASText + libName + "." + t.getName() + " varnum; run;" + EOL;
            }
            SASText = SASText + EOL;
        }
        if (genPrint) {
            SASText = SASText + "/*" + EOL;
            SASText = SASText + " *  Printing" + EOL;
            SASText = SASText + " */" + EOL + EOL;
            for (i = 0; i < map.getTableCount(); ++i) {
                t = map.getTable(i);
                SASText = SASText + "title 'Table " + t.getName() + "';" + EOL;
                SASText = SASText + "proc print data=";
                SASText = SASText + libName + "." + t.getName() + obs + "; run;" + EOL;
                SASText = SASText + "title;" + EOL + EOL;
            }
            SASText = SASText + EOL;
        }
        if (genWork) {
            SASText = SASText + "/*" + EOL;
            SASText = SASText + " *  Local Extraction" + EOL;
            SASText = SASText + " */" + EOL + EOL;
            for (i = 0; i < map.getTableCount(); ++i) {
                t = map.getTable(i);
                SASText = SASText + "DATA " + t.getName() + "; SET " + libName + "." + t.getName() + "; run;" + EOL;
            }
            SASText = SASText + EOL;
        }
        return SASText;
    }
}

