/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sxle.map;

import com.sas.sxle.map.Datatype;
import com.sas.sxle.map.ExtendedSAXParser;
import com.sas.sxle.map.Molecule;
import com.sas.sxle.map.Namespace;
import com.sas.sxle.map.SXLEContext;
import com.sas.sxle.map.Sample;
import java.util.ArrayList;
import org.xml.sax.Attributes;

public class Polymer
extends Molecule {
    private static final long serialVersionUID = 1741833429037566987L;
    private int m_recurrence = 1;
    private int m_cardinality = 1;
    private int m_max_cardinality = 1;
    private ArrayList<Sample> m_samples = new ArrayList();
    private int m_samplePoolSize = 0;
    private static int m_sampleLimit = -1;
    private int m_maxLen = 0;
    private int m_probDataType = 0;
    private static boolean m_allowDupes = true;
    private static boolean m_allowDupesSet = false;

    public Polymer() {
        Polymer.initLimit();
        Polymer.initAllowDuplicateSamples();
    }

    public Polymer(Molecule mol) {
        Polymer.initLimit();
        Polymer.initAllowDuplicateSamples();
        this.setName(mol.getName());
        this.m_description = mol.getDescription();
        this.m_namespace = mol.getNamespace();
        this.m_hasAttrs = mol.hasAttributes();
        this.m_type = mol.getType();
    }

    public static void setLimit(int limit) {
        m_sampleLimit = limit;
    }

    public static int getLimit() {
        Polymer.initLimit();
        return m_sampleLimit;
    }

    private static void initLimit() {
        int sl;
        if (m_sampleLimit < 0 && (sl = SXLEContext.sampleLimit()) >= 0) {
            m_sampleLimit = sl;
        }
    }

    public static void setAllowDuplicateSamples(boolean dupes) {
        m_allowDupes = dupes;
    }

    public static boolean getAllowDuplicateSamples() {
        Polymer.initAllowDuplicateSamples();
        return m_allowDupes;
    }

    private static void initAllowDuplicateSamples() {
        if (!m_allowDupesSet) {
            m_allowDupes = SXLEContext.duplicateSamples();
            m_allowDupesSet = true;
        }
    }

    public ArrayList<Sample> getSamples() {
        return this.m_samples;
    }

    @Override
    public void addAttributes(Attributes attrs, ExtendedSAXParser esp) {
        if (attrs.getLength() == 0) {
            return;
        }
        this.m_hasAttrs = true;
        Polymer aNode = (Polymer)this.getChildNamed("Attributes");
        if (aNode == null) {
            aNode = new Polymer();
            aNode.setName("Attributes");
            aNode.setDescription(res.getString("AttributeGroupNodeDescription.txt"));
            aNode.setType(6);
            this.addChild(aNode);
        } else {
            ++aNode.m_recurrence;
        }
        for (int a = 0; a < attrs.getLength(); ++a) {
            Polymer dupAttr;
            String attrName;
            String pre = attrs.getQName(a);
            pre = pre != null && pre.contains(":") ? pre.substring(0, pre.indexOf(58)) : null;
            String uri = attrs.getURI(a);
            Namespace ns = null;
            if (uri != null) {
                ns = esp.findMRUMatchingNamespace(pre, uri);
            }
            if ((attrName = attrs.getLocalName(a)) == null || attrName.length() < 1) {
                attrName = "Attribute";
            }
            if ((dupAttr = (Polymer)aNode.getChildMatching(attrName, uri)) == null) {
                Polymer aChild = new Polymer();
                aChild.setName(attrName);
                aChild.setValue(attrs.getValue(a));
                if (ns != null) {
                    aChild.setNamespace(ns);
                }
                aChild.setType(7);
                aNode.addChild(aChild);
                aChild.tryAddSample(aChild.getValue());
                continue;
            }
            if (dupAttr.getValue().length() < attrs.getValue(a).length()) {
                dupAttr.setValue(attrs.getValue(a));
            }
            dupAttr.tryAddSample(attrs.getValue(a));
            ++dupAttr.m_recurrence;
        }
    }

    public Polymer tryAddChild(Molecule child) {
        Polymer sib = (Polymer)this.getChildERNamed(child.getERName());
        if (sib == null) {
            Polymer kid = new Polymer(child);
            kid.setParent(this);
            this.m_children.add(kid);
            return kid;
        }
        if (child.getValue() != null && sib.getValue() != null && sib.getValue().length() < child.getValue().length()) {
            sib.setAccumulate(false);
            sib.setValue(child.getValue());
        }
        ++sib.m_recurrence;
        ++sib.m_cardinality;
        if (sib.m_cardinality > sib.m_max_cardinality) {
            sib.m_max_cardinality = sib.m_cardinality;
        }
        for (int sc = 0; sc < sib.getChildCount(); ++sc) {
            Polymer nephew = (Polymer)sib.getChildren().get(sc);
            nephew.resetCardinality();
        }
        return sib;
    }

    public void resetCardinality() {
        this.m_cardinality = 0;
    }

    public void tryAddSample(String val) {
        if (val == null || val.trim() == null) {
            return;
        }
        int vl = val.length();
        if (vl == 0 || val.trim().length() == 0) {
            return;
        }
        ++this.m_samplePoolSize;
        if (!m_allowDupes) {
            for (int s = 0; s < this.m_samples.size(); ++s) {
                Sample samp = this.m_samples.get(s);
                if (val.compareTo(samp.getValue()) != 0) continue;
                return;
            }
        }
        boolean forceAdd = false;
        if (vl > this.m_maxLen) {
            this.m_maxLen = vl;
            forceAdd = true;
        }
        int dt = 0;
        if (this.m_probDataType != 1 && (dt = Datatype.bestMatch(val)) != this.m_probDataType) {
            forceAdd = true;
            this.m_probDataType = Datatype.resolve(this.m_probDataType, dt);
        }
        if (forceAdd && this.m_samples.size() >= m_sampleLimit && m_sampleLimit >= 1) {
            int index = m_sampleLimit == 1 ? 0 : 1;
            this.m_samples.remove(index);
        }
        if (this.m_samples.size() < m_sampleLimit) {
            if (dt == 0) {
                dt = Datatype.bestMatch(val);
            }
            this.m_samples.add(new Sample(val, dt));
        }
    }

    public int getRecurrence() {
        return this.m_recurrence;
    }

    public int getDatatype() {
        return this.m_probDataType;
    }

    @Override
    public String toString() {
        String nm = this.getName() + " [" + this.m_max_cardinality + "] {" + this.m_recurrence + "}";
        if (this.hasNamespace()) {
            nm = "{" + this.m_namespace.getURI() + "}" + nm;
        }
        return nm;
    }

    public int getMaxCardinality() {
        return this.m_max_cardinality;
    }

    @Override
    public int getLength() {
        return this.m_maxLen;
    }

    @Override
    public boolean hasData() {
        return this.m_samplePoolSize > 0;
    }
}

