/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sxle.map;

import com.sas.sxle.map.Atom;
import com.sas.sxle.map.ExtendedSAXParser;
import com.sas.sxle.map.Namespace;
import java.util.ResourceBundle;
import org.xml.sax.Attributes;

public class Molecule
extends Atom {
    private static final long serialVersionUID = -7987433693912604095L;
    static ResourceBundle res = ResourceBundle.getBundle("com.sas.sxle.map.Resources");
    public static final int kET_Document = 0;
    public static final int kET_Element = 1;
    public static final int kET_XMLDecl = 2;
    public static final int kET_DocTypeDef = 3;
    public static final int kET_Comment = 4;
    public static final int kET_ProcessingInstruction = 5;
    public static final int kET_AttrGroup = 6;
    public static final int kET_Attribute = 7;
    public static final int kET_Error = 8;
    protected StringBuffer m_value = new StringBuffer();
    protected boolean m_accumulate = true;
    protected boolean m_hasAttrs = false;
    protected int m_type = 1;

    public Molecule() {
        this.m_namespace = null;
    }

    public void addAttributes(Attributes attrs, ExtendedSAXParser esp) {
        if (attrs.getLength() == 0) {
            return;
        }
        this.m_hasAttrs = true;
        Molecule aNode = new Molecule();
        aNode.setName("Attributes");
        aNode.setDescription(res.getString("AttributeGroupNodeDescription.txt"));
        aNode.setType(6);
        this.addChild(aNode);
        for (int a = 0; a < attrs.getLength(); ++a) {
            String attrName;
            String pre = attrs.getQName(a);
            pre = pre != null && pre.contains(":") ? pre.substring(0, pre.indexOf(58)) : null;
            String uri = attrs.getURI(a);
            Namespace ns = null;
            if (uri != null) {
                ns = esp.findMRUMatchingNamespace(pre, uri);
            }
            if ((attrName = attrs.getLocalName(a)) == null || attrName.length() < 1) {
                attrName = "Attribute";
            }
            Molecule aChild = new Molecule();
            aChild.setName(attrName);
            if (ns != null) {
                aChild.setNamespace(ns);
            }
            aChild.setDescription(attrs.getURI(a));
            aChild.setValue(attrs.getValue(a));
            aChild.setType(7);
            aNode.addChild(aChild);
        }
    }

    public String getValue() {
        return this.m_value.toString();
    }

    public void setValue(String val) {
        if (this.m_accumulate && this.m_value != null) {
            this.m_value.append(val);
        } else {
            this.m_value.replace(0, this.m_value.length() - 1, val);
        }
    }

    public boolean getAccumulate() {
        return this.m_accumulate;
    }

    public void setAccumulate(boolean acc) {
        this.m_accumulate = acc;
    }

    @Override
    public String toString() {
        String txt = this.getName();
        if (this.m_value != null && this.m_value.length() > 0) {
            txt = txt + "=" + this.m_value;
        }
        return txt;
    }

    public int getLength() {
        if (this.m_value != null) {
            return this.m_value.length();
        }
        return 0;
    }

    public boolean hasAttributes() {
        return this.m_hasAttrs;
    }

    @Override
    public boolean hasChildren() {
        if (this.m_hasAttrs) {
            return this.m_children.size() > 1;
        }
        return this.m_children.size() > 0;
    }

    public boolean hasData() {
        return this.m_value != null;
    }

    public int getType() {
        return this.m_type;
    }

    public void setType(int t) {
        this.m_type = t;
    }

    @Override
    public String getExpandedXPathName() {
        String exxpn = "";
        if (this.m_parent != null) {
            exxpn = exxpn + this.m_parent.getExpandedXPathName();
        }
        switch (this.getType()) {
            case 6: {
                exxpn = exxpn + "/@";
                break;
            }
            case 7: {
                exxpn = exxpn + this.getExpName();
                break;
            }
            case 1: {
                exxpn = exxpn + "/";
                exxpn = exxpn + this.getExpName();
                break;
            }
            default: {
                return "";
            }
        }
        return exxpn;
    }

    @Override
    public String getXPathName() {
        String ern = "";
        if (this.m_parent != null) {
            ern = ern + this.m_parent.getXPathName();
        }
        switch (this.getType()) {
            case 6: {
                ern = ern + "/@";
                break;
            }
            case 7: {
                ern = ern + this.getERName();
                break;
            }
            case 1: {
                ern = ern + "/";
                ern = ern + this.getERName();
                break;
            }
            default: {
                return "";
            }
        }
        return ern;
    }

    @Override
    public String getERName() {
        String ern = "";
        if (this.hasNamespace()) {
            ern = ern + "{" + this.getNamespace().getIndex() + "}";
        }
        ern = ern + this.getName();
        return ern;
    }

    @Override
    public String getExpName() {
        String expn = "";
        if (this.hasNamespace()) {
            expn = expn + "{" + this.getNamespace().getURI() + "}";
        }
        expn = expn + this.getName();
        return expn;
    }
}

