/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sxle.map;

import com.sas.sxle.map.LogItem;
import com.sas.sxle.map.Logger;
import com.sas.sxle.map.Map;
import com.sas.sxle.map.MapModelBuilder;
import com.sas.sxle.map.ModelBundle;
import com.sas.sxle.map.Polymer;
import com.sas.sxle.map.SXLEContext;
import com.sas.sxle.map.XMLFile;
import com.sas.sxle.map.XMLQuickValidator;
import java.util.Date;

public class MapperProxy {
    Options mpopts = new Options();

    public MapperProxy() {
        SXLEContext.SetLocal(this.mpopts);
        Logger.init();
    }

    public Options getOptions() {
        return this.mpopts;
    }

    public int autoMap(String src, String dest) {
        int rc = 0;
        try {
            XMLFile xmlIn = new XMLFile(src);
            Map map = new Map();
            ModelBundle bundle = new ModelBundle();
            rc = MapModelBuilder.readXML(xmlIn, bundle);
            if (rc != 0) {
                return rc;
            }
            map.autoMake((Polymer)bundle.getXMLMetaTreeModel().getRoot(), bundle, null);
            MapModelBuilder.writeMap(dest, map);
            xmlIn.close();
        }
        catch (Exception e) {
            LogItem li = new LogItem(e.getMessage(), null, 1);
            Logger.log(li);
            return -1;
        }
        return rc;
    }

    public int validate(String src) {
        int rc = 0;
        try {
            rc = XMLQuickValidator.validate(src);
        }
        catch (Exception e) {
            LogItem li = new LogItem(e.getMessage(), null, 1);
            Logger.log(li);
            return -1;
        }
        return rc;
    }

    public int numLogItems() {
        return Logger.getLog().size();
    }

    public String logItemDescription(int i) {
        return Logger.getLog().get(i).getDescription();
    }

    public int logItemSeverity(int i) {
        return Logger.getLog().get(i).getSeverity();
    }

    public Date logItemTimestamp(int i) {
        return Logger.getLog().get(i).getTimestamp();
    }

    public int logItemNumDetails(int i) {
        if (Logger.getLog().get(i).getDetails() == null) {
            return 0;
        }
        return Logger.getLog().get(i).getDetails().size();
    }

    public String logItemDetailAttr(int i, int d) {
        return Logger.getLog().get(i).getDetails().get(d).getAttribute();
    }

    public String logItemDetailValue(int i, int d) {
        return Logger.getLog().get(i).getDetails().get(d).getValue();
    }

    public void logClear() {
        Logger.clear();
    }

    public class Options {
        public int MapMode = 0;
        public int MapVersion = 4;
        public int ValidationLevel = 2;
        public boolean GenerateOrdinals = true;
        public boolean PrefixAttributes = true;
        public boolean PrefixNamespaces = false;
    }
}

