/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sxle.map;

import com.sas.sxle.map.Atom;
import com.sas.sxle.map.Column;
import com.sas.sxle.map.Isomer;
import com.sas.sxle.map.Map;
import com.sas.sxle.map.Molecule;
import com.sas.sxle.map.Schema;
import com.sas.sxle.map.Table;
import com.sas.sxle.map.ValidationIssue;
import com.sas.sxle.map.XPath;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;

public class MapSchemaComparator {
    static ResourceBundle res = ResourceBundle.getBundle("com.sas.sxle.map.Resources");
    private static ArrayList<String> m_paths = null;
    private static Isomer m_prevRoot = null;
    private static HashMap<String, Molecule> m_nodes = null;

    public static void validate(Map map, Isomer root, ArrayList<ValidationIssue> issues) {
        if (map == null || map.getChildCount() < 1) {
            return;
        }
        if (root instanceof Schema && ((Schema)root).isRecursive()) {
            String msg = MessageFormat.format(res.getString("MsgWarnRecursiveSchemaMSC.txt"), root.getName());
            ValidationIssue vi = new ValidationIssue(4, msg, root);
            issues.add(vi);
            return;
        }
        if (m_paths == null) {
            m_paths = new ArrayList();
        }
        if (m_nodes == null) {
            m_nodes = new HashMap();
        }
        try {
            if (root != m_prevRoot) {
                m_nodes.clear();
                m_paths.clear();
                MapSchemaComparator.getValidPaths(root);
            }
            MapSchemaComparator.compareMap(map, issues);
        }
        catch (StackOverflowError e) {
            return;
        }
    }

    private static void getValidPaths(Molecule root) {
        String val;
        String xp = root.getXPathName();
        if (xp != null && (val = xp).length() > 0) {
            if (m_paths.contains(val)) {
                return;
            }
            m_paths.add(val);
            m_nodes.put(val, root);
        }
        for (int c = 0; c < root.getChildCount(); ++c) {
            Atom child = root.getChildren().get(c);
            if (!(child instanceof Molecule)) continue;
            MapSchemaComparator.getValidPaths((Molecule)child);
        }
    }

    private static void compareMap(Map map, ArrayList<ValidationIssue> issues) {
        for (int t = 0; t < map.getTableCount(); ++t) {
            Table tab = map.getTable(t);
            if (!MapSchemaComparator.validPath(tab.getXPath(), m_paths)) {
                String msg = MessageFormat.format(res.getString("VMsgSchemaTablePathNoSynch.txt"), tab.getName());
                ValidationIssue vi = new ValidationIssue(4, msg, tab);
                issues.add(vi);
            }
            for (int c = 0; c < tab.getColumnCount(); ++c) {
                ValidationIssue vi;
                String msg;
                Column col = tab.getColumn(c);
                if (col.isOrdinal()) continue;
                XPath xpc = col.getXPath();
                if (!MapSchemaComparator.validPath(col.getXPath(), m_paths)) {
                    String msg2 = MessageFormat.format(res.getString("VMsgSchemaColumnPathNoSynch.txt"), col.getName());
                    ValidationIssue vi2 = new ValidationIssue(4, msg2, col);
                    issues.add(vi2);
                    continue;
                }
                String path = xpc.getValue();
                if (path == null || path.length() == 0) continue;
                Isomer node = (Isomer)m_nodes.get(path);
                if (node.getDatatype() != col.getDatatype() && node.getDatatype() != 0) {
                    msg = MessageFormat.format(res.getString("VMsgSchemaDatatypeMismatch.txt"), col.getName(), tab.getName());
                    vi = new ValidationIssue(4, msg, col);
                    issues.add(vi);
                    continue;
                }
                if (node.getLength() == col.getLength() || node.getLength() == 0) continue;
                msg = MessageFormat.format(res.getString("VMsgSchemaLengthMismatch.txt"), col.getName(), tab.getName());
                vi = new ValidationIssue(4, msg, col);
                issues.add(vi);
            }
        }
    }

    private static boolean validPath(XPath path, ArrayList<String> paths) {
        if (path == null || path.getValue() == null || path.getValue().length() < 1) {
            return true;
        }
        String xpv = path.getValue();
        for (int i = 0; i < paths.size(); ++i) {
            String p = paths.get(i);
            if (xpv.compareTo(p) != 0) continue;
            return true;
        }
        return false;
    }
}

