/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sxle.map;

import com.sas.sxle.map.Cartographer;
import com.sas.sxle.map.Cartographer_2_1;
import com.sas.sxle.map.ExtendedSAXParser;
import com.sas.sxle.map.Logger;
import com.sas.sxle.map.Map;
import com.sas.sxle.map.MapParserVS;
import com.sas.sxle.map.MapTreeModel;
import com.sas.sxle.map.ModelBundle;
import com.sas.sxle.map.Tuple;
import com.sas.sxle.map.XMLFile;
import com.sas.sxle.map.XMLMetaTreeModel;
import com.sas.sxle.map.XMLTreeModel;
import com.sas.sxle.map.XSDParser;
import com.sas.sxle.map.XSDTreeModel;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MapModelBuilder {
    static ResourceBundle res = ResourceBundle.getBundle("com.sas.sxle.map.Resources");
    private static Cartographer cart21 = new Cartographer_2_1();

    private MapModelBuilder() {
    }

    public static int readXML(XMLFile file, ModelBundle bundle) {
        ExtendedSAXParser parser = new ExtendedSAXParser();
        String encoding = "";
        parser.parse(file);
        int status = parser.getStatus();
        encoding = parser.getEncoding();
        if (status != 0 && status > 1) {
            bundle.clear();
            bundle.setStatus(status);
            return status;
        }
        XMLTreeModel xmlTreeM = new XMLTreeModel(parser.getRoot());
        XMLMetaTreeModel metaTreeM = new XMLMetaTreeModel(parser.getMetaRoot());
        bundle.setXMLTreeModel(xmlTreeM);
        bundle.setXMLMetaTreeModel(metaTreeM);
        bundle.setXMLEncoding(encoding);
        bundle.setNamespaces(parser.getNamespaces());
        return status;
    }

    public static int readXSD(XMLFile file, ModelBundle bundle) {
        XSDParser parser = new XSDParser();
        XSDTreeModel model = parser.parse(file);
        bundle.clear();
        if (model == null) {
            bundle.setStatus(3);
            return 3;
        }
        bundle.setXSDTreeModel(model);
        bundle.setNamespaces(parser.getNamespaces());
        return 0;
    }

    public static int readMap(XMLFile file, ModelBundle bundle) {
        bundle.clear();
        MapParserVS parser = new MapParserVS();
        try {
            parser.parse(file);
        }
        catch (IOException ex) {
            bundle.setStatus(3);
            String uri = file.toURI().toASCIIString();
            ArrayList<Tuple> details = new ArrayList<Tuple>();
            details.add(new Tuple("File", uri));
            details.add(new Tuple("Exception class", ex.getClass().getName()));
            details.add(new Tuple("Message", ex.getLocalizedMessage()));
            String msg = MessageFormat.format(res.getString("MsgErrBadMap.txt"), uri);
            Logger.log(msg, details, 1);
        }
        catch (SAXException e) {
            bundle.setStatus(3);
            String uri = file.toURI().toASCIIString();
            ArrayList<Tuple> details = new ArrayList<Tuple>();
            details.add(new Tuple("Exception class", e.getClass().getName()));
            details.add(new Tuple("Message", e.getLocalizedMessage()));
            if (e instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)e;
                details.add(new Tuple("ID", spe.getPublicId()));
                details.add(new Tuple("Line", Integer.toString(spe.getLineNumber())));
                details.add(new Tuple("Column", Integer.toString(spe.getColumnNumber())));
            }
            String msg = MessageFormat.format(res.getString("MsgErrBadMap.txt"), uri);
            Logger.log(msg, details, 1);
        }
        if (parser.getMap() == null) {
            bundle.setStatus(2);
        } else {
            parser.getMap().setVersion(4);
            bundle.setMapTreeModel(new MapTreeModel(parser.getMap()));
        }
        return bundle.getStatus();
    }

    public static int readOMR(ModelBundle bundle) {
        bundle.clear();
        bundle.setStatus(3);
        return 3;
    }

    public static String genMapText(Map map, boolean validate) {
        switch (map.getVersionID()) {
            case 4: {
                return cart21.buildMap(map, validate);
            }
        }
        return null;
    }

    public static int writeMap(String dest, Map map) throws IOException {
        switch (map.getVersionID()) {
            case 4: {
                cart21.saveMap(map, true, dest);
            }
        }
        return 0;
    }

    public static int writeOMR(Map map) {
        return 0;
    }
}

