/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sxle.map;

import com.sas.sxle.map.SASName;
import java.util.ArrayList;
import java.util.ResourceBundle;

public class Format {
    static ResourceBundle res = ResourceBundle.getBundle("com.sas.sxle.map.Resources");
    public static final int kF_$ = 0;
    public static final int kF_$CHAR = 1;
    public static final int kF_BEST = 2;
    public static final int kF_F = 3;
    public static final int kF_DATE = 4;
    public static final int kF_DATETIME = 5;
    public static final int kF_HHMM = 6;
    public static final int kF_IS8601DA = 7;
    public static final int kF_IS8601DT = 8;
    public static final int kF_IS8601TM = 9;
    public static final int kF_mmddyy = 10;
    public static final int kF_SASANYDTDTE = 11;
    public static final int kF_SASANYDTDTM = 12;
    public static final int kF_SASANYDTTME = 13;
    public static final int kF_DOLLAR = 14;
    public static final int kF_ND8601DA = 15;
    public static final int kF_ND8601DT = 16;
    public static final int kF_ND8601TM = 17;
    public static final Format[] STOCKFORMATS = new Format[]{new Format("$", -1, 0), new Format("$CHAR", -1, 0), new Format("BEST", 12, 0), new Format("F", 12, 2), new Format("DATE", 9, 0), new Format("DATETIME", 18, 0), new Format("HHMM", 5, 0), new Format("IS8601DA", 10, 0), new Format("IS8601DT", 19, 0), new Format("IS8601TM", 8, 0), new Format("MMDDYY", 8, 0), new Format("IS8601DA", 10, 0), new Format("IS8601DT", 19, 0), new Format("IS8601TM", 8, 0), new Format("DOLLAR", 12, 2), new Format("IS8601DA", 10, 0), new Format("IS8601DT", 19, 0), new Format("IS8601TM", 8, 0)};
    public static final Format[] BASEFORMATS = new Format[]{STOCKFORMATS[1], STOCKFORMATS[2], STOCKFORMATS[3], STOCKFORMATS[4], STOCKFORMATS[5], STOCKFORMATS[6], STOCKFORMATS[7], STOCKFORMATS[8], STOCKFORMATS[9]};
    public static final Format[] STOCKINFORMATS = new Format[]{new Format("$", -1, 0), new Format("$CHAR", -1, 0), new Format("BEST", 12, 0), new Format("F", 12, 2), new Format("DATE", 9, 0), new Format("DATETIME", 18, 0), new Format("HHMM", 5, 0), new Format("IS8601DA", 10, 0), new Format("IS8601DT", 19, 0), new Format("IS8601TM", 8, 0), new Format("MMDDYY", 10, 0), new Format("ANYDTDTE", 18, 0), new Format("ANYDTDTM", 28, 0), new Format("ANYDTTME", 8, 0), new Format("DOLLAR", 12, 2), new Format("ND8601DA", 8, 0), new Format("ND8601DT", 12, 0), new Format("ND8601TM", 6, 0)};
    private int m_length;
    private int m_nDec;
    private String m_name;
    public static ArrayList<Format> CUSTOMFORMATS = new ArrayList();
    public static ArrayList<Format> CUSTOMINFORMATS = new ArrayList();

    public Format() {
    }

    public Format(String name) {
        this.setName(name);
    }

    public Format(Format fmt) {
        assert (fmt != null);
        this.m_length = fmt.m_length;
        this.m_nDec = fmt.m_nDec;
        this.m_name = fmt.m_name == null ? null : new String(fmt.m_name);
    }

    public Format(String name, int len, int nDec) {
        this.setName(name);
        this.m_length = len;
        this.m_nDec = nDec;
    }

    public static boolean isStockFormat(Format fmt) {
        for (int f = 0; f < STOCKFORMATS.length; ++f) {
            if (fmt.m_name.compareToIgnoreCase(Format.STOCKFORMATS[f].m_name) != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isCustomFormat(Format fmt) {
        for (int f = 0; f < CUSTOMFORMATS.size(); ++f) {
            if (fmt.m_name.compareToIgnoreCase(Format.CUSTOMFORMATS.get((int)f).m_name) != 0) continue;
            return true;
        }
        return false;
    }

    public static Format getStockFormat(String name) {
        for (int f = 0; f < STOCKFORMATS.length; ++f) {
            if (name.compareToIgnoreCase(STOCKFORMATS[f].getName()) != 0) continue;
            return STOCKFORMATS[f];
        }
        return null;
    }

    public static boolean isStockInformat(Format fmt) {
        for (int f = 0; f < STOCKINFORMATS.length; ++f) {
            if (fmt.m_name.compareToIgnoreCase(Format.STOCKINFORMATS[f].m_name) != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isCustomInformat(Format fmt) {
        for (int f = 0; f < CUSTOMINFORMATS.size(); ++f) {
            if (fmt.m_name.compareToIgnoreCase(Format.CUSTOMINFORMATS.get((int)f).m_name) != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isKnownFormat(Format fmt) {
        return Format.isStockFormat(fmt) || Format.isCustomFormat(fmt);
    }

    public static boolean isKnownInformat(Format inf) {
        return Format.isStockInformat(inf) || Format.isCustomInformat(inf);
    }

    public static Format getStockInformat(String name) {
        for (int f = 0; f < STOCKINFORMATS.length; ++f) {
            if (name.compareToIgnoreCase(STOCKINFORMATS[f].getName()) != 0) continue;
            return STOCKINFORMATS[f];
        }
        return null;
    }

    public static Format getKnownFormat(String name) {
        Format f = Format.getStockFormat(name);
        if (f != null) {
            return f;
        }
        return Format.getCustomFormat(name);
    }

    public static Format getKnownInformat(String name) {
        Format f = Format.getStockInformat(name);
        if (f != null) {
            return f;
        }
        return Format.getCustomInformat(name);
    }

    public static Format getCustomFormat(String name) {
        for (int f = 0; f < CUSTOMFORMATS.size(); ++f) {
            if (name.compareToIgnoreCase(CUSTOMFORMATS.get(f).getName()) != 0) continue;
            return CUSTOMFORMATS.get(f);
        }
        return null;
    }

    public static Format getCustomInformat(String name) {
        for (int f = 0; f < CUSTOMINFORMATS.size(); ++f) {
            if (name.compareToIgnoreCase(CUSTOMINFORMATS.get(f).getName()) != 0) continue;
            return CUSTOMINFORMATS.get(f);
        }
        return null;
    }

    public int getLength() {
        return this.m_length;
    }

    public String getName() {
        return this.m_name;
    }

    public int getNDec() {
        return this.m_nDec;
    }

    public void setLength(int length) {
        this.m_length = length;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setNDec(int nDec) {
        this.m_nDec = nDec;
    }

    public String toString() {
        return this.fullName();
    }

    public String fullName() {
        return this.m_name;
    }

    public boolean isValid() {
        if (Format.isStockFormat(this)) {
            return true;
        }
        return SASName.isValid(this.m_name, 2);
    }
}

