/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sxle.map;

import com.sas.sxle.map.LogItem;
import com.sas.sxle.map.Logger;
import com.sas.sxle.map.Molecule;
import com.sas.sxle.map.Namespace;
import com.sas.sxle.map.NamespaceList;
import com.sas.sxle.map.Polymer;
import com.sas.sxle.map.SXLEContext;
import com.sas.sxle.map.Tuple;
import com.sas.sxle.map.XMLFile;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.Vector;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.util.SecurityManager;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.XNIException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class ExtendedSAXParser
extends SAXParser
implements ContentHandler,
LexicalHandler,
DeclHandler,
DTDHandler,
ErrorHandler {
    public static final int kVL_HIGH = 10;
    public static final int kVL_MINIMAL = 1;
    public static final int kVL_NONE = 2;
    private boolean conserveMemMode = false;
    private static ResourceBundle res = ResourceBundle.getBundle("com.sas.sxle.map.Resources");
    private Stack<Molecule> context = new Stack();
    private Stack<Polymer> metaContext = new Stack();
    private Stack<Namespace> nsContext = new Stack();
    private final Vector<Namespace> nsiContext = new Vector();
    private NamespaceList m_namespaces = new NamespaceList();
    private String m_encoding = "";
    private boolean m_skippedEntity = false;
    private int m_status = 0;
    private boolean bailOut = false;
    private Molecule m_root;
    private Polymer m_metaRoot;
    private long elements;
    private long attributes;
    private long characters;
    private long ignorableWhitespace;

    public Molecule getRoot() {
        return this.m_root;
    }

    public Polymer getMetaRoot() {
        return this.m_metaRoot;
    }

    public ExtendedSAXParser() {
        this.setContentHandler(this);
        this.setDTDHandler(this);
        this.setErrorHandler(this);
        try {
            SecurityManager sm = new SecurityManager();
            sm.setEntityExpansionLimit(0);
            switch (SXLEContext.validationLevel()) {
                case 1: {
                    Logger.log(res.getString("MsgParseValLevelMin.txt"), 3);
                    this.setFeature("http://xml.org/sax/features/validation", true);
                    this.setFeature("http://apache.org/xml/features/validation/schema", true);
                    this.setFeature("http://apache.org/xml/features/validation/dynamic", true);
                    this.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
                    this.setFeature("http://apache.org/xml/features/standard-uri-conformant", true);
                    this.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                    this.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    this.setProperty("http://apache.org/xml/properties/security-manager", sm);
                    break;
                }
                case 2: {
                    if (!SXLEContext.isLocal()) {
                        Logger.log(res.getString("MsgParseValLevelOff.txt"), 3);
                    }
                    this.setFeature("http://xml.org/sax/features/validation", false);
                    this.setFeature("http://apache.org/xml/features/validation/schema", false);
                    this.setFeature("http://apache.org/xml/features/validation/dynamic", false);
                    this.setFeature("http://apache.org/xml/features/validation/schema-full-checking", false);
                    this.setFeature("http://apache.org/xml/features/standard-uri-conformant", false);
                    this.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                    this.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    this.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                    this.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                    this.setProperty("http://apache.org/xml/properties/security-manager", sm);
                    break;
                }
                default: {
                    ArrayList<Tuple> details = new ArrayList<Tuple>();
                    details.add(new Tuple(res.getString("MsgExMsg.txt"), res.getString("MsgParseValLevelHighWarn1.txt")));
                    details.add(new Tuple(res.getString("MsgExMsg.txt"), res.getString("MsgParseValLevelHighWarn2.txt")));
                    Logger.log(res.getString("MsgParseValLevelHigh.txt"), details, 2);
                    this.setFeature("http://xml.org/sax/features/validation", true);
                    this.setFeature("http://apache.org/xml/features/validation/schema", true);
                    this.setFeature("http://apache.org/xml/features/validation/dynamic", true);
                    this.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
                    this.setFeature("http://apache.org/xml/features/standard-uri-conformant", true);
                }
            }
            this.setDeclHandler(this);
            this.setLexicalHandler(this);
        }
        catch (SAXNotRecognizedException e) {
            this.bailOut = true;
        }
        catch (SAXNotSupportedException e) {
            this.bailOut = true;
        }
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public void parse(XMLFile f) {
        this.context.clear();
        if (!this.conserveMemMode) {
            this.metaContext.clear();
        }
        this.m_root = new Molecule();
        this.m_root.setName("");
        this.m_root.setType(0);
        this.context.push(this.m_root);
        this.m_skippedEntity = false;
        String uri = "";
        String path = f.getAbsolutePath();
        try {
            uri = f.toURI().toASCIIString();
            InputSource source = new InputSource(uri);
            source.setSystemId(uri);
            super.parse(source);
            if (this.m_skippedEntity) {
                Logger.log(res.getString("MsgParseSkippedEntity.txt"), 2);
            }
        }
        catch (IOException ex) {
            this.m_status |= 2;
            ArrayList<Tuple> details = new ArrayList<Tuple>();
            details.add(new Tuple(res.getString("MsgExClass.txt"), ex.getClass().getName()));
            details.add(new Tuple(res.getString("MsgExMsg.txt"), ex.getLocalizedMessage()));
            String msg = MessageFormat.format(res.getString("MsgErrParseErr.txt"), path);
            Logger.log(new LogItem(msg, details, 1));
        }
        catch (SAXException ex) {
            this.m_status |= 2;
            ArrayList<Tuple> details = new ArrayList<Tuple>();
            details.add(new Tuple(res.getString("MsgExClass.txt"), ex.getClass().getName()));
            String msg = MessageFormat.format(res.getString("MsgErrParseErr.txt"), path);
            Logger.log(new LogItem(msg, details, 1));
        }
        catch (OutOfMemoryError ex) {
            this.m_status |= 3;
            ArrayList<Tuple> details = new ArrayList<Tuple>();
            details.add(new Tuple(res.getString("MsgExClass.txt"), ex.getClass().getName()));
            String msg = MessageFormat.format(res.getString("MsgErrParseErr.txt"), path);
            Logger.log(new LogItem(msg, details, 1));
        }
    }

    public int getStatus() {
        return this.m_status;
    }

    @Override
    public void startDocument() {
        if (this.bailOut) {
            return;
        }
        this.m_status = 0;
        this.elements = 0L;
        this.attributes = 0L;
        this.characters = 0L;
        this.ignorableWhitespace = 0L;
    }

    @Override
    public void endDocument() {
        this.nsiContext.clear();
        if (this.bailOut) {
            return;
        }
    }

    @Override
    public void startElement(String uri, String lname, String qname, Attributes attrs) {
        int col;
        String pre;
        Namespace ns;
        if (this.bailOut) {
            return;
        }
        String eleName = lname;
        if (eleName == null || eleName.length() < 1) {
            eleName = qname;
        }
        if (eleName == null || eleName.length() < 1) {
            eleName = "Element";
        }
        ++this.elements;
        Molecule mol = new Molecule();
        if (uri != null && (ns = this.findMRUMatchingNamespaceUri(pre = (col = (pre = qname) != null ? pre.indexOf(58) : 0) > 0 ? pre.substring(0, col) : "", uri)) != null) {
            mol.setNamespace(ns);
        }
        mol.setName(eleName);
        Molecule molContext = null;
        if (this.context.isEmpty()) {
            this.m_root = mol;
        } else {
            molContext = this.context.peek();
            if (!this.conserveMemMode) {
                molContext.addChild(mol);
            }
        }
        if (attrs.getLength() > 0) {
            mol.addAttributes(attrs, this);
        }
        this.context.push(mol);
        Polymer polyContext = null;
        Polymer p = null;
        if (this.metaContext.isEmpty()) {
            this.m_metaRoot = p = new Polymer(mol);
        } else {
            polyContext = this.metaContext.peek();
            p = polyContext.tryAddChild(mol);
        }
        p.addAttributes(attrs, this);
        this.attributes += (long)attrs.getLength();
        p.setAccumulate(true);
        this.metaContext.push(p);
    }

    @Override
    public void endElement(String uri, String lname, String qname) {
        if (this.bailOut) {
            return;
        }
        Molecule mc = this.context.pop();
        mc.setAccumulate(false);
        Polymer pc = this.metaContext.pop();
        pc.setAccumulate(false);
        pc.tryAddSample(mc.getValue());
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.bailOut) {
            return;
        }
        String val = new String(ch, start, length);
        this.characters += (long)length;
        boolean startWS = false;
        if (length > 0) {
            startWS = Character.isWhitespace(val.charAt(0));
        }
        boolean endWS = false;
        if (length > 2 || length > 1 && !startWS) {
            endWS = Character.isWhitespace(val.charAt(length - 1));
        }
        val = val.trim();
        if (startWS) {
            val = " " + val;
        }
        if (endWS) {
            val = val + " ";
        }
        Molecule mc = this.context.peek();
        if (val.length() > 0) {
            mc.setValue(val);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
        if (this.bailOut) {
            return;
        }
        String val = new String(ch, start, length);
        this.ignorableWhitespace += (long)length;
    }

    private ArrayList<Tuple> saxExceptionDetail(SAXParseException ex) {
        ArrayList<Tuple> details = new ArrayList<Tuple>();
        details.add(new Tuple(res.getString("MsgExClass.txt"), ex.getClass().getName()));
        details.add(new Tuple(res.getString("MsgExID.txt"), ex.getPublicId()));
        details.add(new Tuple(res.getString("MsgExMsg.txt"), ex.getLocalizedMessage()));
        details.add(new Tuple(res.getString("MsgExLine.txt"), Integer.toString(ex.getLineNumber())));
        details.add(new Tuple(res.getString("MsgExColumn.txt"), Integer.toString(ex.getColumnNumber())));
        return details;
    }

    @Override
    public void warning(SAXParseException ex) {
        if (this.bailOut) {
            return;
        }
        this.m_status |= 1;
        ArrayList<Tuple> details = this.saxExceptionDetail(ex);
        Logger.log(res.getString("MsgExXMLWarn.txt"), details, 2);
    }

    @Override
    public void error(SAXParseException ex) {
        if (this.bailOut) {
            return;
        }
        this.m_status |= 2;
        ArrayList<Tuple> details = this.saxExceptionDetail(ex);
        Logger.log(res.getString("MsgExXMLErr.txt"), details, 1);
        this.bailOut = true;
    }

    @Override
    public void fatalError(SAXParseException ex) {
        if (this.bailOut) {
            return;
        }
        this.m_status |= 3;
        ArrayList<Tuple> details = this.saxExceptionDetail(ex);
        Logger.log(res.getString("MsgExXMLFatal.txt"), details, 1);
        this.bailOut = true;
    }

    @Override
    public void comment(char[] ch, int start, int length) {
        if (this.bailOut) {
            return;
        }
        String val = new String(ch, start, length);
        Molecule m = new Molecule();
        m.setName("comment");
        m.setValue(val.trim());
        m.setType(4);
        Molecule mc = this.context.peek();
        if (!this.conserveMemMode) {
            mc.addChild(m);
        }
    }

    @Override
    public void endCDATA() {
        if (this.bailOut) {
            return;
        }
    }

    @Override
    public void endDTD() {
        if (this.bailOut) {
            return;
        }
        this.context.pop();
    }

    @Override
    public void endEntity(String name) {
        if (this.bailOut) {
            return;
        }
    }

    @Override
    public void startCDATA() {
        if (this.bailOut) {
            return;
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) {
        if (this.bailOut) {
            return;
        }
        Molecule m = new Molecule();
        m.setName("DTD");
        m.setValue(systemId);
        m.setType(3);
        Molecule mc = this.context.peek();
        if (!this.conserveMemMode) {
            mc.addChild(m);
        }
        this.context.push(m);
    }

    @Override
    public void startEntity(String name) {
        if (this.bailOut) {
            return;
        }
    }

    @Override
    public void endPrefixMapping(String prefix) {
        if (this.bailOut) {
            return;
        }
        this.nsContext.pop();
    }

    @Override
    public void processingInstruction(String target, String data) {
        if (this.bailOut) {
            return;
        }
        Molecule m = new Molecule();
        m.setName(target);
        m.setValue(data.trim());
        m.setType(5);
        Molecule mc = this.context.peek();
        if (!this.conserveMemMode) {
            mc.addChild(m);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) {
        if (this.bailOut) {
            return;
        }
        this.m_skippedEntity = true;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        if (this.bailOut) {
            return;
        }
        try {
            Namespace ns = new Namespace(prefix, uri);
            this.m_namespaces.add(ns);
            this.nsContext.push(ns);
        }
        catch (IllegalArgumentException ex) {
            this.m_status |= 2;
            ArrayList<Tuple> details = new ArrayList<Tuple>();
            details.add(new Tuple(res.getString("MsgExClass.txt"), ex.getClass().getName()));
            details.add(new Tuple(res.getString("MsgExMsg.txt"), ex.getLocalizedMessage()));
            String msg = MessageFormat.format(res.getString("MsgErrParseErr.txt"), uri);
            Logger.log(new LogItem(msg, details, 1));
        }
    }

    public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) throws XNIException {
        if (this.bailOut) {
            return;
        }
        Molecule m = new Molecule();
        m.setType(2);
        m.setName("XML");
        m.setDescription("XML Declaration element");
        if (version != null) {
            Molecule mv = new Molecule();
            mv.setName("version");
            mv.setValue(version);
            mv.setType(7);
            if (!this.conserveMemMode) {
                m.addChild(mv);
            }
        }
        if (encoding != null) {
            Molecule me = new Molecule();
            me.setName("encoding");
            me.setValue(encoding);
            me.setType(7);
            if (!this.conserveMemMode) {
                m.addChild(me);
            }
        }
        this.m_encoding = encoding;
        if (standalone != null) {
            Molecule ms = new Molecule();
            ms.setName("standalone");
            ms.setValue(standalone);
            ms.setType(7);
            if (!this.conserveMemMode) {
                m.addChild(ms);
            }
        }
        Molecule mc = this.context.peek();
        if (!this.conserveMemMode) {
            mc.addChild(m);
        }
    }

    public void debugDump(String uri) {
    }

    @Override
    public void notationDecl(String name, String publicID, String systemID) {
        Molecule m = new Molecule();
        m.setName(name);
        m.setValue(systemID);
        m.setType(2);
        Molecule mc = this.context.peek();
        if (!this.conserveMemMode) {
            mc.addChild(m);
        }
    }

    @Override
    public void unparsedEntityDecl(String name, String publicID, String systemID, String notationName) {
    }

    @Override
    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) {
        Molecule m = new Molecule();
        m.setName(aName);
        if (value == null || value.length() < 1) {
            m.setValue(valueDefault);
        } else {
            m.setValue(value);
        }
        m.setType(4);
        Molecule mc = this.context.peek();
        if (!this.conserveMemMode) {
            mc.addChild(m);
        }
    }

    @Override
    public void elementDecl(String name, String model) {
        Molecule m = new Molecule();
        m.setName(name);
        m.setValue(model);
        m.setType(4);
        Molecule mc = this.context.peek();
        if (!this.conserveMemMode) {
            mc.addChild(m);
        }
    }

    @Override
    public void externalEntityDecl(String name, String publicId, String systemId) {
        Molecule m = new Molecule();
        m.setName(name);
        m.setValue(systemId);
        m.setType(4);
        Molecule mc = this.context.peek();
        if (!this.conserveMemMode) {
            mc.addChild(m);
        }
    }

    @Override
    public void internalEntityDecl(String name, String value) {
        Molecule m = new Molecule();
        m.setName(name);
        m.setValue(value);
        m.setType(4);
        Molecule mc = this.context.peek();
        if (!this.conserveMemMode) {
            mc.addChild(m);
        }
    }

    public NamespaceList getNamespaces() {
        return this.m_namespaces;
    }

    private Namespace findMRUMatchingNamespaceUri(String prefix, String uri) {
        if (uri == null) {
            return null;
        }
        for (int idx = this.nsContext.size() - 1; idx >= 0; --idx) {
            Namespace cns = (Namespace)this.nsContext.get(idx);
            if (!uri.equals(cns.getURI())) continue;
            return cns;
        }
        return this.findImplicitMatchingNamespace(prefix, uri);
    }

    public Namespace findMRUMatchingNamespace(String prefix, String uri) {
        if (uri == null) {
            return null;
        }
        for (int idx = this.nsContext.size() - 1; idx >= 0; --idx) {
            Namespace cns = (Namespace)this.nsContext.get(idx);
            boolean preOK = true;
            preOK = prefix == null ? cns.getPrefix() == null : prefix.equals(cns.getPrefix());
            if (!preOK || !uri.equals(cns.getURI())) continue;
            return cns;
        }
        return this.findImplicitMatchingNamespace(prefix, uri);
    }

    private Namespace findImplicitMatchingNamespace(String prefix, String uri) {
        if (uri == null || uri.trim().length() == 0) {
            return null;
        }
        for (Namespace cns : this.nsiContext) {
            if (!uri.equals(cns.getURI())) continue;
            return cns;
        }
        Namespace ns = new Namespace(prefix, uri);
        this.nsiContext.add(ns);
        this.m_namespaces.add(ns);
        return ns;
    }
}

