/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sxle.map;

import com.sas.sxle.map.Atom;
import com.sas.sxle.map.Column;
import com.sas.sxle.map.Datatype;
import com.sas.sxle.map.DefaultSortTableModel;
import com.sas.sxle.map.Format;
import com.sas.sxle.map.Map;
import com.sas.sxle.map.MapTableModel;
import com.sas.sxle.map.ModelBundle;
import com.sas.sxle.map.Molecule;
import com.sas.sxle.map.Table;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;

public class Engine {
    protected static ResourceBundle res = ResourceBundle.getBundle("com.sas.sxle.map.Resources");
    private ArrayList<Atom> m_cols;
    private ArrayList<Object> m_rowset;
    private ArrayList<Object> m_colbuff;
    private ArrayList<Object> m_currentRow;
    private String m_tablePath;
    private String m_tableEndPath;
    private String m_filename;
    private String m_filePath;
    private boolean m_bailOut;
    private boolean m_tableEndPathIsBegin;
    private boolean[] m_replace;
    private boolean m_820mode = false;
    private static String m_kNA = res.getString("LabelNotApplicable.txt");
    private Map m_map;
    private ModelBundle m_model;

    public DefaultSortTableModel buildContentsModel(Map map, int table) {
        this.m_map = map;
        Table t = map.getTable(table);
        DefaultSortTableModel dstm = new DefaultSortTableModel();
        if (t == null) {
            return dstm;
        }
        Vector<String> names = new Vector<String>();
        Vector<String> types = new Vector<String>();
        Vector<Integer> lengths = new Vector<Integer>();
        Vector<String> formats = new Vector<String>();
        Vector<String> informats = new Vector<String>();
        Vector<String> labels = new Vector<String>();
        for (int c = 0; c < t.getChildCount(); ++c) {
            Column col = t.getColumn(c);
            names.add(col.getName());
            types.add(Column.TYPE[col.getType()]);
            int len = col.getType() == 0 ? col.getLength() : 8;
            lengths.add(new Integer(len));
            Format fmt = col.getFormat();
            formats.add(fmt == null ? "" : fmt.fullName());
            Format inf = col.getInformat();
            informats.add(inf == null ? "" : inf.fullName());
            labels.add(col.getDescription());
        }
        dstm.addColumn((Object)res.getString("LabelContentsName.txt"), names);
        dstm.addColumn((Object)res.getString("LabelContentsType.txt"), types);
        dstm.addColumn((Object)res.getString("LabelContentsLength.txt"), lengths);
        dstm.addColumn((Object)res.getString("LabelContentsFormat.txt"), formats);
        dstm.addColumn((Object)res.getString("LabelContentsInformat.txt"), informats);
        dstm.addColumn((Object)res.getString("LabelContentsLabel.txt"), labels);
        return dstm;
    }

    public MapTableModel buildTableModel(Map map, ModelBundle model, Molecule root, int table, String filename, String filepath) {
        this.m_map = map;
        this.m_model = model;
        if (table < 0 || table >= map.getTableCount()) {
            return new MapTableModel();
        }
        this.m_filename = filename == null ? m_kNA : filename;
        this.m_filePath = filepath == null ? m_kNA : filepath;
        this.m_bailOut = false;
        this.m_rowset = new ArrayList();
        this.m_colbuff = new ArrayList();
        this.m_currentRow = null;
        Table t = map.getTable(table);
        if (t == null) {
            return new MapTableModel();
        }
        this.m_cols = t.getColumns();
        if (this.m_cols == null || this.m_cols.size() == 0) {
            return new MapTableModel();
        }
        this.m_tablePath = t.getXPath().getValue();
        this.m_tableEndPath = null;
        this.m_tableEndPathIsBegin = false;
        if (t.getOptXPath() != null) {
            this.m_tableEndPath = t.getOptXPath().getValue();
            this.m_tableEndPathIsBegin = t.getOptXPath().getBeginEnd() == 0;
        }
        this.setupBuffer(t);
        this.scan(root, false);
        this.postScanEnumeration();
        this.m_colbuff = null;
        return new MapTableModel(this.m_rowset, this.m_cols, t.getName());
    }

    private boolean matchPath(String current, String ref) {
        current = this.m_model.getNamespaces().expandPath(current);
        ref = this.m_map.getNamespaces().expandPath(ref);
        if (current == null || ref == null || ref.length() == 0) {
            return false;
        }
        if (ref.length() >= 2 && ref.substring(0, 2).compareTo("//") == 0) {
            ref = ref.substring(2);
        }
        if (ref.length() == 0) {
            return true;
        }
        if (ref.charAt(0) == '/') {
            return current.compareTo(ref) == 0;
        }
        return current.endsWith(ref);
    }

    private void setupBuffer(Table t) {
        this.m_replace = new boolean[t.getChildCount()];
        for (int c = 0; c < t.getChildCount(); ++c) {
            this.m_replace[c] = true;
            Column col = t.getColumn(c);
            if (col.isOrdinal()) {
                this.m_colbuff.add(new Integer(0));
                continue;
            }
            this.m_colbuff.add("");
        }
    }

    private void debugDump() {
        for (int r = 0; r < this.m_rowset.size(); ++r) {
            ArrayList row = (ArrayList)this.m_rowset.get(r);
            for (int c = 0; c < row.size(); ++c) {
                if (c > 0) {
                    System.out.print(", ");
                }
                System.out.print(row.get(c));
            }
            System.out.println("");
        }
    }

    private void scan(Molecule parent, boolean inRow) {
        boolean foundTab;
        String path = parent.getXPathName();
        if (this.m_bailOut || this.m_tableEndPathIsBegin && this.m_tableEndPath != null && this.matchPath(path, this.m_tableEndPath)) {
            this.m_bailOut = true;
            return;
        }
        boolean bl = foundTab = this.matchPath(path, this.m_tablePath) && parent.getType() != 6;
        if (foundTab) {
            this.newRow();
            this.scanOrdinals(true, parent, inRow, path);
        } else {
            this.scanOrdinals(true, parent, inRow, path);
        }
        if (parent.getType() != 6) {
            this.scanColumns(parent, inRow || foundTab, path);
        }
        for (int c = 0; c < parent.getChildCount(); ++c) {
            Atom child = parent.getChildren().get(c);
            if (!(child instanceof Molecule)) continue;
            this.scan((Molecule)child, inRow || foundTab);
        }
        if (inRow || foundTab) {
            this.updateRow();
        }
        this.scanOrdinals(false, parent, inRow || foundTab, path);
        if (this.m_bailOut || !this.m_tableEndPathIsBegin && this.m_tableEndPath != null && this.matchPath(path, this.m_tableEndPath)) {
            this.m_bailOut = true;
        }
    }

    private void scanColumns(Molecule parent, boolean inRow, String path) {
        for (int c = 0; c < this.m_colbuff.size(); ++c) {
            Column col = (Column)this.m_cols.get(c);
            if (col.isOrdinal()) continue;
            if (col.isFilename()) {
                this.m_colbuff.set(c, this.m_filename);
                continue;
            }
            if (col.isFilePath()) {
                this.m_colbuff.set(c, this.m_filePath);
                continue;
            }
            String cp = col.getXPath().getValue();
            boolean matched = this.matchPath(path, cp);
            if (!matched) continue;
            boolean passed = this.checkCondition(parent, col);
            if (passed) {
                if (this.m_820mode && !this.m_replace[c] && !col.isRetained() && this.m_colbuff.get(c) != null) {
                    this.m_colbuff.set(c, this.m_colbuff.get(c) + " " + parent.getValue());
                } else {
                    String munged = this.munge8601(parent.getValue(), col);
                    if (munged != null && munged.length() > 0 || !col.isRetained()) {
                        this.m_colbuff.set(c, munged);
                    }
                }
                if (inRow) {
                    this.m_currentRow.set(c, this.m_colbuff.get(c));
                }
            }
            if (inRow) continue;
            this.m_replace[c] = false;
        }
    }

    private String munge8601(String val, Column col) {
        int dtOut = col.getDatatype();
        int dtIn = Datatype.bestMatch(val);
        if (dtIn == dtOut) {
            return val;
        }
        String v = val;
        if (dtOut == 4) {
            if (dtIn != 5) {
                return "";
            }
            v = val.substring(0, val.indexOf(84));
        } else if (dtOut == 6) {
            if (dtIn != 5) {
                return "";
            }
            v = val.substring(val.indexOf(84) + 1);
        }
        return v;
    }

    private boolean checkCondition(Molecule item, Column col) {
        if (!col.hasCondition()) {
            return true;
        }
        if (col.getXPath() == null || col.getXPath().getValue().length() < 1) {
            return false;
        }
        if (col.getCondType() == 1) {
            Molecule attrGrp = item.getType() == 7 ? (Molecule)item.getParent() : (Molecule)item.getChildNamed("Attributes");
            if (attrGrp == null || attrGrp.getType() != 6) {
                return false;
            }
            Molecule attr = (Molecule)attrGrp.getChildNamed(col.getCondAttribute());
            if (attr == null || col.getCondValue() == null || attr.getValue() == null) {
                return false;
            }
            String av = attr.getValue();
            if (av == null) {
                return false;
            }
            return av.compareTo(col.getCondValue()) == 0;
        }
        if (item.getType() != 1) {
            return false;
        }
        Molecule parent = (Molecule)item.getParent();
        ArrayList<Atom> sibs = parent.getChildren();
        int occurs = 0;
        for (int s = 0; s < sibs.size(); ++s) {
            Molecule sib;
            if (!(sibs.get(s) instanceof Molecule) || (sib = (Molecule)sibs.get(s)).getXPathName() == null) continue;
            if (sib.getXPathName().compareTo(col.getXPath().getValue()) == 0 && ++occurs == col.getCondPosition() && sib == item) {
                return true;
            }
            if (occurs <= col.getCondPosition()) continue;
            return false;
        }
        return false;
    }

    private void postScanEnumeration() {
        for (int c = 0; c < this.m_cols.size(); ++c) {
            Column col = (Column)this.m_cols.get(c);
            if (!col.hasEnumeration() && !col.hasDefault()) continue;
            ArrayList<String> vals = col.getEnumValues();
            String def = col.getDefault();
            for (int r = 0; r < this.m_rowset.size(); ++r) {
                ArrayList row = (ArrayList)this.m_rowset.get(r);
                assert (row.get(c) instanceof String);
                String data = (String)row.get(c);
                if (data == null || data.length() == 0) {
                    row.set(c, def);
                    continue;
                }
                boolean found = false;
                if (vals != null) {
                    for (int v = 0; v < vals.size(); ++v) {
                        String val = vals.get(v);
                        if (data.compareTo(val) != 0) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                row.set(c, def);
            }
        }
    }

    private void scanOrdinals(boolean isBegin, Molecule parent, boolean inRow, String path) {
        if (parent.getType() == 6) {
            return;
        }
        for (int c = 0; c < this.m_colbuff.size(); ++c) {
            int value;
            boolean resBeg;
            boolean incBeg;
            String dp;
            Column col = (Column)this.m_cols.get(c);
            if (!col.isOrdinal()) continue;
            String ip = col.getIncrementXPath() != null ? col.getIncrementXPath().getValue() : null;
            String string = dp = col.getDecrementXPath() != null ? col.getDecrementXPath().getValue() : null;
            boolean bl = ip != null ? col.getIncrementXPath().getBeginEnd() == 0 : (incBeg = true);
            boolean decBeg = dp != null ? col.getDecrementXPath().getBeginEnd() == 0 : true;
            String rp = null;
            boolean bl2 = resBeg = !isBegin;
            if (col.getResetXPath() != null) {
                rp = col.getResetXPath().getValue();
                boolean bl3 = resBeg = col.getResetXPath().getBeginEnd() == 0;
            }
            if (isBegin && !incBeg && !decBeg && !resBeg || !isBegin && incBeg && decBeg && resBeg) continue;
            if (this.matchPath(path, rp) && isBegin == resBeg) {
                this.m_colbuff.set(c, new Integer(0));
            }
            if (this.matchPath(path, ip) && isBegin == incBeg) {
                value = (Integer)this.m_colbuff.get(c);
                this.m_colbuff.set(c, new Integer(value + 1));
            }
            if (!this.matchPath(path, dp) || isBegin != decBeg) continue;
            value = (Integer)this.m_colbuff.get(c);
            this.m_colbuff.set(c, new Integer(value - 1));
        }
    }

    private void newRow() {
        this.m_currentRow = new ArrayList();
        this.m_rowset.add(this.m_currentRow);
        for (int c = 0; c < this.m_colbuff.size(); ++c) {
            Column col = (Column)this.m_cols.get(c);
            if (!col.isRetained() && !col.isOrdinal() && this.m_replace[c]) {
                this.m_colbuff.set(c, "");
            }
            this.m_currentRow.add(this.m_colbuff.get(c));
            this.m_replace[c] = true;
        }
    }

    private void updateRow() {
        for (int c = 0; c < this.m_colbuff.size(); ++c) {
            this.m_currentRow.set(c, this.m_colbuff.get(c));
        }
    }
}

