/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sxle.map;

import com.sas.sxle.map.Cartographer;
import com.sas.sxle.map.Column;
import com.sas.sxle.map.Datatype;
import com.sas.sxle.map.Format;
import com.sas.sxle.map.NamespaceList;
import com.sas.sxle.map.Output;
import com.sas.sxle.map.Table;
import java.util.ArrayList;
import org.w3c.dom.Element;

@Deprecated
public class Cartographer_1_0
extends Cartographer {
    @Override
    protected void writeMapTable(Table table) {
        this.m_root.appendChild(this.m_doc.createComment(" ############################################################ "));
        this.m_currentTable = this.m_doc.createElement("TABLE");
        this.m_currentTable.setAttribute("name", table.getName());
        if (!this.xpOK(table.getXPath())) {
            table.setXPath("/");
        }
        if (this.strOK(table.getDescription())) {
            Element desc = this.m_doc.createElement("TABLE_LABEL");
            desc.appendChild(this.m_doc.createTextNode(table.getDescription()));
            this.m_currentTable.appendChild(desc);
        }
        Element path = this.m_doc.createElement("TABLE_XPATH");
        path.appendChild(this.m_doc.createTextNode(this.stripNS(table.getXPath().getValue())));
        this.m_currentTable.appendChild(path);
        if (this.xpOK(table.getOptXPath())) {
            String begend = table.getOptXPath().getBeginEnd() == 1 ? "END" : "BEGIN";
            Element opath = this.m_doc.createElement("TABLE_END_XPATH");
            opath.setAttribute("beginend", begend);
            opath.appendChild(this.m_doc.createTextNode(this.stripNS(table.getOptXPath().getValue())));
            this.m_currentTable.appendChild(opath);
        }
        this.m_root.appendChild(this.m_currentTable);
        for (int c = 0; c < table.getColumns().size(); ++c) {
            this.writeMapColumn(table.getColumn(c));
        }
        this.writeBlankLine(this.m_currentTable);
        this.writeBlankLine(this.m_root);
    }

    @Override
    protected void writeMapColumn(Column column) {
        ArrayList<String> v;
        int safelen;
        if (column.isOrdinal()) {
            String msg = "Unsupported column (" + column.getName() + ") in table (" + column.getParent().getName() + ") ignored.";
            this.m_root.appendChild(this.m_doc.createComment(msg));
            return;
        }
        this.m_currentColumn = this.m_doc.createElement("COLUMN");
        this.writeBlankLine(this.m_currentTable);
        this.m_currentColumn.setAttribute("name", column.getName());
        this.m_currentTable.appendChild(this.m_currentColumn);
        if (this.xpOK(column.getXPath())) {
            Element path = this.m_doc.createElement("XPATH");
            path.appendChild(this.m_doc.createTextNode(this.stripNS(column.getXPath().getValue())));
            this.m_currentColumn.appendChild(path);
        }
        if (column.isRetained()) {
            this.m_currentColumn.setAttribute("retain", "YES");
        }
        if (this.strOK(column.getDescription())) {
            Element desc = this.m_doc.createElement("LABEL");
            desc.appendChild(this.m_doc.createTextNode(column.getDescription()));
            this.m_currentColumn.appendChild(desc);
        }
        Element type = this.m_doc.createElement("TYPE");
        type.appendChild(this.m_doc.createTextNode(Column.TYPE[column.getType()]));
        this.m_currentColumn.appendChild(type);
        Element datatype = this.m_doc.createElement("DATATYPE");
        datatype.appendChild(this.m_doc.createTextNode(Datatype.OLDEMITDATATYPE[column.getDatatype()]));
        this.m_currentColumn.appendChild(datatype);
        int n = safelen = column.getType() == 0 ? column.getLength() : 8;
        if (safelen < 1) {
            this.m_currentColumn.appendChild(this.m_doc.createComment("<!-- ### LENGTH was invalid, using default ### -->"));
            safelen = 32;
        }
        Element length = this.m_doc.createElement("LENGTH");
        length.appendChild(this.m_doc.createTextNode(Integer.toString(safelen)));
        this.m_currentColumn.appendChild(length);
        if (column.hasFormat()) {
            Format fmt = column.getFormat();
            Element format = this.m_doc.createElement("FORMAT");
            format.appendChild(this.m_doc.createTextNode(fmt.getName()));
            if (fmt.getLength() > 0) {
                format.setAttribute("width", Integer.toString(fmt.getLength()));
            }
            if (fmt.getNDec() > 0) {
                format.setAttribute("ndec", Integer.toString(fmt.getNDec()));
            }
            this.m_currentColumn.appendChild(format);
        }
        if (column.hasInformat()) {
            Format infmt = column.getInformat();
            Element informat = this.m_doc.createElement("INFORMAT");
            informat.appendChild(this.m_doc.createTextNode(infmt.getName()));
            if (infmt.getLength() > 0) {
                informat.setAttribute("width", Integer.toString(infmt.getLength()));
            }
            if (infmt.getNDec() > 0) {
                informat.setAttribute("ndec", Integer.toString(infmt.getNDec()));
            }
            this.m_currentColumn.appendChild(informat);
        }
        if (column.hasEnumeration() && (v = column.getEnumValues()) != null && v.size() > 0) {
            Element eleEnum = this.m_doc.createElement("ENUM");
            for (int i = 0; i < v.size(); ++i) {
                Element val = this.m_doc.createElement("VALUE");
                val.appendChild(this.m_doc.createTextNode(v.get(i)));
                eleEnum.appendChild(val);
            }
            this.m_currentColumn.appendChild(eleEnum);
        }
        if (column.hasDefault() && this.strOK(column.getDefault())) {
            Element def = this.m_doc.createElement("DEFAULT");
            def.appendChild(this.m_doc.createTextNode(column.getDefault()));
            this.m_currentColumn.appendChild(def);
        }
    }

    @Override
    protected void setMapAttributes() {
        this.m_root.setAttribute("version", this.m_map.getVersion());
    }

    @Override
    protected void setMapValidation() {
        this.m_root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.m_root.setAttribute("xsi:noNamespaceSchemaLocation", "http://www.sas.com/xml/schema/sxle10.xsd");
    }

    @Override
    protected void writeMapOutput(Output out) {
    }

    @Override
    protected void writeMapNamespaces(NamespaceList namespaces) {
    }
}

