/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sxle.map;

import com.sas.sxle.map.Column;
import com.sas.sxle.map.Map;
import com.sas.sxle.map.NamespaceList;
import com.sas.sxle.map.Output;
import com.sas.sxle.map.SXLEContext;
import com.sas.sxle.map.Table;
import com.sas.sxle.map.ValidationIssue;
import com.sas.sxle.map.XPath;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class Cartographer {
    protected static ResourceBundle res = ResourceBundle.getBundle("com.sas.sxle.map.Resources");
    protected Document m_doc;
    protected Element m_root = null;
    protected Element m_currentTable = null;
    protected Element m_currentColumn = null;
    protected Map m_map;
    protected static final String kCOMMENT = " ############################################################ ";
    protected static final char LF = '\n';
    protected static final String EOL = Character.toString('\n');
    private static TransformerFactory xtf = null;
    private static ClassLoader mycl = null;
    private static InputStream stylesheet = null;
    private static Transformer xt = null;

    protected boolean strOK(String s) {
        if (s == null) {
            return false;
        }
        return s.length() > 0;
    }

    protected boolean xpOK(XPath x) {
        if (x == null) {
            return false;
        }
        return this.strOK(x.getValue());
    }

    @Deprecated
    protected String stripNS(String xp) {
        String temp = xp;
        int cp = temp.indexOf(58);
        int beg = 0;
        while (cp >= 0) {
            int sp = temp.indexOf(47, beg);
            while (sp >= 0 && sp < cp) {
                beg = sp;
                sp = temp.indexOf(47, beg + 1);
            }
            temp = temp.substring(0, beg + 1) + temp.substring(cp + 1);
            cp = temp.indexOf(58);
        }
        return temp;
    }

    protected void createDoc() throws ParserConfigurationException {
        DocumentBuilderFactory xdbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder xdb = xdbf.newDocumentBuilder();
        this.m_doc = xdb.newDocument();
    }

    protected void createMap(Map map, boolean validate) {
        this.m_map = map;
        try {
            this.createDoc();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return;
        }
        this.writeMapHeader(validate);
        this.writeMapOutput(map.getOutput());
        this.writeMapNamespaces(this.m_map.getNamespaces());
        for (int t = 0; t < map.getTables().size(); ++t) {
            this.writeMapTable(map.getTable(t));
        }
        this.writeMapTrailer();
    }

    public void saveMap(Map map, boolean validate, String dest) throws IOException {
        this.createMap(map, validate);
        this.persist(dest);
    }

    public String buildMap(Map map, boolean validate) {
        this.createMap(map, validate);
        return this.getDocString();
    }

    protected String getDocString() {
        StringWriter sw = new StringWriter();
        try {
            if (stylesheet == null) {
                xtf = TransformerFactory.newInstance();
                xt = xtf.newTransformer(this.getStylesheet());
                xt.setOutputProperty("indent", "yes");
            }
            xt.setOutputProperty("encoding", this.m_map.getEncoding().displayName());
            xt.transform(new DOMSource(this.m_doc), new StreamResult(sw));
        }
        catch (TransformerException te) {
            return null;
        }
        return sw.toString();
    }

    protected StreamSource getStylesheet() {
        if (stylesheet == null) {
            mycl = this.getClass().getClassLoader();
            stylesheet = mycl.getResourceAsStream("res/XMLPrettyPrintMap.xsl");
        }
        return new StreamSource(stylesheet);
    }

    protected void persist(String dest) throws FileNotFoundException {
        try {
            FileOutputStream fos = new FileOutputStream(new File(dest));
            if (stylesheet == null) {
                xtf = TransformerFactory.newInstance();
                xt = xtf.newTransformer(this.getStylesheet());
                xt.setOutputProperty("encoding", this.m_map.getEncoding().displayName());
                xt.setOutputProperty("indent", "yes");
            }
            xt.transform(new DOMSource(this.m_doc), new StreamResult(fos));
            fos.close();
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (TransformerException te) {
            te.printStackTrace();
            return;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
    }

    protected void writeBlankLine(Node node) {
        node.appendChild(this.m_doc.createTextNode(EOL));
    }

    protected void writeMapHeader(boolean validate) {
        Date d = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern("yyyy-MM-dd'T'HH:mm:ss");
        String time = sdf.format(d);
        this.m_doc.appendChild(this.m_doc.createComment(kCOMMENT));
        this.m_doc.appendChild(this.m_doc.createComment(" " + time + " "));
        this.m_doc.appendChild(this.m_doc.createComment(" SAS XML Libname Engine Map "));
        this.m_doc.appendChild(this.m_doc.createComment(" Generated by XML Mapper, " + SXLEContext.getVersion() + " "));
        if (SXLEContext.validationLevel() == 2) {
            this.m_doc.appendChild(this.m_doc.createComment(" WARNING: Generated with XML validation disabled "));
        }
        if (validate) {
            this.m_doc.appendChild(this.m_doc.createComment(kCOMMENT));
            this.m_doc.appendChild(this.m_doc.createComment(" ###  Validation report                                   ### "));
            this.m_doc.appendChild(this.m_doc.createComment(kCOMMENT));
            ArrayList<ValidationIssue> issues = new ArrayList<ValidationIssue>(10);
            this.m_map.validate(issues);
            for (int i = 0; i < issues.size(); ++i) {
                this.m_doc.appendChild(this.m_doc.createComment(" " + issues.get(i).getDescription() + " "));
            }
        }
        this.m_doc.appendChild(this.m_doc.createComment(kCOMMENT));
        if (this.m_map.getValidation() == 2 && this.m_map.getVersionID() == 1) {
            this.m_doc.appendChild(this.m_doc.createProcessingInstruction("DOCTYPE", "SXLEMAP PUBLIC \"http://www.sas.com/xml/dtd/sxle11.dtd\""));
        }
        this.m_root = this.m_doc.createElement("SXLEMAP");
        this.m_doc.appendChild(this.m_root);
        this.setMapAttributes();
        if (this.m_map.getValidation() == 1) {
            this.setMapValidation();
        }
        this.writeBlankLine(this.m_root);
    }

    protected void writeMapTrailer() {
    }

    protected abstract void writeMapTable(Table var1);

    protected abstract void writeMapColumn(Column var1);

    protected abstract void writeMapOutput(Output var1);

    protected abstract void setMapAttributes();

    protected abstract void setMapValidation();

    protected abstract void writeMapNamespaces(NamespaceList var1);
}

