/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.alerts.client;

import com.sas.svcs.alerts.client.Alert;
import com.sas.svcs.alerts.client.AlertCondition;
import com.sas.svcs.alerts.client.AlertException;
import java.util.List;

public final class AlertConditionTester {
    private AlertConditionTester() {
    }

    public static boolean isMatch(Alert alert, Object dataValue) {
        boolean match = false;
        List<AlertCondition> conditions = alert.getConditions();
        if (null == conditions || conditions.isEmpty()) {
            return match;
        }
        for (AlertCondition ac : conditions) {
            try {
                match = AlertConditionTester.isMatch(ac, dataValue);
            }
            catch (AlertException ade) {
                match = false;
            }
            if (match) continue;
            break;
        }
        return match;
    }

    public static boolean isMatch(Alert alert, List<AlertCondition> alertConditions) {
        boolean match = false;
        List<AlertCondition> conditions = alert.getConditions();
        if (null == alertConditions && null == conditions) {
            return true;
        }
        if (null == alertConditions && null != conditions || null == conditions && null != alertConditions) {
            return false;
        }
        for (AlertCondition ac : conditions) {
            if (null == ac || !ac.isComplete()) {
                return false;
            }
            boolean thisTest = false;
            for (AlertCondition testCondition : alertConditions) {
                try {
                    if (testCondition.getType() != ac.getType() || !testCondition.getAttribute().equals(ac.getAttribute()) || (thisTest = AlertConditionTester.isMatch(ac, testCondition.getValue()))) continue;
                    return thisTest;
                }
                catch (AlertException alertException) {
                }
            }
            match = thisTest;
            if (match) continue;
            return match;
        }
        return match;
    }

    public static boolean isMatchOfAllConditions(Alert alert, List<AlertCondition> alertConditions) {
        List<AlertCondition> conditions = alert.getConditions();
        if (null == conditions || conditions.isEmpty()) {
            return false;
        }
        if (alertConditions.size() > conditions.size()) {
            return false;
        }
        int matchCount = 0;
        block2: for (AlertCondition testCondition : alertConditions) {
            if (null == testCondition || !testCondition.isComplete()) {
                return false;
            }
            for (AlertCondition ac : conditions) {
                try {
                    if (testCondition.getType() != ac.getType() || !testCondition.getAttribute().equals(ac.getAttribute()) || !AlertConditionTester.isMatch(ac, testCondition.getValue())) continue;
                    ++matchCount;
                    continue block2;
                }
                catch (AlertException alertException) {
                }
            }
        }
        return matchCount == alertConditions.size();
    }

    private static boolean isMatch(AlertCondition ac, Object dataValue) throws AlertException {
        int compareResults = 0;
        Object conditionValue = ac.getValue();
        if (null == dataValue) {
            compareResults = null == conditionValue ? 0 : -1;
        } else if (null == conditionValue) {
            compareResults = 1;
        } else {
            if (!(dataValue instanceof Comparable)) {
                throw new AlertException("Value '" + dataValue + "; in comparison does not implement Comparable; match is assumed false.");
            }
            try {
                compareResults = ((Comparable)dataValue).compareTo(conditionValue);
            }
            catch (ClassCastException cce) {
                throw new AlertException("Incompatible data values: " + cce.getMessage(), cce);
            }
        }
        return AlertConditionTester.evaluate(ac, compareResults);
    }

    private static boolean evaluate(AlertCondition ac, int compareResults) {
        boolean match = false;
        int operator = ac.getOperator();
        if (compareResults < 0) {
            match = (operator & 1) > 0;
        } else if (0 == compareResults) {
            match = (operator & 4) > 0;
        } else {
            boolean bl = match = (operator & 2) > 0;
        }
        if (ac.hasNotOperator()) {
            match = !match;
        }
        return match;
    }
}

