/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.alerts.client;

import com.sas.framework.commons.holders.ClientApplicationNameHolder;
import com.sas.svcs.alerts.client.AlertCondition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Alert
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long id;
    private String name = "";
    private String eventName;
    private short subscriberType;
    private String subscriber;
    private short registrationType;
    private short deliveryType;
    private short deliveryTypeFlags = 0;
    private boolean active;
    private String application = "";
    private String sourceDirective;
    private String sourceParms;
    private String targetDirective;
    private String targetParms;
    private String targetUrl;
    private Date createdOn;
    private Date updatedOn;
    private long notificationHoldInterval;
    private List<AlertCondition> conditions;
    @Deprecated
    public static final short PORTLET = 4;
    @Deprecated
    public static final short MAIL = 5;
    @Deprecated
    public static final short MAIL_AND_PORTLET = 6;
    @Deprecated
    public static final short SMS = 7;
    @Deprecated
    public static final short SMS_AND_PORTLET = 8;
    @Deprecated
    public static final short USER_PREFERENCE = 0;
    public static final short USER_PREFERENCE_BIT = 16;
    public static final short MAIL_BIT = 32;
    public static final short PORTLET_BIT = 64;
    public static final short SMS_BIT = 128;
    public static final short DIGEST_BIT = 256;
    public static final short USER = 0;
    public static final short GROUP = 1;
    public static final short OPTED_IN = 0;
    public static final short ASSIGNED = 1;

    public Alert() {
    }

    public Alert(long id, String eventName, String subscriber, short deliveryType, boolean isActive, String alertName, String targetDirective, String targetParams) {
        this.id = id;
        this.setActive(isActive);
        this.setName(alertName);
        this.setTargetDirective(targetDirective);
        this.setTargetParms(targetParams);
        this.setEventName(eventName);
        this.setSubscriber(subscriber);
        this.setDeliveryType(deliveryType);
        this.setKnownApplication();
    }

    public Alert(String eventName, String subscriber, short deliveryType, String alertName, String targetDirective, String targetParams, List<AlertCondition> alertConditions) {
        this.setActive(true);
        this.setName(alertName);
        this.setEventName(eventName);
        this.setSubscriber(subscriber);
        this.setTargetDirective(targetDirective);
        this.setTargetParms(targetParams);
        this.setDeliveryType(deliveryType);
        this.setConditions(alertConditions);
        this.setKnownApplication();
    }

    public Alert(String eventName, short subscriberType, String subscriber, short deliveryType, String alertName, String targetDirective, String targetParams, String attribute, int operator, Object value) {
        this.setActive(true);
        this.setSubscriberType(subscriberType);
        this.setTargetDirective(targetDirective);
        this.setTargetParms(targetParams);
        this.setEventName(eventName);
        this.setSubscriber(subscriber);
        this.setDeliveryType(deliveryType);
        this.setName(alertName);
        AlertCondition ac = new AlertCondition(attribute, operator, value);
        this.addAlertCondition(ac);
        this.setKnownApplication();
    }

    public boolean isActive() {
        return this.active;
    }

    public List<AlertCondition> getConditions() {
        return this.conditions;
    }

    @Deprecated
    public final short getDeliveryType() {
        return this.deliveryType;
    }

    public String getEventName() {
        return this.eventName;
    }

    public long getId() {
        return this.id;
    }

    public String getSubscriber() {
        return this.subscriber;
    }

    public short getSubscriberType() {
        return this.subscriberType;
    }

    public short getRegistrationType() {
        return this.registrationType;
    }

    public final void setActive(boolean flag) {
        this.active = flag;
    }

    public String getName() {
        return this.name;
    }

    public String getSourceDirective() {
        return this.sourceDirective;
    }

    public final void setName(String name) {
        this.name = null == name ? "" : name;
    }

    public void setCreatedOn(Date timestamp) {
        this.createdOn = timestamp;
    }

    public void setUpdatedOn(Date timestamp) {
        this.updatedOn = timestamp;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public Date getUpdatedOn() {
        return this.updatedOn;
    }

    public final void setConditions(List<AlertCondition> list) {
        this.conditions = list;
    }

    @Deprecated
    public final void setDeliveryType(short type) {
        if (type >= 16) {
            this.setDeliveryTypeFlags(type);
        } else {
            this.deliveryType = type;
            if (0 == this.deliveryType) {
                this.deliveryTypeFlags = (short)16;
            }
            if (5 == this.deliveryType) {
                this.deliveryTypeFlags = (short)32;
            } else if (4 == this.deliveryType) {
                this.deliveryTypeFlags = (short)64;
            } else if (7 == this.deliveryType) {
                this.deliveryTypeFlags = (short)128;
            } else if (6 == this.deliveryType) {
                this.deliveryTypeFlags = (short)96;
            } else if (8 == this.deliveryType) {
                this.deliveryTypeFlags = (short)192;
            }
        }
    }

    public short getDeliveryTypeFlags() {
        return this.deliveryTypeFlags;
    }

    public final void setDeliveryTypeFlags(short deliveryTypeFlags) {
        this.deliveryTypeFlags = deliveryTypeFlags;
        if (this.isPortlet()) {
            this.deliveryType = this.isMail() ? (short)6 : (this.isSms() ? (short)8 : (short)4);
        } else if (this.isMail()) {
            this.deliveryType = (short)5;
        } else if (this.isSms()) {
            this.deliveryType = (short)7;
        } else if (this.isUserPreference()) {
            this.deliveryType = 0;
        }
    }

    public boolean isUserPreference() {
        return this.isBitSet((short)16);
    }

    private boolean isBitSet(short flag) {
        return (this.deliveryTypeFlags & flag) == flag;
    }

    public boolean isDigest() {
        return this.isBitSet((short)256);
    }

    public boolean isPortlet() {
        return this.isBitSet((short)64);
    }

    public boolean isMail() {
        return this.isBitSet((short)32);
    }

    public boolean isSms() {
        return this.isBitSet((short)128);
    }

    public final void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public final void setSubscriber(String subscriber) {
        this.subscriber = subscriber;
    }

    public final void setSubscriberType(short type) {
        this.subscriberType = type;
    }

    public void setRegistrationType(short type) {
        this.registrationType = type;
    }

    public final void addAlertCondition(AlertCondition condition) {
        if (null == this.conditions) {
            this.conditions = new ArrayList<AlertCondition>();
        }
        this.conditions.add(condition);
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String app) {
        if (app == null) {
            this.setKnownApplication();
        } else {
            this.application = app;
        }
    }

    public String getSourceParms() {
        return this.sourceParms;
    }

    public void setSourceParms(String sourceParms) {
        this.sourceParms = sourceParms;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setSourceDirective(String sourceDirective) {
        this.sourceDirective = sourceDirective;
    }

    public String getTargetDirective() {
        return this.targetDirective;
    }

    public final void setTargetDirective(String targetDirective) {
        this.targetDirective = targetDirective;
    }

    public String getTargetParms() {
        return this.targetParms;
    }

    public final void setTargetParms(String targetParms) {
        this.targetParms = targetParms;
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    public void setNotificationHoldInterval(long interval) {
        this.notificationHoldInterval = interval;
    }

    public long getNotificationHoldInterval() {
        return this.notificationHoldInterval;
    }

    public boolean isGroupSubscribed() {
        return this.subscriberType == 1;
    }

    public boolean isAssigned() {
        return this.registrationType == 1;
    }

    private void setKnownApplication() {
        String app = ClientApplicationNameHolder.get();
        if (null == app) {
            app = "";
        }
        this.application = app;
    }

    public String toString() {
        int stringLength = 100;
        StringBuilder sb = new StringBuilder(100).append("Alert: ").append(this.getId()).append("[eventName=").append(this.getEventName()).append(", name=").append(this.getName()).append(", subscriber=").append(this.getSubscriber()).append(", subscriberType=").append(this.getSubscriberType()).append(", registrationType=").append(this.getRegistrationType()).append(", deliveryType=").append(this.getDeliveryType()).append(", active=").append(this.isActive()).append(", app=").append(this.getApplication()).append(", srcDirective=").append(this.getSourceDirective()).append(", srcParams=").append(this.getSourceParms()).append(", targetUrl=").append(this.getTargetUrl()).append(", targetDirective=").append(this.getTargetDirective()).append(", targetParams=").append(this.getTargetParms()).append(", holdInterval=").append(this.getNotificationHoldInterval()).append(", createdOn=").append(this.getCreatedOn()).append(", updatedOn=").append(this.getUpdatedOn());
        if (null == this.conditions) {
            sb.append(", no conditions");
        } else {
            int count = 0;
            for (AlertCondition ac : this.conditions) {
                sb.append(", attribute").append(count).append('=').append(ac.getAttribute()).append(", operator").append(count).append('=').append(ac.getOperator()).append(", value").append(count).append('=').append(ac.getValue()).append(", type").append(count).append('=').append(ac.getType());
                ++count;
            }
            if (0 == count) {
                sb.append(", no conditions");
            }
        }
        sb.append(']');
        return sb.toString();
    }
}

