/*
 * Decompiled with CFR 0.152.
 */
package MITI.server.services.log;

import MITI.server.services.common.mir.ObjectDefinition;
import MITI.server.services.log.OperationStatus;
import MITI.util.DateUtil;

public class PerformanceRecord
extends OperationStatus {
    private String operationName = null;
    private long startTime = 0L;
    private long endTime = 0L;
    private ObjectDefinition operationObject = null;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getOperationId()).append(' ').append(this.operationName).append(' ').append(DateUtil.formatSimpleDate(this.startTime, false)).append(" - ").append(DateUtil.formatSimpleDate(this.endTime, false)).append(" status=").append(this.getStatusCode()).append('\n');
        if (this.operationObject != null) {
            stringBuffer.append(this.operationObject.toString()).append('\n');
        }
        long l = this.startTime;
        if (this.getLogEvents() != null) {
            for (int i = 0; i < this.getLogEvents().length; ++i) {
                long l2 = i == 0 ? this.startTime : this.getLogEvents()[i - 1].getTime();
                stringBuffer.append(DateUtil.formatSimpleDate(this.getLogEvents()[i].getTime(), false)).append(' ');
                l = this.getLogEvents()[i].getTime();
                String string = Long.toString((this.getLogEvents()[i].getTime() - l2) / 1000L);
                for (int j = string.length(); j < 5; ++j) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(string).append("s ");
                stringBuffer.append(this.getLogEvents()[i].getCode()).append(' ').append(this.getLogEvents()[i].getText()).append('\n');
            }
        }
        stringBuffer.append(DateUtil.formatSimpleDate(this.endTime, false)).append(' ');
        String string = Long.toString((this.endTime - l) / 1000L);
        for (int i = string.length(); i < 5; ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(string).append("s ");
        stringBuffer.append("Operation completed. Status=").append(this.getStatusCode()).append('\n');
        return stringBuffer.toString();
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String string) {
        this.operationName = string;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long l) {
        this.startTime = l;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long l) {
        this.endTime = l;
    }

    public ObjectDefinition getOperationObject() {
        return this.operationObject;
    }

    public void setOperationObject(ObjectDefinition objectDefinition) {
        this.operationObject = objectDefinition;
    }
}

