/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.webdav;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.search.SearchConstants;
import org.apache.jackrabbit.webdav.search.SearchInfo;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SearchInfoHelper {
    private static Logger log = LoggerFactory.getLogger(SearchInfoHelper.class);
    private static final String LIMIT = "limit";
    private static final String NRESULTS = "nresults";
    private static final String OFFSET = "offset";
    private static final TransformerFactory transformerFactory = TransformerFactory.newInstance();

    public static SearchInfo createFromXml(Element searchRequest) throws DavException {
        if (searchRequest == null || !"searchrequest".equals(searchRequest.getLocalName())) {
            log.warn("The root element must be 'searchrequest'.");
            throw new DavException(400);
        }
        Element first = DomUtil.getFirstChildElement((Node)searchRequest);
        if (first == null) {
            log.warn("A single child element is expected with the 'DAV:searchrequest'.");
            throw new DavException(400);
        }
        HashMap namespaces = new HashMap();
        if ("basicsearch".equals(first.getLocalName()) && "DAV:".equals(first.getNamespaceURI())) {
            SearchInfo sInfo = new SearchInfo(first.getLocalName(), DomUtil.getNamespace((Element)first), DomUtil.getText((Element)first), namespaces);
            Element limit = DomUtil.getChildElement((Node)searchRequest, (String)LIMIT, (Namespace)SearchConstants.NAMESPACE);
            if (limit != null) {
                String offset;
                String nresults = DomUtil.getChildTextTrim((Element)limit, (String)NRESULTS, (Namespace)SearchConstants.NAMESPACE);
                if (nresults != null) {
                    try {
                        sInfo.setNumberResults(Long.valueOf(nresults).longValue());
                    }
                    catch (NumberFormatException e) {
                        log.error("DAV:nresults cannot be parsed into a long -> ignore.");
                    }
                }
                if ((offset = DomUtil.getChildTextTrim((Element)limit, (String)OFFSET, (Namespace)Namespace.EMPTY_NAMESPACE)) != null) {
                    try {
                        sInfo.setOffset(Long.valueOf(offset).longValue());
                    }
                    catch (NumberFormatException e) {
                        log.error("'offset' cannot be parsed into a long -> ignore.");
                    }
                }
            }
            return sInfo;
        }
        return SearchInfo.createFromXml((Element)searchRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String nodeToString(Node node, Properties outputFormatProperties) throws IllegalArgumentException {
        String string;
        block9: {
            if (node == null) {
                throw new IllegalArgumentException();
            }
            string = null;
            TransformerException ex = null;
            try {
                DOMSource domSource = new DOMSource(node);
                StringWriter stringWriter = new StringWriter();
                StreamResult streamResult = new StreamResult(stringWriter);
                Transformer transformer = transformerFactory.newTransformer();
                if (outputFormatProperties != null && outputFormatProperties.size() > 0) {
                    transformer.setOutputProperties(outputFormatProperties);
                }
                transformer.transform(domSource, streamResult);
                string = stringWriter.toString();
            }
            catch (TransformerConfigurationException e) {
                ex = e;
                return ex;
            }
            catch (TransformerException e) {
                ex = e;
                return ex;
            }
            finally {
                if (ex == null) break block9;
                throw new IllegalArgumentException(ex.getLocalizedMessage());
            }
        }
        return string;
    }
}

