/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.webdav;

import com.sas.contentserver.webdav.AclResourceImpl;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.DavServletRequest;
import org.apache.jackrabbit.webdav.DavServletResponse;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.jcr.JcrDavSession;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.apache.jackrabbit.webdav.security.AclResource;
import org.apache.jackrabbit.webdav.simple.ResourceConfig;
import org.apache.jackrabbit.webdav.simple.ResourceFactoryImpl;
import org.apache.jackrabbit.webdav.simple.VersionHistoryResourceImpl;
import org.apache.jackrabbit.webdav.simple.VersionResourceImpl;

public class SASResourceFactoryImpl
extends ResourceFactoryImpl {
    private final ResourceConfig resourceConfig;
    private final LockManager lockMgr;

    public SASResourceFactoryImpl(LockManager lockMgr, ResourceConfig resourceConfig) {
        super(lockMgr, resourceConfig);
        this.resourceConfig = resourceConfig;
        this.lockMgr = lockMgr;
    }

    public DavResource createResource(DavResourceLocator locator, DavServletRequest request, DavServletResponse response) throws DavException {
        JcrDavSession.checkImplementation((DavSession)request.getDavSession());
        JcrDavSession sessionImpl = (JcrDavSession)request.getDavSession();
        if (SASResourceFactoryImpl.aclSupported(sessionImpl.getRepositorySession())) {
            try {
                Node node = this.getNode((DavSession)sessionImpl, locator);
                VersionResourceImpl resource = null;
                if (node instanceof Version) {
                    resource = new VersionResourceImpl(locator, (DavResourceFactory)this, (DavSession)sessionImpl, this.resourceConfig, (Item)node);
                } else if (node instanceof VersionHistory) {
                    resource = new VersionHistoryResourceImpl(locator, (DavResourceFactory)this, (DavSession)sessionImpl, this.resourceConfig, (Item)node);
                } else if (node != null) {
                    resource = this.createAclResource(node, locator, (DavSession)sessionImpl);
                    resource.addLockManager(this.lockMgr);
                    return resource;
                }
            }
            catch (RepositoryException e) {
                throw new DavException(500, (Throwable)e);
            }
        }
        return super.createResource(locator, request, response);
    }

    public DavResource createResource(DavResourceLocator locator, DavSession session) throws DavException {
        JcrDavSession.checkImplementation((DavSession)session);
        JcrDavSession sessionImpl = (JcrDavSession)session;
        if (SASResourceFactoryImpl.versioningSupported(sessionImpl.getRepositorySession())) {
            try {
                Node node = this.getNode(session, locator);
                Object resource = null;
                resource = node instanceof Version ? new VersionResourceImpl(locator, (DavResourceFactory)this, (DavSession)sessionImpl, this.resourceConfig, (Item)node) : (node instanceof VersionHistory ? new VersionHistoryResourceImpl(locator, (DavResourceFactory)this, (DavSession)sessionImpl, this.resourceConfig, (Item)node) : this.createAclResource(node, locator, session));
                resource.addLockManager(this.lockMgr);
                return resource;
            }
            catch (RepositoryException e) {
                throw new DavException(500, (Throwable)e);
            }
        }
        if (SASResourceFactoryImpl.aclSupported(sessionImpl.getRepositorySession())) {
            try {
                Node node = this.getNode(session, locator);
                AclResource resource = this.createAclResource(node, locator, session);
                resource.addLockManager(this.lockMgr);
                return resource;
            }
            catch (RepositoryException e) {
                throw new DavException(500, (Throwable)e);
            }
        }
        return super.createResource(locator, session);
    }

    private AclResource createAclResource(Node node, DavResourceLocator locator, DavSession session) throws DavException {
        return new AclResourceImpl(locator, (DavResourceFactory)this, session, this.resourceConfig, (Item)node);
    }

    private static boolean versioningSupported(Session repoSession) {
        String desc = repoSession.getRepository().getDescriptor("option.versioning.supported");
        return Boolean.valueOf(desc);
    }

    private static boolean aclSupported(Session repoSession) {
        return true;
    }

    private Node getNode(DavSession sessionImpl, DavResourceLocator locator) throws RepositoryException {
        Node node = null;
        try {
            Session session;
            Item item;
            String repoPath = locator.getRepositoryPath();
            if (repoPath != null && (item = (session = ((JcrDavSession)sessionImpl).getRepositorySession()).getItem(repoPath)) instanceof Node) {
                node = (Node)item;
            }
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        return node;
    }
}

