/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.webdav;

import com.sas.contentserver.commons.SpecialNameChars;
import org.apache.jackrabbit.webdav.AbstractLocatorFactory;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.util.EncodeUtil;

public class SASLocatorFactoryImplEx
extends AbstractLocatorFactory {
    private final String pathPrefix;

    public SASLocatorFactoryImplEx(String pathPrefix) {
        super(pathPrefix);
        this.pathPrefix = pathPrefix;
    }

    protected String getRepositoryPath(String resourcePath, String wspPath) {
        if (resourcePath == null) {
            return resourcePath;
        }
        if (resourcePath.equals(wspPath) || this.startsWithWorkspace(resourcePath, wspPath)) {
            String repositoryPath = resourcePath.substring(wspPath.length());
            return (repositoryPath = SpecialNameChars.encode(repositoryPath)).length() == 0 ? "/" : repositoryPath;
        }
        throw new IllegalArgumentException("Unexpected format of resource path.");
    }

    protected String getResourcePath(String repositoryPath, String wspPath) {
        if (repositoryPath == null) {
            throw new IllegalArgumentException("Cannot build resource path from 'null' repository path");
        }
        return wspPath + SpecialNameChars.decode(repositoryPath);
    }

    public DavResourceLocator createResourceLocator(String prefix, String workspacePath, String path, boolean isResourcePath) {
        String resourcePath = isResourcePath ? path : this.getResourcePath(path, workspacePath);
        return new AbstractLocatorFactory.DavResourceLocatorImpl((AbstractLocatorFactory)this, prefix, workspacePath, resourcePath, (AbstractLocatorFactory)this);
    }

    public DavResourceLocator createResourceLocator(String prefix, String href) {
        String workspacePath;
        String resourcePath;
        if (href == null) {
            throw new IllegalArgumentException("Request handle must not be null.");
        }
        StringBuffer b = new StringBuffer("");
        if (prefix != null && prefix.length() > 0) {
            b.append(prefix);
            if (href.startsWith(prefix)) {
                href = href.substring(prefix.length());
            }
        }
        if (this.pathPrefix != null && this.pathPrefix.length() > 0) {
            if (!b.toString().endsWith(this.pathPrefix)) {
                b.append(this.pathPrefix);
            }
            if (href.startsWith(this.pathPrefix)) {
                href = href.substring(this.pathPrefix.length());
            }
        }
        if (href.endsWith("/")) {
            href = href.substring(0, href.length() - 1);
        }
        if ("".equals(href)) {
            resourcePath = null;
            workspacePath = null;
        } else {
            resourcePath = EncodeUtil.unescape((String)href);
            int pos = href.indexOf(47, 1);
            workspacePath = pos == -1 ? resourcePath : EncodeUtil.unescape((String)href.substring(0, pos));
        }
        return new AbstractLocatorFactory.DavResourceLocatorImpl((AbstractLocatorFactory)this, b.toString(), workspacePath, resourcePath, (AbstractLocatorFactory)this);
    }

    private boolean startsWithWorkspace(String repositoryPath, String wspPath) {
        if (wspPath == null) {
            return true;
        }
        return repositoryPath.startsWith(wspPath + "/");
    }
}

