/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.webdav;

import com.sas.contentserver.commons.SpecialNameChars;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.StringTokenizer;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class Dasl2JCRXPath {
    private static final String DAV_URI = "DAV:";
    private static final String OP_LIKE = "jcr:like";
    private static final String OP_EQ = "eq";
    private static final String OP_LT = "lt";
    private static final String OP_LTE = "le";
    private static final String OP_GT = "gt";
    private static final String OP_GTE = "ge";
    private static final Logger log = LoggerFactory.getLogger(Dasl2JCRXPath.class);

    public static String doConvert(String searchString, Session session, DavResourceLocator locator) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(searchString)));
            return Dasl2JCRXPath.convertDaslToXPath(doc.getDocumentElement(), session, locator);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Element getChildElement(Node node, int childNum) {
        if (node.hasChildNodes()) {
            NodeList nl = node.getChildNodes();
            int numElems = 0;
            for (int inode = 0; inode < nl.getLength(); ++inode) {
                Node n = nl.item(inode);
                if (!(n instanceof Element) || ++numElems != childNum) continue;
                return (Element)n;
            }
        }
        return null;
    }

    protected static String convertDaslToXPath(Element query, Session session, DavResourceLocator locator) {
        String fromString = "";
        String whereString = "";
        NodeList nl = query.getElementsByTagNameNS(DAV_URI, "select");
        String attrString = Dasl2JCRXPath.processSelect((Element)nl.item(0));
        nl = query.getElementsByTagNameNS(DAV_URI, "from");
        Element from = (Element)nl.item(0);
        fromString = Dasl2JCRXPath.processFrom(from, locator);
        nl = query.getElementsByTagNameNS(DAV_URI, "where");
        if (nl.getLength() > 0) {
            Element where = (Element)nl.item(0);
            whereString = Dasl2JCRXPath.processWhere(Dasl2JCRXPath.getChildElement(where, 1), session);
        }
        String result = fromString;
        if (whereString.length() > 0) {
            result = result + "[" + whereString + "]";
        }
        log.debug("Converted: " + result);
        return result;
    }

    private static String processSelect(Element select) {
        NodeList nl = select.getElementsByTagNameNS(DAV_URI, "allprop");
        if (nl.getLength() > 0) {
            return "";
        }
        nl = select.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i) instanceof Element) continue;
        }
        return "";
    }

    private static String processFrom(Element from, DavResourceLocator locator) {
        String path;
        StringBuffer buffer = new StringBuffer();
        NodeList nl = from.getElementsByTagNameNS(DAV_URI, "href");
        String href = nl.item(0).getFirstChild().getNodeValue();
        String rUri = locator.getHref(true);
        try {
            URI serverURI = new URI(locator.getPrefix() + locator.getWorkspacePath());
            String serverPath = serverURI.getPath();
            URI uri = new URI(href);
            path = uri.getPath();
            if (!uri.isAbsolute()) {
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                path = (uri = new URI(rUri)).getPath().endsWith("/") ? uri.getPath() + path : uri.getPath() + "/" + path;
            }
            if (path.startsWith(serverPath)) {
                path = path.substring(serverPath.length());
            }
            path = path.startsWith("/") ? "/jcr:root" + path : "/jcr:root/" + path;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            path = "";
        }
        StringTokenizer st = new StringTokenizer(path, "/");
        StringBuffer _path = new StringBuffer();
        while (st.hasMoreTokens()) {
            _path.append("/" + ISO9075.encode((String)SpecialNameChars.encode(st.nextToken())));
        }
        path = _path.toString();
        nl = from.getElementsByTagNameNS(DAV_URI, "depth");
        String scope = nl.item(0).getFirstChild().getNodeValue();
        buffer.append(Dasl2JCRXPath.stripTrailingSlashes(path));
        if ("infinity".equals(scope)) {
            buffer.append("//*");
        } else if ("1".equals(scope)) {
            buffer.append("/*");
        }
        return buffer.toString();
    }

    private static String processWhere(Node node, Session session) {
        StringBuffer buffer = new StringBuffer();
        Element e = (Element)node;
        if (Dasl2JCRXPath.isAndOp(e)) {
            NodeList children = e.getChildNodes();
            if (children.getLength() > 0) {
                int i = 1;
                Element child = null;
                do {
                    if ((child = Dasl2JCRXPath.getChildElement(e, i)) == null) continue;
                    if (i > 1) {
                        buffer.append(" and ");
                    }
                    buffer.append(Dasl2JCRXPath.processWhere(child, session));
                    ++i;
                } while (child != null);
            }
        } else if (Dasl2JCRXPath.isOrOp(e)) {
            NodeList children = e.getChildNodes();
            if (children.getLength() > 0) {
                buffer.append("(");
                int i = 1;
                Element child = null;
                do {
                    if ((child = Dasl2JCRXPath.getChildElement(e, i)) == null) continue;
                    if (i > 1) {
                        buffer.append(" or ");
                    }
                    buffer.append(Dasl2JCRXPath.processWhere(child, session));
                    ++i;
                } while (child != null);
                buffer.append(")");
            }
        } else if (Dasl2JCRXPath.isNotOp(e)) {
            Element child = Dasl2JCRXPath.getChildElement(e, 1);
            if (Dasl2JCRXPath.isCollectionTest(child)) {
                buffer.append("jcr:primaryType eq 'nt:file'");
            } else {
                buffer.append("fn:not(");
                buffer.append(Dasl2JCRXPath.processWhere(child, session));
                buffer.append(")");
            }
        } else if (Dasl2JCRXPath.isDefined(e)) {
            Element child = Dasl2JCRXPath.getChildElement(e, 1);
            buffer.append("(" + Dasl2JCRXPath.convertLOP(child, session, false, false) + " or " + Dasl2JCRXPath.convertLOP(child, session, false, true) + ")");
        } else if (Dasl2JCRXPath.isCollectionTest(e)) {
            buffer.append("jcr:primaryType eq 'nt:davcollection'");
        } else {
            boolean cs = "0".equals(e.getAttribute("casesensitive"));
            if (Dasl2JCRXPath.isEqOp(e)) {
                buffer.append(Dasl2JCRXPath.convert(e, session, OP_EQ, cs));
            } else if (Dasl2JCRXPath.isLtOp(e)) {
                buffer.append(Dasl2JCRXPath.convert(e, session, OP_LT, cs));
            } else if (Dasl2JCRXPath.isGtOp(e)) {
                buffer.append(Dasl2JCRXPath.convert(e, session, OP_GT, cs));
            } else if (Dasl2JCRXPath.isLteOp(e)) {
                buffer.append(Dasl2JCRXPath.convert(e, session, OP_LTE, cs));
            } else if (Dasl2JCRXPath.isGteOp(e)) {
                buffer.append(Dasl2JCRXPath.convert(e, session, OP_GTE, cs));
            } else if (Dasl2JCRXPath.isLikeOp(e)) {
                buffer.append(Dasl2JCRXPath.convert(e, session, OP_LIKE, cs));
            } else if (Dasl2JCRXPath.isContainsOp(e)) {
                buffer.append("jcr:contains(.,");
                buffer.append("'" + Dasl2JCRXPath.getTextContent(e) + "'");
                buffer.append(")");
            }
        }
        return buffer.toString();
    }

    private static boolean isAndOp(Element e) {
        String localName = e.getLocalName();
        String nsURI = e.getNamespaceURI();
        return nsURI != null && "and".equals(localName) && DAV_URI.equals(nsURI);
    }

    private static boolean isOrOp(Element e) {
        String localName = e.getLocalName();
        String nsURI = e.getNamespaceURI();
        return nsURI != null && "or".equals(localName) && DAV_URI.equals(nsURI);
    }

    private static boolean isNotOp(Element e) {
        String localName = e.getLocalName();
        String nsURI = e.getNamespaceURI();
        return nsURI != null && "not".equals(localName) && DAV_URI.equals(nsURI);
    }

    private static boolean isEqOp(Element e) {
        String localName = e.getLocalName();
        String nsURI = e.getNamespaceURI();
        return nsURI != null && OP_EQ.equals(localName) && DAV_URI.equals(nsURI);
    }

    private static boolean isLtOp(Element e) {
        String localName = e.getLocalName();
        String nsURI = e.getNamespaceURI();
        return nsURI != null && OP_LT.equals(localName) && DAV_URI.equals(nsURI);
    }

    private static boolean isGtOp(Element e) {
        String localName = e.getLocalName();
        String nsURI = e.getNamespaceURI();
        return nsURI != null && OP_GT.equals(localName) && DAV_URI.equals(nsURI);
    }

    private static boolean isLteOp(Element e) {
        String localName = e.getLocalName();
        String nsURI = e.getNamespaceURI();
        return nsURI != null && "lte".equals(localName) && DAV_URI.equals(nsURI);
    }

    private static boolean isGteOp(Element e) {
        String localName = e.getLocalName();
        String nsURI = e.getNamespaceURI();
        return nsURI != null && "gte".equals(localName) && DAV_URI.equals(nsURI);
    }

    private static boolean isLikeOp(Element e) {
        String localName = e.getLocalName();
        String nsURI = e.getNamespaceURI();
        return nsURI != null && "like".equals(localName) && DAV_URI.equals(nsURI);
    }

    private static boolean isContainsOp(Element e) {
        String localName = e.getLocalName();
        String nsURI = e.getNamespaceURI();
        return nsURI != null && "contains".equals(localName) && DAV_URI.equals(nsURI);
    }

    private static boolean isCollectionTest(Element e) {
        String localName = e.getLocalName();
        String nsURI = e.getNamespaceURI();
        return nsURI != null && ("iscollection".equalsIgnoreCase(localName) || "is-collection".equalsIgnoreCase(localName)) && DAV_URI.equals(nsURI);
    }

    private static boolean isDefined(Element e) {
        String localName = e.getLocalName();
        String nsURI = e.getNamespaceURI();
        return nsURI != null && "is-defined".equalsIgnoreCase(localName) && DAV_URI.equals(nsURI);
    }

    private static String convert(Element node, Session session, String operand, boolean caseinsensitive) {
        StringBuffer sb = new StringBuffer();
        boolean encode = true;
        if (operand.equals(OP_LIKE)) {
            sb.append(operand + "(");
            String lop = Dasl2JCRXPath.convertLOP(Dasl2JCRXPath.getChildElement(node, 1), session, caseinsensitive, false);
            encode = lop.indexOf("fn:name()") > -1;
            sb.append(lop);
            sb.append(",");
            sb.append(Dasl2JCRXPath.convertROP(Dasl2JCRXPath.getChildElement(node, 2), session, caseinsensitive, false));
            sb.append(")");
        } else {
            sb.append(Dasl2JCRXPath.convertLOP(Dasl2JCRXPath.getChildElement(node, 1), session, caseinsensitive, false));
            encode = sb.indexOf("fn:name()") > -1;
            sb.append(" " + operand + " ");
            sb.append(Dasl2JCRXPath.convertROP(Dasl2JCRXPath.getChildElement(node, 2), session, caseinsensitive, false));
        }
        if (!encode) {
            String t = sb.toString();
            sb.setLength(0);
            sb.append("(");
            sb.append(t);
            sb.append(" or ");
            if (operand.equals(OP_LIKE)) {
                sb.append(operand + "(");
                String lop = Dasl2JCRXPath.convertLOP(Dasl2JCRXPath.getChildElement(node, 1), session, caseinsensitive, true);
                sb.append(lop);
                sb.append(",");
                sb.append(Dasl2JCRXPath.convertROP(Dasl2JCRXPath.getChildElement(node, 2), session, caseinsensitive, encode));
                sb.append(")");
            } else {
                String lop = Dasl2JCRXPath.convertLOP(Dasl2JCRXPath.getChildElement(node, 1), session, caseinsensitive, true);
                sb.append(lop);
                sb.append(" " + operand + " ");
                sb.append(Dasl2JCRXPath.convertROP(Dasl2JCRXPath.getChildElement(node, 2), session, caseinsensitive, encode));
            }
            sb.append(")");
        }
        return sb.toString();
    }

    private static String convertLOP(Node node, Session session, boolean caseinsensitive, boolean subnode) {
        String result = null;
        Element e = (Element)node;
        if ("prop".equals(e.getLocalName())) {
            Element e2 = Dasl2JCRXPath.getChildElement(e, 1);
            try {
                String name = Dasl2JCRXPath.getJcrName(e2, session);
                result = !"fn:name()".equals(name) ? (subnode ? "jcr:content/@" + name : '@' + name) : name;
            }
            catch (RepositoryException ex) {
                ex.printStackTrace();
            }
        }
        if (result != null) {
            StringBuffer buffer = new StringBuffer();
            if (caseinsensitive) {
                buffer.append("fn:lower-case(");
            }
            buffer.append(result);
            if (caseinsensitive) {
                buffer.append(")");
            }
            return buffer.toString();
        }
        return "unknown ??";
    }

    private static boolean isDateComparison(Element e) {
        Element n;
        Element p = Dasl2JCRXPath.getChildElement(e.getParentNode(), 1);
        return "prop".equals(p.getLocalName()) && ("creationdate".equals((n = Dasl2JCRXPath.getChildElement(p, 1)).getLocalName()) || "getlastmodified".equals(n.getLocalName()));
    }

    private static String convertROP(Node node, Session session, boolean caseinsensitive, boolean encode) {
        String result = null;
        Element e = (Element)node;
        if ("literal".equals(e.getLocalName())) {
            Text e2 = (Text)e.getFirstChild();
            String literal = e2.getNodeValue();
            if (Dasl2JCRXPath.isDateComparison(e)) {
                result = "xs:dateTime('" + literal + "')";
                return result;
            }
            result = encode ? "'" + Dasl2JCRXPath.aposEscape(ISO9075.encode((String)literal)) + "'" : "'" + Dasl2JCRXPath.aposEscape(literal) + "'";
        }
        if (result != null) {
            StringBuffer buffer = new StringBuffer();
            if (caseinsensitive) {
                buffer.append(result.toLowerCase());
            } else {
                buffer.append(result);
            }
            return buffer.toString();
        }
        return "unknown ??";
    }

    private static String aposEscape(String s) {
        return s.replace("'", "''");
    }

    private static String getJcrName(Element elem, Session session) throws RepositoryException {
        String pName = ISO9075.decode((String)elem.getLocalName());
        String namespaceUri = elem.getNamespaceURI();
        String prefix = elem.getPrefix();
        if (DAV_URI.equals(namespaceUri) && "getcontenttype".equals(pName)) {
            return "jcr:content/jcr:mimeType";
        }
        if (DAV_URI.equals(namespaceUri) && "getlastmodified".equals(pName)) {
            return "jcr:lastModified";
        }
        if (DAV_URI.equals(namespaceUri) && "creationdate".equals(pName)) {
            return "jcr:created";
        }
        if (DAV_URI.equals(namespaceUri) && "displayname".equals(pName)) {
            return "fn:name()";
        }
        if (namespaceUri != null) {
            String emptyPrefix = Namespace.EMPTY_NAMESPACE.getPrefix();
            try {
                prefix = session.getNamespacePrefix(namespaceUri);
            }
            catch (NamespaceException e) {
                NamespaceRegistry nsReg = session.getWorkspace().getNamespaceRegistry();
                if (emptyPrefix.equals(prefix)) {
                    prefix = "_pre" + nsReg.getPrefixes().length + 1;
                }
                try {
                    String ns = session.getNamespaceURI(prefix);
                    boolean found = false;
                    int index = 1;
                    while (!found) {
                        try {
                            session.getNamespaceURI("wdp" + index);
                            ++index;
                        }
                        catch (NamespaceException e3) {
                            found = true;
                            nsReg.registerNamespace("wdp" + index, namespaceUri);
                            prefix = "wdp" + index;
                        }
                    }
                }
                catch (NamespaceException e2) {
                    nsReg.registerNamespace(prefix, namespaceUri);
                }
            }
            if (prefix != null && !emptyPrefix.equals(prefix)) {
                pName = prefix + ":" + pName;
            }
        }
        return pName;
    }

    private static String stripTrailingSlashes(String path) {
        StringBuffer buffer = new StringBuffer(path);
        int len = buffer.length();
        for (int i = len - 1; i >= 0 && buffer.charAt(i) == '/'; --i) {
            buffer.setLength(i);
        }
        return buffer.toString();
    }

    private static String getTextContent(Node n) {
        Node child = n.getFirstChild();
        if (child != null && child instanceof Text) {
            return ((Text)child).getNodeValue();
        }
        return "";
    }
}

