/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.util;

import com.sas.contentserver.core.jndi.SASRegistryHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.io.IOUtils;

public class MigrateTemplates {
    private static final String srcBasePath = "sasdav/Templates/notification";
    private static final String tgtBasePath = "sascontent/System/Applications";
    public static final String PROPERTY_CREATED_BY = "sas:createdBy";
    public static final String PROPERTY_MODIFIED_BY = "sas:modifiedBy";
    public static final String PROPERTY_OBJECT_TYPE = "sas:objectType";
    public static final String PROPERTY_LAST_MODIFIED = "sas:lastModified";
    public static final String PROPERTY_CREATED = "sas:created";
    public static final String PROPERTY_DESCRIPTION = "sas:description";
    public static final String PROPERTY_INTERNAL_VERSION = "sas:internalVersion";
    private static final String PROPERTY_LOCALE = "sas:locale";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String DEFAULT_CONTENT_TYPE = "text/html";
    public static final long OBJECT_TYPE_TEMPLATE = 157L;
    public static final long OBJECT_TYPE_FOLDER = 79L;
    public static final String SASADM_USER = "sasadm";
    private static final String HTML_EXTN = ".html";
    private static final String TXT_EXTN = ".txt";
    private static final String SMS_EXTN = ".sms";
    private static final String ST_EXTN = ".st";
    private static String user = null;

    public static void main(String[] args) {
        String reposHome = null;
        String pwd = null;
        String aclOutputFile = null;
        PrintWriter out = null;
        String fromVersion = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-rh")) {
                reposHome = args[++i];
                continue;
            }
            if (args[i].equals("-user")) {
                user = args[++i];
                continue;
            }
            if (args[i].equals("-pwd")) {
                pwd = args[++i];
                continue;
            }
            if (args[i].equals("-aclOutput")) {
                aclOutputFile = args[++i];
                try {
                    out = new PrintWriter(new File(aclOutputFile));
                    out.write("<acls>\n");
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    System.exit(8);
                }
                continue;
            }
            if (!args[i].equals("-fromVersion")) continue;
            fromVersion = args[++i];
        }
        System.out.println("from version " + fromVersion);
        if (reposHome == null || user == null || pwd == null) {
            System.out.println("Missing parameter values");
            System.exit(8);
        }
        SASRegistryHelper.registerJNDIDataSources();
        File reposFile = new File(reposHome);
        if (!reposFile.exists()) {
            System.out.println("Repository home '" + reposHome + "' does not exist");
            System.exit(8);
        }
        String configFile = new File(reposHome, "repository.xml").getAbsolutePath();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.url.pkgs", "org.apache.jackrabbit.core.jndi.provider:javax.naming.spi");
        env.put("java.naming.factory.initial", "org.apache.jackrabbit.core.jndi.provider.DummyInitialContextFactory");
        env.put("java.naming.provider.url", "localhost");
        try {
            InitialContext ctx = new InitialContext(env);
            SASRegistryHelper.registerRepository(ctx, "repo", configFile, reposHome, true);
            Repository repository = (Repository)ctx.lookup("repo");
            Session session = repository.login((Credentials)new SimpleCredentials(user, pwd.toCharArray()), null);
            Node srcBaseNotificationNode = MigrateTemplates.getBasePath(session, srcBasePath);
            Node tgtBaseNotificationNode = MigrateTemplates.getBasePath(session, tgtBasePath);
            tgtBaseNotificationNode = MigrateTemplates.getOrCreateFolder(tgtBaseNotificationNode, "Templates");
            tgtBaseNotificationNode = MigrateTemplates.getOrCreateFolder(tgtBaseNotificationNode, "notification");
            NodeIterator srcLocaleNodes = srcBaseNotificationNode.getNodes();
            while (srcLocaleNodes.hasNext()) {
                Node tgtLocaleNode;
                Node srcLocale = srcLocaleNodes.nextNode();
                if (!srcLocale.isNodeType("nt:davcollection")) continue;
                System.out.println("Locale " + srcLocale.getPath());
                if (!tgtBaseNotificationNode.hasNode(srcLocale.getName())) {
                    tgtLocaleNode = MigrateTemplates.getOrCreateFolder(tgtBaseNotificationNode, srcLocale.getName());
                    MigrateTemplates.addToAclXML(out, tgtLocaleNode, user, session);
                } else {
                    tgtLocaleNode = tgtBaseNotificationNode.getNode(srcLocale.getName());
                }
                NodeIterator srcTemplateNodes = srcLocale.getNodes();
                ArrayList<String> migratedTemplates = new ArrayList<String>();
                while (srcTemplateNodes.hasNext()) {
                    Node srcTemplate = srcTemplateNodes.nextNode();
                    if (!srcTemplate.isNodeType("nt:file") || tgtLocaleNode.hasNode(srcTemplate.getName())) continue;
                    if (fromVersion != null && fromVersion.equals("9.2")) {
                        StringBuffer templateContent = new StringBuffer();
                        String templateName = MigrateTemplates.getTemplateName(srcTemplate.getName());
                        System.out.println("Migrating template " + templateName);
                        if (templateName == null || migratedTemplates.contains(templateName)) continue;
                        String htmlContent = MigrateTemplates.getContent(srcLocale, templateName, HTML_EXTN);
                        String txtContent = MigrateTemplates.getContent(srcLocale, templateName, TXT_EXTN);
                        String smsContent = MigrateTemplates.getContent(srcLocale, templateName, SMS_EXTN);
                        templateContent.append(MigrateTemplates.getTemplateHeaderContent(templateName + ST_EXTN)).append(MigrateTemplates.getExtensionHeaderContent(HTML_EXTN.substring(1))).append(htmlContent).append(MigrateTemplates.getExtensionFooterContent()).append(MigrateTemplates.getExtensionHeaderContent(TXT_EXTN.substring(1))).append(txtContent).append(MigrateTemplates.getExtensionFooterContent()).append(MigrateTemplates.getExtensionHeaderContent(SMS_EXTN.substring(1))).append(smsContent).append(MigrateTemplates.getExtensionFooterContent());
                        String content = templateContent.toString();
                        System.out.println("Template Content" + content);
                        MigrateTemplates._createTemplate(tgtLocaleNode, templateName + ST_EXTN, new ByteArrayInputStream(content.getBytes()));
                        migratedTemplates.add(templateName);
                        continue;
                    }
                    if (!fromVersion.equals("9.3") || !srcTemplate.getName().endsWith(ST_EXTN)) continue;
                    System.out.println("template node " + srcTemplate.getName());
                    MigrateTemplates.createTemplate(tgtLocaleNode, srcTemplate);
                }
            }
            out.write("</acls>");
            out.close();
            session.logout();
        }
        catch (NamingException e) {
            e.printStackTrace();
            System.exit(8);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            System.exit(8);
        }
        System.exit(0);
    }

    private static Node getBasePath(Session session, String basePath) throws PathNotFoundException, RepositoryException {
        Node node = null;
        if (session.getRootNode().hasNode(basePath)) {
            node = session.getRootNode().getNode(basePath);
        }
        if (node == null) {
            System.out.println("Notification Templates could not be migrated since " + basePath + " could not be found.");
            System.exit(0);
        }
        return node;
    }

    private static String getTemplateHeaderContent(String templateName) {
        StringBuilder header = new StringBuilder();
        header.append("$! ---------------------------------------------------------------- !$\n");
        header.append("$! SAS Notification Template: " + templateName + "                      !$\n");
        header.append("$! Copyright (c) 2002-2013, SAS Institute Inc., Cary, NC, USA,      !$\n");
        header.append("$! All Rights Reserved                                              !$\n");
        header.append("$!                                                                  !$\n");
        header.append("$! ---------------------------------------------------------------- !$\n\n");
        return header.toString();
    }

    private static String getExtensionHeaderContent(String extension) {
        StringBuilder content = new StringBuilder();
        content.append("$!========================" + extension.toUpperCase() + "======================================!$\n\n");
        content.append("$if(_SAS_TEMPLATE_" + extension.toUpperCase() + ")$\n\n");
        return content.toString();
    }

    private static String getExtensionFooterContent() {
        return "\n$endif$\n\n";
    }

    private static String convertMergeVariables(String templateContent) {
        StringBuffer content = new StringBuffer();
        if (templateContent != null) {
            Matcher m = Pattern.compile("\\%\\w+").matcher(templateContent);
            while (m.find()) {
                String val = templateContent.substring(m.start(), m.end());
                val = val.substring(1, val.length());
                m.appendReplacement(content, "\\$" + val + "\\$");
            }
            m.appendTail(content);
        }
        return content.toString();
    }

    private static String getContent(Node parentNode, String templateName, String extension) throws PathNotFoundException, RepositoryException {
        Node templateNode = null;
        String content = null;
        if (parentNode.hasNode(templateName + extension)) {
            templateNode = parentNode.getNode(templateName + extension);
            try {
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)MigrateTemplates._getContent(templateNode), (Writer)writer, (String)DEFAULT_ENCODING);
                content = writer.toString();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return MigrateTemplates.convertMergeVariables(content);
    }

    private static InputStream _getContent(Node templateNode) throws ValueFormatException, PathNotFoundException, RepositoryException {
        if (templateNode != null) {
            Node contentNode = templateNode.getNode("jcr:content");
            return contentNode.getProperty("jcr:data").getBinary().getStream();
        }
        return null;
    }

    private static String getTemplateName(String templateName) {
        String name = null;
        if (templateName.contains(HTML_EXTN)) {
            name = templateName.substring(0, templateName.indexOf(HTML_EXTN));
        } else if (templateName.contains(TXT_EXTN)) {
            name = templateName.substring(0, templateName.indexOf(TXT_EXTN));
        } else if (templateName.contains(SMS_EXTN)) {
            name = templateName.substring(0, templateName.indexOf(SMS_EXTN));
        }
        return name;
    }

    private static void addToAclXML(PrintWriter out, Node tgtLocaleNode, String user, Session session) throws AccessDeniedException, ItemNotFoundException, RepositoryException {
        if (out != null) {
            session.refresh(false);
            out.write("    <acl path=\"" + tgtLocaleNode.getPath() + "\" owner=\"" + user + "\" inheriting=\"true\" parentPath=\"" + tgtLocaleNode.getParent().getPath() + "\" /> \n");
        }
    }

    private static Node getOrCreateFolder(Node parent, String child) throws RepositoryException {
        if (parent.hasNode(child)) {
            return parent.getNode(child);
        }
        Node childNode = parent.addNode(child, "nt:davcollection");
        Calendar cal = Calendar.getInstance();
        childNode.addMixin("mix:referenceable");
        childNode.addMixin("mix:lockable");
        childNode.setProperty(PROPERTY_OBJECT_TYPE, 79L);
        childNode.setProperty(PROPERTY_LAST_MODIFIED, cal);
        childNode.setProperty(PROPERTY_CREATED, cal);
        childNode.setProperty(PROPERTY_CREATED_BY, user);
        childNode.setProperty(PROPERTY_LAST_MODIFIED, cal);
        childNode.setProperty(PROPERTY_MODIFIED_BY, user);
        childNode.setProperty(PROPERTY_DESCRIPTION, "");
        parent.getSession().save();
        System.out.println("Created Locale folder " + child);
        return childNode;
    }

    private static void createTemplate(Node parent, Node srcTemplate) throws RepositoryException {
        MigrateTemplates._createTemplate(parent, srcTemplate.getName(), MigrateTemplates._getContent(srcTemplate));
    }

    private static void _createTemplate(Node parent, String templateName, InputStream templateContent) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException {
        if (!parent.hasNode(templateName)) {
            Node tgtTemplate = parent.addNode(templateName, "nt:davresource");
            Node tgtContent = tgtTemplate.addNode("jcr:content", "nt:resource");
            tgtContent.setProperty("jcr:data", templateContent);
            tgtContent.setProperty("jcr:mimeType", DEFAULT_CONTENT_TYPE);
            tgtContent.setProperty("jcr:encoding", DEFAULT_ENCODING);
            Calendar cal = Calendar.getInstance();
            tgtTemplate.addMixin("mix:referenceable");
            tgtTemplate.addMixin("mix:lockable");
            tgtTemplate.setProperty(PROPERTY_OBJECT_TYPE, 157L);
            tgtTemplate.setProperty(PROPERTY_CREATED, cal);
            tgtTemplate.setProperty(PROPERTY_CREATED_BY, user);
            tgtTemplate.setProperty(PROPERTY_LAST_MODIFIED, cal);
            tgtTemplate.setProperty(PROPERTY_MODIFIED_BY, user);
            tgtTemplate.setProperty(PROPERTY_INTERNAL_VERSION, 1L);
            tgtTemplate.setProperty(PROPERTY_LOCALE, parent.getName());
            parent.getSession().save();
            if (!tgtTemplate.isNodeType("mix:versionable")) {
                tgtTemplate.addMixin("mix:versionable");
                tgtTemplate.save();
                tgtTemplate.checkin();
            }
            parent.getSession().save();
            System.out.println("Template " + templateName + " created in " + parent.getPath());
        }
    }
}

