/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.util;

import com.sas.contentserver.commons.SpecialNameChars;
import com.sas.contentserver.core.jndi.SASRegistryHelper;
import com.sas.contentserver.security.SASDefaultAccessManager;
import com.sas.contentserver.webdav.SASDomUtil;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ExternalIdentity;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Person;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.jcr.Credentials;
import javax.jcr.Item;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.security.AccessControlManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JCRRestore {
    private static Logger log = LoggerFactory.getLogger(JCRRestore.class);
    private static final String FOLDER_TYPE = "nt:davcollection";
    private static final String FILE_TYPE = "nt:file";
    private static final String CONTENT_TYPE = "nt:unstructured";
    private static final String E_OWNER = "owner";
    private static final String E_CONTENT = "content";
    private static final String E_VERSION = "version";
    private static final String E_MODIFIED = "modified";
    private static final String E_PROPERTIES = "properties";
    private static final String E_PERMISSIONS = "permissions";
    private static final String E_MIXINS = "mixins";
    private static final String E_NAMESPACES = "namespaces";
    private static final String E_REVISIONABLE = "revisionable";
    private static final String OWNER_PRINCIPAL = "OWNER@PUBLIC";
    private static final String AUTHUSERS_PRINCIPAL = "AUTHENTICATED@PUBLIC";
    private static final String PUBLIC_PRINCIPAL = "ALL_PRINCIPALS@PUBLIC";
    private static final String NOBODY_PRINCIPAL = "NO_USER@PUBLIC";
    private static final String version = "JCRRestore (Version 2.1.0102)";
    private static final String vershdr = "-----------------------------";
    private static final String XYTHOS_NS_URI = "http://www.xythos.com/namespaces/StorageServer";
    private static final String XYTHOS_DEFAULT_VERSIONING = "default-versioning";
    private static final String SCS_ENFORCE_VERSIONABLE = "enforce-versionable";
    private static final NameFactory nameFactory = NameFactoryImpl.getInstance();
    private static final Name QN_CREATED = nameFactory.create("http://www.sas.com/type/sas", "created");
    private static final Name QN_LASTMOD = nameFactory.create("http://www.sas.com/type/sas", "lastModified");
    private static final Name QN_CREATEDBY = nameFactory.create("http://www.sas.com/type/sas", "createdBy");
    private static final Name QN_MODBY = nameFactory.create("http://www.sas.com/type/sas", "modifiedBy");
    private static SimpleDateFormat df;
    private static BufferedReader in;
    private static String fName;
    private static int restored;
    private static int numFiles;
    private static int numVersions;
    private static String sourceVServer;
    private static Repository r;
    private static Session session;
    private static ValueFactory valueFactory;
    private static AccessControlManager acMgr;
    private static Calendar cal;
    private static int counter;
    private static boolean silent;
    private static int COMMIT_SIZE;
    public static final String XML_CHECKOUT_UNLOCK_CHECKIN = "checkout-unlocked-checkin";
    private static boolean ignoreVersions;
    private static MdFactory jomaMdFact;
    private static MdObjectStore jomaStore;
    private static boolean bUseExtids;
    private static List<String> extidContextList;
    private static String davDomain;
    private static String dumpOMRMachine;
    private static String targetOMRMachine;
    private static boolean bFixWinDomain;
    private static String noAclsPath;
    private static boolean bReplace;
    private static Map<String, String> idCache;

    public static void main(String[] argv) {
        File source;
        System.out.println(vershdr);
        System.out.println(version);
        System.out.println("Current time is: " + new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(new Date()));
        System.out.println(vershdr);
        df = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss.SSS ", Locale.US);
        df.setTimeZone(TimeZone.getDefault());
        if (argv == null || argv.length == 0 || "-h".equals(argv[0]) || "-?".equals(argv[0]) || "/?".equals(argv[0])) {
            JCRRestore.printUsage();
            System.exit(1);
        }
        String user = "";
        String pwd = null;
        String configFile = null;
        String reposHome = null;
        String omrHost = "localhost";
        String targetPath = "/";
        int omrPort = 8561;
        int cacheSize = 10000;
        String oldHost = null;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-cf")) {
                configFile = argv[++i];
                continue;
            }
            if (argv[i].equals("-rh")) {
                reposHome = argv[++i];
                continue;
            }
            if (argv[i].equals("-user")) {
                user = argv[++i];
                continue;
            }
            if (argv[i].equals("-pwd")) {
                pwd = argv[++i];
                continue;
            }
            if (argv[i].equals("-useAllExtids")) {
                if (extidContextList != null) {
                    System.out.println("Conflicting external ID type specifications.");
                    JCRRestore.printUsage();
                    return;
                }
                bUseExtids = true;
                extidContextList = new ArrayList<String>(0);
                continue;
            }
            if (argv[i].equals("-extidTypes")) {
                if (extidContextList != null) {
                    System.out.println("Conflicting external ID type specifications.");
                    JCRRestore.printUsage();
                    return;
                }
                bUseExtids = true;
                String contexts = argv[++i];
                extidContextList = Arrays.asList(contexts.split(","));
                continue;
            }
            if (argv[i].equals("-davDomain")) {
                davDomain = argv[++i];
                continue;
            }
            if (argv[i].equals("-silent")) {
                silent = true;
                continue;
            }
            if (argv[i].equals("-replace")) {
                bReplace = true;
                continue;
            }
            if (argv[i].equals("-cacheSize")) {
                cacheSize = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-targetPath")) {
                if (!(targetPath = argv[++i]).startsWith("/")) {
                    targetPath = "/" + targetPath;
                }
                if (targetPath.length() > 1 && targetPath.endsWith("/")) {
                    targetPath = targetPath.substring(0, targetPath.length() - 1);
                }
                System.out.println("Target path is " + targetPath);
                continue;
            }
            if (argv[i].equals("-omrHost")) {
                omrHost = argv[++i];
                continue;
            }
            if (argv[i].equals("-omrPort")) {
                omrPort = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-noVersions")) {
                ignoreVersions = true;
                continue;
            }
            if (argv[i].equals("-commit")) {
                COMMIT_SIZE = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-fixWinDomain")) {
                bFixWinDomain = true;
                continue;
            }
            if (argv[i].equals("-oldHost")) {
                oldHost = argv[++i];
                continue;
            }
            if (argv[i].equals("-noAclsPath")) {
                noAclsPath = argv[++i];
                System.out.println("Acls will be removed from: " + noAclsPath + " thus disabling direct end user access.");
                continue;
            }
            if (argv[i].equals("-noop")) continue;
            if (argv[i].startsWith("-")) {
                System.out.println("Unknown option: " + argv[i]);
                JCRRestore.printUsage();
                return;
            }
            if (i != argv.length - 1) {
                JCRRestore.printUsage();
                return;
            }
            fName = argv[i];
        }
        if (bFixWinDomain) {
            if (omrHost == null || omrHost.equalsIgnoreCase("localhost")) {
                System.out.println("Warning: Cannot fix Windows local machine domain since the target machine name is not available");
                bFixWinDomain = false;
            } else if (oldHost == null || oldHost.equalsIgnoreCase("localhost")) {
                System.out.println("Warning: Cannot fix Windows local machine domain since the target machine name is not available");
                bFixWinDomain = false;
            } else {
                int firstDotOldHost = oldHost.indexOf(46);
                dumpOMRMachine = firstDotOldHost >= 0 ? oldHost.substring(0, firstDotOldHost) : oldHost;
                int firstDotOMRHost = omrHost.indexOf(46);
                targetOMRMachine = firstDotOMRHost >= 0 ? omrHost.substring(0, firstDotOMRHost) : omrHost;
            }
        }
        try {
            SASRegistryHelper.registerJNDIDataSources();
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.url.pkgs", "org.apache.jackrabbit.core.jndi.provider:javax.naming.spi");
            env.put("java.naming.factory.initial", "org.apache.jackrabbit.core.jndi.provider.DummyInitialContextFactory");
            env.put("java.naming.provider.url", "localhost");
            try {
                InitialContext ctx = new InitialContext(env);
                SASRegistryHelper.registerRepository(ctx, "repo", configFile, reposHome, true);
                r = (Repository)ctx.lookup("repo");
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
            catch (RepositoryException e) {
                e.printStackTrace();
            }
            if (r == null) {
                throw new RepositoryException("Valid repository not found");
            }
            session = r.login((Credentials)new SimpleCredentials(user, pwd.toCharArray()), null);
            valueFactory = session.getValueFactory();
            acMgr = session.getAccessControlManager();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        JCRRestore.connectToOMR(omrHost, omrPort, user, pwd);
        if (cacheSize > 0) {
            idCache = new HashMap<String, String>(cacheSize);
        }
        if (!(source = new File(fName)).exists()) {
            System.out.println("Source file \"" + fName + "\" does not exist.");
            JCRRestore.printUsage();
            System.exit(4);
        }
        File dumpFile = null;
        if (source.isDirectory()) {
            dumpFile = new File(source, "WFSDump.xml");
            if (!dumpFile.exists()) {
                dumpFile = new File(source, "contents.xml");
            }
            if (!dumpFile.exists()) {
                try {
                    File[] files = source.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        JCRRestore.doFileResource(files[i], targetPath);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                Document document = null;
                try {
                    document = JCRRestore.parseXML(new FileInputStream(dumpFile));
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                if (document != null) {
                    JCRRestore.restore(document, targetPath, null);
                } else {
                    System.out.println("Input file could not be parsed.");
                }
            }
        } else if (source.getName().endsWith(".zip")) {
            try {
                ZipFile z = new ZipFile(source);
                ZipEntry ze = z.getEntry("WFSDump.xml");
                if (ze == null) {
                    ze = z.getEntry("contents.xml");
                }
                if (ze != null) {
                    Document document = JCRRestore.parseXML(z.getInputStream(ze));
                    JCRRestore.restore(document, targetPath, z);
                }
                Enumeration<? extends ZipEntry> entries = z.entries();
                TreeMap<String, ZipEntry> dirs = new TreeMap<String, ZipEntry>();
                while (entries.hasMoreElements()) {
                    ze = entries.nextElement();
                    dirs.put(ze.getName(), ze);
                }
                for (Map.Entry me : dirs.entrySet()) {
                    JCRRestore.doZipEntryResource(z, (ZipEntry)me.getValue(), targetPath);
                }
            }
            catch (ZipException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                JCRRestore.doFileResource(source, targetPath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.exit(0);
    }

    private static void restore(Document document, String targetPath, ZipFile z) {
        try {
            String reply;
            Element root = document.getDocumentElement();
            sourceVServer = root.getAttribute("server");
            String sourceVersion = root.getAttribute("WFSVersion");
            String source = "";
            if (sourceVersion != null && sourceVersion.length() > 0) {
                source = "(" + sourceVersion + ")";
            }
            if (sourceVServer == null || sourceVServer.length() == 0) {
                sourceVServer = "None";
            }
            if (!silent) {
                System.out.println("Proceed? [yes/no]");
                try {
                    reply = in.readLine();
                }
                catch (Exception ex) {
                    reply = "";
                }
            } else {
                reply = "yes";
            }
            if (reply.equalsIgnoreCase("yes")) {
                System.out.println("Starting restore at " + JCRRestore.timeStamp());
                Element nsElement = JCRRestore.getElementByTagName(document.getDocumentElement(), E_NAMESPACES);
                if (nsElement != null) {
                    JCRRestore.doNamespaces(nsElement, session);
                }
                NodeList resources = root.getElementsByTagName("resource");
                for (int i = 0; i < resources.getLength(); ++i) {
                    Element resource = (Element)resources.item(i);
                    JCRRestore.doResource(resource, targetPath, z);
                }
                session.save();
                System.out.println(restored + " total resources restored. " + numFiles + " files");
                if (numVersions > 0) {
                    System.out.println(" (" + numVersions + " versions)");
                }
                System.out.println("Restore completed at " + JCRRestore.timeStamp());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void doZipEntryResource(ZipFile z, ZipEntry ze, String path) throws Exception {
        String relPath = ze.getName();
        if (relPath.startsWith("/")) {
            relPath = relPath.substring(1);
        }
        path = SpecialNameChars.encode(path);
        relPath = SpecialNameChars.encode(relPath);
        String absPath = JCRRestore.addPath(path, relPath);
        System.out.println("Attempting to restore " + absPath);
        try {
            Item oldItem = session.getItem(absPath);
            if (!bReplace) {
                System.out.println("Skipping " + SpecialNameChars.decode(absPath) + " - already exists");
                return;
            }
            oldItem.remove();
        }
        catch (PathNotFoundException oldItem) {
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return;
        }
        Item item = session.getItem(path);
        if (item == null || item instanceof Property) {
            System.exit(100);
        }
        Node parent = (Node)item;
        try {
            Node newFile = null;
            if (ze.isDirectory()) {
                newFile = parent.addNode(relPath, FOLDER_TYPE);
            } else {
                newFile = parent.addNode(relPath, FILE_TYPE);
                Node content = newFile.addNode("jcr:content", CONTENT_TYPE);
                content.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar());
                try {
                    content.setProperty("jcr:data", z.getInputStream(ze));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++numFiles;
            }
            System.out.println("Restored " + SpecialNameChars.decode(absPath));
            ++restored;
            session.save();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    private static void doFileResource(File file, String path) throws Exception {
        String name = JCRRestore.addPath(path, file.getName());
        name = SpecialNameChars.encode(name);
        try {
            Item oldItem = session.getItem(name);
            if (!bReplace) {
                System.out.println("Skipping " + SpecialNameChars.decode(name) + " - already exists");
                return;
            }
            oldItem.remove();
        }
        catch (PathNotFoundException oldItem) {
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return;
        }
        String parentName = JCRRestore.getParentName(name);
        String baseName = JCRRestore.getBaseName(name);
        Item item = session.getItem(parentName);
        if (item == null || item instanceof Property) {
            System.exit(100);
        }
        Node parent = (Node)item;
        try {
            Node newFile = null;
            if (file.isDirectory()) {
                newFile = parent.addNode(baseName, FOLDER_TYPE);
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    JCRRestore.doFileResource(files[i], name);
                }
            } else {
                newFile = parent.addNode(baseName, FILE_TYPE);
                Node content = newFile.addNode("jcr:content", CONTENT_TYPE);
                content.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar());
                try {
                    content.setProperty("jcr:data", (InputStream)new FileInputStream(file));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++numFiles;
            }
            System.out.println("Restored " + SpecialNameChars.decode(name));
            ++restored;
            session.save();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    private static Element getElementByTagName(Element element, String name) {
        NodeList nl = element.getElementsByTagName(name);
        if (nl.getLength() > 0) {
            return (Element)nl.item(0);
        }
        return null;
    }

    private static void doResource(Element resource, String targetPath, ZipFile z) throws Exception {
        String relPath = resource.getAttribute("name");
        if (relPath.startsWith("/")) {
            relPath = relPath.substring(1);
        }
        targetPath = SpecialNameChars.encode(targetPath);
        relPath = SpecialNameChars.encode(relPath);
        String absPath = JCRRestore.addPath(targetPath, relPath);
        absPath = JCRRestore.stripTrailingSlashes(absPath);
        boolean bAddPermissions = true;
        if (noAclsPath != null && absPath.startsWith(noAclsPath)) {
            bAddPermissions = false;
        }
        try {
            Item oldItem = session.getItem(absPath);
            if (!bReplace) {
                System.out.println("Skipping " + SpecialNameChars.decode(absPath) + " - already exists");
                return;
            }
            oldItem.remove();
        }
        catch (PathNotFoundException oldItem) {
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return;
        }
        Item item = session.getItem(targetPath);
        if (item == null || item instanceof Property) {
            System.exit(100);
        }
        Node parent = (Node)item;
        try {
            Element updatedElement;
            Element propertiesElement;
            Element mixinsElement;
            boolean isDirectory;
            Node newFile = null;
            Element ownerElement = JCRRestore.getElementByTagName(resource, E_OWNER);
            Element contentElement = JCRRestore.getElementByTagName(resource, E_CONTENT);
            NodeList versionElements = resource.getElementsByTagName(E_VERSION);
            boolean revisionable = true;
            Element revisionableElement = JCRRestore.getElementByTagName(resource, E_REVISIONABLE);
            if (revisionableElement != null) {
                revisionable = Boolean.parseBoolean(revisionableElement.getFirstChild().getNodeValue());
            }
            if (ownerElement != null) {
                // empty if block
            }
            boolean bl = isDirectory = contentElement == null && versionElements.getLength() == 0;
            if (isDirectory) {
                newFile = parent.addNode(relPath, FOLDER_TYPE);
            } else if (ignoreVersions || versionElements == null || versionElements.getLength() == 0 || !revisionable) {
                String contentsFile = contentElement.getFirstChild().getNodeValue();
                String contentType = contentElement.getAttribute("mimetype");
                newFile = parent.addNode(relPath, FILE_TYPE);
                Node content = newFile.addNode("jcr:content", CONTENT_TYPE);
                content.setProperty("jcr:mimeType", JCRRestore.getMimeType(contentType));
                content.setProperty("jcr:encoding", JCRRestore.getEncoding(contentType));
                content.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar());
                try {
                    InputStream is;
                    if (z != null) {
                        ZipEntry ze = z.getEntry(contentsFile);
                        is = z.getInputStream(ze);
                    } else {
                        File file = new File(contentsFile);
                        if (!file.isAbsolute()) {
                            file = new File(fName, contentsFile);
                        }
                        is = new FileInputStream(file);
                    }
                    content.setProperty("jcr:data", is);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++numFiles;
            } else {
                Node content = null;
                for (int i = 0; i < versionElements.getLength(); ++i) {
                    Element versionElement = (Element)versionElements.item(i);
                    Element propertiesElement2 = JCRRestore.getElementByTagName(versionElement, E_PROPERTIES);
                    Element vContentElement = JCRRestore.getElementByTagName(versionElement, "version-content");
                    String contentsFile = vContentElement.getFirstChild().getNodeValue();
                    File file = new File(contentsFile);
                    if (!file.isAbsolute()) {
                        file = new File(fName, contentsFile);
                    }
                    FileInputStream contents = new FileInputStream(file);
                    String contentType = contentElement.getAttribute("mimetype");
                    if (newFile == null) {
                        newFile = parent.addNode(relPath, FILE_TYPE);
                        newFile.addMixin("mix:versionable");
                        content = newFile.addNode("jcr:content", CONTENT_TYPE);
                        content.setProperty("jcr:auto-version", XML_CHECKOUT_UNLOCK_CHECKIN);
                    } else {
                        newFile.checkout();
                    }
                    content.setProperty("jcr:mimeType", JCRRestore.getMimeType(contentType));
                    content.setProperty("jcr:encoding", JCRRestore.getEncoding(contentType));
                    content.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar());
                    try {
                        content.setProperty("jcr:data", (InputStream)new FileInputStream(file));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (propertiesElement2 != null) {
                        JCRRestore.doProperties(propertiesElement2, newFile);
                    }
                    ((InputStream)contents).close();
                    parent.save();
                    newFile.checkin();
                    if (i != versionElements.getLength() - 1) continue;
                    newFile.checkout();
                }
                ++numFiles;
                numVersions += versionElements.getLength();
            }
            try {
                Property autoOwner = newFile.getProperty("jcr:owner");
                autoOwner.remove();
            }
            catch (PathNotFoundException autoOwner) {
                // empty catch block
            }
            if (ownerElement != null) {
                if (bAddPermissions) {
                    String ownerStr = JCRRestore.convertToSCSPrincipal(ownerElement.getFirstChild().getNodeValue());
                    if (ownerStr != null) {
                        newFile.setProperty("jcr:owner", ownerStr);
                    }
                } else {
                    System.out.println("NOTE: Omitting owner for " + SpecialNameChars.decode(absPath) + " due to the -noAclPath option.");
                }
            }
            if ((mixinsElement = JCRRestore.getElementByTagName(resource, E_MIXINS)) != null) {
                JCRRestore.doMixins(mixinsElement, newFile);
            }
            if ((propertiesElement = JCRRestore.getElementByTagName(resource, E_PROPERTIES)) != null) {
                JCRRestore.doProperties(propertiesElement, newFile);
            }
            Element permissionsElement = JCRRestore.getElementByTagName(resource, E_PERMISSIONS);
            try {
                Node autoAcl = newFile.getNode("jcr:acl");
                autoAcl.remove();
            }
            catch (PathNotFoundException autoAcl) {
                // empty catch block
            }
            if (permissionsElement != null) {
                if (bAddPermissions) {
                    JCRRestore.doPermissions(permissionsElement, newFile);
                } else {
                    System.out.println("NOTE: Omitting ACLs for " + SpecialNameChars.decode(absPath) + " due to the -noAclPath option.");
                }
            }
            if ((updatedElement = JCRRestore.getElementByTagName(resource, E_MODIFIED)) != null) {
                JCRRestore.doUpdatedProperties(updatedElement, newFile);
            }
            System.out.println("Restored " + SpecialNameChars.decode(absPath));
            if (++restored % COMMIT_SIZE == 0) {
                session.save();
            }
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    private static String getMimeType(String contentType) {
        String mimeType = contentType;
        if (mimeType == null) {
            return mimeType;
        }
        int semi = mimeType.indexOf(";");
        return semi > 0 ? mimeType.substring(0, semi) : mimeType;
    }

    private static String getEncoding(String contentType) {
        int equal;
        if (contentType == null || (equal = contentType.indexOf("charset=")) == -1) {
            return null;
        }
        String encoding = contentType.substring(equal + 8);
        int semi = encoding.indexOf(";");
        if (semi != -1) {
            encoding = encoding.substring(0, semi);
        }
        return encoding;
    }

    private static void doMixins(Element element, Node f) {
        try {
            NodeList nodes = element.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                org.w3c.dom.Node node = nodes.item(i);
                if (node.getNodeType() != 1) continue;
                Element mixinElement = (Element)node;
                String mixin = mixinElement.getFirstChild().getNodeValue();
                try {
                    f.addMixin(mixin);
                    continue;
                }
                catch (NoSuchNodeTypeException e) {
                    System.out.println("Invalid mixin '" + mixin + "', ignoring");
                }
            }
        }
        catch (RepositoryException xe) {
            System.out.println("Error setting mixins");
            System.out.println("Error " + xe.getMessage());
        }
    }

    private static void doNamespaces(Element element, Session session) {
        try {
            NodeList nodes = element.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                org.w3c.dom.Node node = nodes.item(i);
                if (node.getNodeType() != 1) continue;
                Element nsElement = (Element)node;
                String nsURI = nsElement.getNamespaceURI();
                String prefix = nsElement.getPrefix();
                try {
                    String assignedNsURI = session.getWorkspace().getNamespaceRegistry().getURI(prefix);
                    if (nsURI.equals(assignedNsURI)) continue;
                    System.out.println("Unable to assign prefix '" + prefix + "' to namespace '" + nsURI + "'");
                    System.out.println("It is already assigned to namespace URI '" + assignedNsURI + "'");
                    continue;
                }
                catch (NamespaceException e) {
                    try {
                        session.getWorkspace().getNamespaceRegistry().registerNamespace(prefix, nsURI);
                        System.out.println("Assigned prefix '" + prefix + "' to namespace URI '" + nsURI + "'");
                        continue;
                    }
                    catch (NamespaceException e2) {
                        System.out.println("Unable to assign prefix '" + prefix + "' to namespace URI '" + nsURI + "'");
                    }
                }
            }
        }
        catch (RepositoryException xe) {
            System.out.println("Error setting nampespace");
            System.out.println("Error " + xe.getMessage());
        }
    }

    private static void doPermissions(Element element, Node f) {
        try {
            NodeList nodes = element.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                org.w3c.dom.Node node = nodes.item(i);
                if (node.getNodeType() != 1) continue;
                Element permission = (Element)node;
                String principal = permission.getAttribute("principal");
                if ((principal = JCRRestore.convertToSCSPrincipal(principal)) == null || !permission.hasChildNodes()) continue;
                Boolean[] permissions = new Boolean[8];
                for (int j = 0; j < 8; ++j) {
                    permissions[j] = false;
                }
                String privileges = permission.getFirstChild().getNodeValue();
                StringTokenizer st = new StringTokenizer(privileges);
                boolean bitset = false;
                while (st.hasMoreTokens()) {
                    String privilege = st.nextToken();
                    if ("READ".equals(privilege)) {
                        permissions[0] = true;
                        bitset = true;
                        continue;
                    }
                    if ("WRITE".equals(privilege)) {
                        permissions[1] = true;
                        bitset = true;
                        continue;
                    }
                    if ("DELETE".equals(privilege)) {
                        permissions[2] = true;
                        bitset = true;
                        continue;
                    }
                    if ("PERMISSIONS".equals(privilege)) {
                        permissions[3] = true;
                        bitset = true;
                        continue;
                    }
                    if ("IREAD".equals(privilege)) {
                        permissions[4] = true;
                        bitset = true;
                        continue;
                    }
                    if ("IWRITE".equals(privilege)) {
                        permissions[5] = true;
                        bitset = true;
                        continue;
                    }
                    if ("IDELETE".equals(privilege)) {
                        permissions[6] = true;
                        bitset = true;
                        continue;
                    }
                    if (!"IPERMISSIONS".equals(privilege)) continue;
                    permissions[7] = true;
                    bitset = true;
                }
                if (principal == null || !bitset) continue;
                ((SASDefaultAccessManager)acMgr).setAccessControlEntry(f, principal, permissions, false);
            }
        }
        catch (RepositoryException xe) {
            System.out.println("Error setting permissions for ");
            System.out.println("Error " + xe.getMessage());
        }
    }

    private static String handleDavDomain(String src) {
        int atIndex = src.lastIndexOf("@");
        if (atIndex != -1) {
            String domain = src.substring(atIndex + 1);
            if (davDomain != null && !domain.equals(davDomain)) {
                return null;
            }
            return src.substring(0, atIndex);
        }
        return src;
    }

    private static void doUpdatedProperties(Element element, Node f) {
        Timestamp lastUpdatedTimestamp = Timestamp.valueOf(element.getAttribute("date"));
        if (lastUpdatedTimestamp != null) {
            try {
                if (!f.isNodeType(FILE_TYPE)) {
                    return;
                }
                if (f.hasNode("jcr:content")) {
                    cal.setTimeInMillis(lastUpdatedTimestamp.getTime());
                    f.getNode("jcr:content").setProperty("jcr:lastModified", valueFactory.createValue(cal));
                }
            }
            catch (RepositoryException xe) {
                System.out.println("Error " + xe.getMessage());
                System.out.println("Setting lastUpated date " + lastUpdatedTimestamp + " for file ");
            }
        }
    }

    private static void doProperties(Element element, Node f) {
        NodeList nodes = element.getChildNodes();
        try {
            if (f.hasNode("jcr:content")) {
                f = f.getNode("jcr:content");
            }
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            org.w3c.dom.Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element property = (Element)node;
            String prop = property.getFirstChild().getNodeValue();
            int p1 = prop.indexOf("{");
            int p2 = prop.indexOf("}");
            int p3 = prop.indexOf("=");
            String ns = prop.substring(p1 + 1, p2);
            String name = prop.substring(p2 + 1, p3);
            String value = property.getFirstChild() != property.getLastChild() ? property.getLastChild().getNodeValue() : prop.substring(p3 + 1);
            if (XYTHOS_NS_URI.equals(ns) && XYTHOS_DEFAULT_VERSIONING.equals(name)) {
                ns = "http://www.jcp.org/jcr/1.0";
                name = SCS_ENFORCE_VERSIONABLE;
            }
            String prefix = null;
            try {
                NamespaceRegistry nsr = session.getWorkspace().getNamespaceRegistry();
                try {
                    prefix = nsr.getPrefix(ns);
                }
                catch (NamespaceException e) {
                    boolean found = false;
                    while (!found) {
                        try {
                            session.getNamespaceURI("wdp" + counter);
                            ++counter;
                        }
                        catch (NamespaceException e3) {
                            found = true;
                            prefix = "wdp" + counter;
                            nsr.registerNamespace(prefix, ns);
                            ++counter;
                        }
                    }
                }
                Name qName = nameFactory.create(ns, name);
                if (QN_CREATED.equals(qName)) {
                    f.setProperty(JCRRestore.makeName(prefix, name), Calendar.getInstance());
                    continue;
                }
                if (QN_LASTMOD.equals(qName)) {
                    f.setProperty(JCRRestore.makeName(prefix, name), Calendar.getInstance());
                    continue;
                }
                if (QN_CREATEDBY.equals(qName)) {
                    f.setProperty(JCRRestore.makeName(prefix, name), f.getSession().getUserID());
                    continue;
                }
                if (QN_MODBY.equals(qName)) {
                    f.setProperty(JCRRestore.makeName(prefix, name), f.getSession().getUserID());
                    continue;
                }
                f.setProperty(JCRRestore.makeName(prefix, name), value);
                continue;
            }
            catch (RepositoryException xe) {
                System.out.println("Error " + xe.getMessage());
                System.out.println("Setting property " + name + " for file ");
            }
        }
    }

    private static String makeName(String prefix, String name) {
        if (prefix == null || prefix.length() == 0) {
            return name;
        }
        return prefix + ':' + name;
    }

    private static String timeStamp() {
        return df.format(new Date(System.currentTimeMillis()));
    }

    private static void printUsage() {
        System.out.println("Usage:\tjava JCRRestore [-cf configFile][-rh reposHome][-omrHost host][-omrPort port][-user user [-pwd password]][-targetPath path][-srcHost oldhost] [-fixWinDomain] [-noaclTree \"protected-path\"] [-extidTypes \"import-types\"] dir");
        System.out.println("   where: ");
        System.out.println("       configFile: is the path to the repository.xml file.");
        System.out.println("       reposHome: is the path to the top-level repository directory (containing \"repository\" and \"workspaces\" subdirectories.");
        System.out.println("       omrHost, omrPort: connection information for SAS Metadata Server.");
        System.out.println("       user: is a logon ID for an SAS Metadata Server unrestricted administrator (such as \"sasadm\").");
        System.out.println("       targetPath: absolute path for the target restore location in the server (default is \"/\").");
        System.out.println("       import-types: is one or more (comma-separated) external identity types like \"Active Directory Import\" created by an identity import job.");
        System.out.println("                     An optional alternative to identifying users based on SAS Metadata Person name.");
        System.out.println("       dir: is the directory that contains the dump.");
        System.out.println("       protected-path: path designating a subtree from which all ACLs should be removed");
        System.out.println("       oldhost: DNS name of prior metadata server which is used by the -fixWinDomain option recognize local (Windows) IDs whose machine name has been changed");
    }

    private static Document parseXML(InputStream is) {
        Document document = null;
        try {
            document = SASDomUtil.parseDocument((InputStream)is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return document;
    }

    private static String getParentName(String name) {
        int p = name.lastIndexOf("/");
        if (p > 0) {
            return name.substring(0, p);
        }
        return "/";
    }

    private static String getBaseName(String name) {
        int p = name.lastIndexOf("/");
        if (p != -1) {
            return name.substring(p + 1);
        }
        return "";
    }

    public static String stripTrailingSlashes(String path) {
        StringBuffer buffer = new StringBuffer(path);
        int len = buffer.length();
        for (int i = len - 1; i >= 0 && buffer.charAt(i) == '/'; --i) {
            buffer.setLength(i);
        }
        return buffer.toString();
    }

    private static String convertToSCSPrincipal(String srcPrincipal) {
        String scsPrincipal;
        if (OWNER_PRINCIPAL.equals(srcPrincipal)) {
            scsPrincipal = "jcr:owner";
        } else if (AUTHUSERS_PRINCIPAL.equals(srcPrincipal)) {
            scsPrincipal = "jcr:authenticated";
        } else if (PUBLIC_PRINCIPAL.equals(srcPrincipal)) {
            scsPrincipal = "jcr:all";
        } else if (NOBODY_PRINCIPAL.equals(srcPrincipal)) {
            scsPrincipal = null;
        } else if (srcPrincipal.startsWith("GROUPS\\")) {
            String work = srcPrincipal.substring("GROUPS\\".length());
            scsPrincipal = JCRRestore.handleDavDomain(work);
            scsPrincipal = scsPrincipal == null ? "unknown/" + work : (JCRRestore.isPrincipalNameSafe(scsPrincipal) ? "group/" + scsPrincipal.replace('+', ' ') : "unknown/" + scsPrincipal);
        } else {
            String login = srcPrincipal;
            if ((login = JCRRestore.handleDavDomain(login)) == null) {
                System.out.println("Error: Inconsistent DAV domain for login (" + login + ").");
                scsPrincipal = "unknown/" + srcPrincipal;
            } else {
                scsPrincipal = JCRRestore.loginToJcrPrincipal(login);
            }
        }
        if (scsPrincipal != null) {
            System.out.println("DEBUG: Converted principal (" + srcPrincipal + ") to SCS principal (" + scsPrincipal + ")");
        } else {
            System.out.println("DEBUG: Principal (" + srcPrincipal + ") is ignored in SCS.");
        }
        return scsPrincipal;
    }

    public static void connectToOMR(String host, int port, String username, String password) {
        try {
            jomaMdFact = new MdFactoryImpl(false);
            jomaMdFact.makeOMRConnection(host, Integer.toString(port), username, password);
            jomaStore = jomaMdFact.createObjectStore();
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
        }
        catch (MdException ex) {
            ex.printStackTrace();
        }
    }

    public static String loginToJcrPrincipal(String login) {
        int slashLoc;
        String result = null;
        result = idCache.get(login);
        if (result != null) {
            return result;
        }
        String targetLogin = login;
        if (bFixWinDomain && (slashLoc = login.indexOf(92)) > 0 && login.substring(0, slashLoc).equalsIgnoreCase(dumpOMRMachine)) {
            targetLogin = targetOMRMachine + "\\" + login.substring(slashLoc + 1);
            System.out.println("Note: Windows localhost change converted login ID: " + login + " to: " + targetLogin);
        }
        try {
            String sOptions = JCRRestore.getXMLSelectString(targetLogin);
            List omiLogins = jomaMdFact.getOMIUtil().getMetadataObjectsSubset((MdStore)jomaStore, jomaMdFact.getOMIUtil().getFoundationReposID(), "Login", 384, sOptions);
            if (omiLogins.size() == 0) {
                System.out.println("Error: Can't find login for: (" + targetLogin + ").");
                result = "unknown/" + targetLogin;
            } else {
                Login omiLogin = (Login)omiLogins.get(0);
                Identity omiIdentity = omiLogin.getAssociatedIdentity();
                if (omiIdentity == null) {
                    System.out.println("Error: Can't find Metadata Person for: (" + targetLogin + ").");
                    result = "unknown/" + targetLogin;
                } else if (!(omiIdentity instanceof Person)) {
                    System.out.println("Error: Can't find Metadata Person for: (" + targetLogin + ").");
                    result = "unknown/" + targetLogin;
                } else {
                    AssociationList extidList;
                    Person omiPerson = (Person)omiIdentity;
                    String extid = null;
                    if (bUseExtids && !(extidList = omiPerson.getExternalIdentities(true)).isEmpty()) {
                        if (extidContextList.isEmpty()) {
                            ExternalIdentity omiExtid = (ExternalIdentity)extidList.get(0);
                            extid = omiExtid.getContext() + "/" + omiExtid.getIdentifier();
                        } else {
                            Iterator<String> sitePrefIter = extidContextList.iterator();
                            block3: while (sitePrefIter.hasNext() && extid == null) {
                                String preferredContext = sitePrefIter.next();
                                for (ExternalIdentity omiExtid : extidList) {
                                    if (!omiExtid.getContext().equals(preferredContext)) continue;
                                    extid = omiExtid.getContext() + "/" + omiExtid.getIdentifier();
                                    continue block3;
                                }
                            }
                        }
                    }
                    result = extid != null ? "extid/" + extid : "person/" + omiPerson.getName();
                }
            }
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
        }
        catch (MdException ex) {
            ex.printStackTrace();
        }
        idCache.put(login, result);
        return result;
    }

    public static String getXMLSelectString(String userId) {
        int SELECT_BUFFER_INIT = 128;
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("<XMLSelect Search=\"*");
        if (userId != null) {
            buffer.append("[@UserId = '" + userId + "']");
        }
        buffer.append("\"/>");
        return buffer.toString();
    }

    private static boolean isPrincipalNameSafe(String name) {
        int length = "/:\\<>[]\"'#%".length();
        for (int i = 0; i < length; ++i) {
            char reservedChar = "/:\\<>[]\"'#%".charAt(i);
            if (name.indexOf(reservedChar) < 0) continue;
            System.out.println("Principal (" + name + ") not used because it contains the reserved character: " + Character.toString(reservedChar) + ".");
            return false;
        }
        return true;
    }

    public static String addPath(String path, String relPath) {
        String tmpSegment;
        StringBuffer tmp = new StringBuffer(path.trim());
        if (tmp.length() == 0 || tmp.charAt(tmp.length() - 1) != '/') {
            tmp.append("/");
        }
        if ((tmpSegment = relPath.trim()).length() > 0 && tmpSegment.charAt(0) == '/') {
            if (tmpSegment.length() > 1) {
                tmp.append(tmpSegment.substring(1));
            }
        } else {
            tmp.append(tmpSegment);
        }
        return tmp.toString();
    }

    static {
        in = new BufferedReader(new InputStreamReader(System.in));
        fName = null;
        restored = 0;
        numFiles = 0;
        numVersions = 0;
        cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        counter = 1;
        silent = false;
        COMMIT_SIZE = 50;
        ignoreVersions = false;
        bUseExtids = false;
        extidContextList = null;
        davDomain = null;
        bFixWinDomain = false;
        noAclsPath = null;
        bReplace = false;
        idCache = null;
    }
}

